/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.principal;

import com.openkm.core.Config;
import com.openkm.principal.PrincipalAdapter;
import com.openkm.principal.PrincipalAdapterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPrincipalAdapter
implements PrincipalAdapter {
    private static Logger log = LoggerFactory.getLogger(LdapPrincipalAdapter.class);

    @Override
    public List<String> getUsers() throws PrincipalAdapterException {
        log.debug("getUsers()");
        ArrayList<String> list = new ArrayList<String>();
        List<String> ldap = this.ldapSearch(Config.PRINCIPAL_LDAP_SERVER, Config.PRINCIPAL_LDAP_SECURITY_PRINCIPAL, Config.PRINCIPAL_LDAP_SECURITY_CREDENTIALS, Config.PRINCIPAL_LDAP_USER_SEARCH_BASE, Config.PRINCIPAL_LDAP_USER_SEARCH_FILTER, Config.PRINCIPAL_LDAP_USER_ATTRIBUTE);
        for (String user : ldap) {
            if (Config.SYSTEM_USER.equals(user)) continue;
            if (Config.SYSTEM_LOGIN_LOWERCASE) {
                user = user.toLowerCase();
            }
            list.add(user);
        }
        log.debug("getUsers: {}", list);
        return list;
    }

    @Override
    public List<String> getRoles() throws PrincipalAdapterException {
        log.debug("getRoles()");
        ArrayList<String> list = new ArrayList<String>();
        List<String> ldap = this.ldapSearch(Config.PRINCIPAL_LDAP_SERVER, Config.PRINCIPAL_LDAP_SECURITY_PRINCIPAL, Config.PRINCIPAL_LDAP_SECURITY_CREDENTIALS, Config.PRINCIPAL_LDAP_ROLE_SEARCH_BASE, Config.PRINCIPAL_LDAP_ROLE_SEARCH_FILTER, Config.PRINCIPAL_LDAP_ROLE_ATTRIBUTE);
        for (String role : ldap) {
            list.add(role);
        }
        log.debug("getRoles: {}", list);
        return list;
    }

    @Override
    public String getMail(String user) throws PrincipalAdapterException {
        log.debug("getMail({})", (Object)user);
        String mail = null;
        List<String> ldap = this.ldapSearch(Config.PRINCIPAL_LDAP_SERVER, Config.PRINCIPAL_LDAP_SECURITY_PRINCIPAL, Config.PRINCIPAL_LDAP_SECURITY_CREDENTIALS, MessageFormat.format(Config.PRINCIPAL_LDAP_MAIL_SEARCH_BASE, user), MessageFormat.format(Config.PRINCIPAL_LDAP_MAIL_SEARCH_FILTER, user), Config.PRINCIPAL_LDAP_MAIL_ATTRIBUTE);
        if (!ldap.isEmpty()) {
            mail = ldap.get(0);
        }
        log.debug("getMail: {}", mail);
        return mail;
    }

    @Override
    public String getName(String user) throws PrincipalAdapterException {
        log.debug("getName({})", (Object)user);
        String name = null;
        List<String> ldap = this.ldapSearch(Config.PRINCIPAL_LDAP_SERVER, Config.PRINCIPAL_LDAP_SECURITY_PRINCIPAL, Config.PRINCIPAL_LDAP_SECURITY_CREDENTIALS, MessageFormat.format(Config.PRINCIPAL_LDAP_USERNAME_SEARCH_BASE, user), MessageFormat.format(Config.PRINCIPAL_LDAP_USERNAME_SEARCH_FILTER, user), Config.PRINCIPAL_LDAP_USERNAME_ATTRIBUTE);
        if (!ldap.isEmpty()) {
            name = ldap.get(0);
        }
        log.debug("getName: {}", name);
        return name;
    }

    private String getUserByDN(String dn) throws PrincipalAdapterException {
        log.debug("getUserByDN({})", (Object)dn);
        String user = null;
        List<String> ldap = this.ldapSearch(Config.PRINCIPAL_LDAP_SERVER, Config.PRINCIPAL_LDAP_SECURITY_PRINCIPAL, Config.PRINCIPAL_LDAP_SECURITY_CREDENTIALS, dn, Config.PRINCIPAL_LDAP_USER_SEARCH_FILTER, Config.PRINCIPAL_LDAP_USER_ATTRIBUTE);
        if (!ldap.isEmpty()) {
            user = ldap.get(0);
        }
        log.debug("getUserByDN: {}", user);
        return user;
    }

    private String getDN(String user) throws PrincipalAdapterException {
        log.debug("getDN({})", (Object)user);
        String dn = null;
        List<String> ldap = this.ldapSearch(Config.PRINCIPAL_LDAP_SERVER, Config.PRINCIPAL_LDAP_SECURITY_PRINCIPAL, Config.PRINCIPAL_LDAP_SECURITY_CREDENTIALS, MessageFormat.format(Config.PRINCIPAL_LDAP_USERNAME_SEARCH_BASE, user), MessageFormat.format(Config.PRINCIPAL_LDAP_USERNAME_SEARCH_FILTER, user), "dn");
        if (!ldap.isEmpty()) {
            dn = ldap.get(0);
        }
        log.debug("getDN: {}", dn);
        return dn;
    }

    @Override
    public List<String> getUsersByRole(String role) throws PrincipalAdapterException {
        log.debug("getUsersByRole({})", (Object)role);
        ArrayList<String> list = new ArrayList<String>();
        List<String> ldap = this.ldapSearch(Config.PRINCIPAL_LDAP_SERVER, Config.PRINCIPAL_LDAP_SECURITY_PRINCIPAL, Config.PRINCIPAL_LDAP_SECURITY_CREDENTIALS, MessageFormat.format(Config.PRINCIPAL_LDAP_USERS_BY_ROLE_SEARCH_BASE, role), MessageFormat.format(Config.PRINCIPAL_LDAP_USERS_BY_ROLE_SEARCH_FILTER, role), Config.PRINCIPAL_LDAP_USERS_BY_ROLE_ATTRIBUTE);
        boolean usePosixGroups = true;
        if ("uniqueMember".equals(Config.PRINCIPAL_LDAP_USERS_BY_ROLE_ATTRIBUTE)) {
            usePosixGroups = false;
        }
        Iterator<String> it = ldap.iterator();
        while (it.hasNext()) {
            String user = null;
            if (!usePosixGroups) {
                String dn = it.next();
                user = this.getUserByDN(dn);
            } else {
                user = it.next();
            }
            if (user == null || Config.SYSTEM_USER.equals(user)) continue;
            if (Config.SYSTEM_LOGIN_LOWERCASE) {
                user = user.toLowerCase();
            }
            list.add(user);
        }
        log.debug("getUsersByRole: {}", list);
        return list;
    }

    @Override
    public List<String> getRolesByUser(String user) throws PrincipalAdapterException {
        log.debug("getRolesByUser({})", (Object)user);
        ArrayList<String> list = new ArrayList<String>();
        String dn = "";
        if (Config.PRINCIPAL_LDAP_ROLES_BY_USER_SEARCH_FILTER.contains("{1}")) {
            dn = this.getDN(user);
        }
        List<String> ldap = this.ldapSearch(Config.PRINCIPAL_LDAP_SERVER, Config.PRINCIPAL_LDAP_SECURITY_PRINCIPAL, Config.PRINCIPAL_LDAP_SECURITY_CREDENTIALS, MessageFormat.format(Config.PRINCIPAL_LDAP_ROLES_BY_USER_SEARCH_BASE, user, dn), MessageFormat.format(Config.PRINCIPAL_LDAP_ROLES_BY_USER_SEARCH_FILTER, user, dn), Config.PRINCIPAL_LDAP_ROLES_BY_USER_ATTRIBUTE);
        for (String role : ldap) {
            list.add(role);
        }
        log.debug("getRolesByUser: {}", list);
        return list;
    }

    public List<String> ldapSearch(String url, String principal, String credentials, String searchBase, String searchFilter, String attribute) {
        log.debug("ldapSearch({}, {}, {}, {}, {}, {})", new Object[]{url, principal, credentials, searchBase, searchFilter, attribute});
        ArrayList<String> al = new ArrayList<String>();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.provider.url", url);
        if (!"".equals(Config.PRINCIPAL_LDAP_REFERRAL)) {
            env.put("java.naming.referral", Config.PRINCIPAL_LDAP_REFERRAL);
        }
        if (!principal.equals("")) {
            env.put("java.naming.security.principal", principal);
        }
        if (!credentials.equals("")) {
            env.put("java.naming.security.credentials", credentials);
        }
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(searchBase, searchFilter, searchCtls);
            while (results.hasMore()) {
                NamingEnumeration<Attribute> ne;
                SearchResult searchResult = results.next();
                Attributes attributes = searchResult.getAttributes();
                if (attribute.equals("")) {
                    StringBuilder sb = new StringBuilder();
                    ne = attributes.getAll();
                    while (ne.hasMore()) {
                        Attribute attr = (Attribute)ne.nextElement();
                        sb.append(attr.toString());
                        sb.append("\n");
                    }
                    al.add(sb.toString());
                    continue;
                }
                if (attribute.equals("dn")) {
                    al.add(searchResult.getNameInNamespace());
                    continue;
                }
                Attribute attrib = attributes.get(attribute);
                if (attrib == null) continue;
                ne = attrib.getAll();
                while (ne.hasMore()) {
                    String value = (String)ne.nextElement();
                    if (value.startsWith("CN=") || value.startsWith("cn=")) {
                        String cn = value.substring(3, value.indexOf(44));
                        log.debug("FQDN: {}, CN: {}", (Object)value, (Object)cn);
                        al.add(cn);
                        continue;
                    }
                    al.add(value);
                }
            }
            ctx.close();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        log.debug("ldapSearch: {}", al);
        return al;
    }
}

