/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.principal;

import com.openkm.core.Config;
import com.openkm.principal.PrincipalAdapter;
import com.openkm.principal.PrincipalAdapterException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsersRolesPrincipalAdapter
implements PrincipalAdapter {
    private static Logger log = LoggerFactory.getLogger(UsersRolesPrincipalAdapter.class);

    @Override
    public List<String> getUsers() throws PrincipalAdapterException {
        log.debug("getUsers()");
        ArrayList<String> list = new ArrayList<String>();
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(Config.HOME_DIR + "/server/default/conf/props/openkm-users.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Enumeration<Object> e = prop.keys();
        while (e.hasMoreElements()) {
            String user = (String)e.nextElement();
            if (Config.SYSTEM_USER.equals(user)) continue;
            list.add(user);
        }
        log.debug("getUsers: {}", list);
        return list;
    }

    @Override
    public List<String> getRoles() throws PrincipalAdapterException {
        log.debug("getRoles()");
        ArrayList<String> list = new ArrayList<String>();
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(Config.HOME_DIR + "/server/default/conf/props/openkm-roles.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Enumeration<Object> e = prop.elements();
        while (e.hasMoreElements()) {
            StringTokenizer st = new StringTokenizer((String)e.nextElement(), ",");
            while (st.hasMoreTokens()) {
                String role = st.nextToken();
                if (Config.DEFAULT_ADMIN_ROLE.equals(role) || list.contains(role)) continue;
                list.add(role);
            }
        }
        log.debug("getRoles: {}", list);
        return list;
    }

    @Override
    public List<String> getUsersByRole(String role) throws PrincipalAdapterException {
        throw new NotImplementedException("getUsersByRole");
    }

    @Override
    public List<String> getRolesByUser(String user) throws PrincipalAdapterException {
        throw new NotImplementedException("getRolesByUser");
    }

    @Override
    public String getMail(String user) throws PrincipalAdapterException {
        log.debug("getMail({})", (Object)user);
        Properties prop = new Properties();
        String mail = null;
        try {
            prop.load(new FileInputStream(Config.HOME_DIR + "/server/default/conf/props/openkm-emails.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mail = prop.getProperty(user);
        log.debug("getMail: {}", (Object)mail);
        return mail;
    }

    @Override
    public String getName(String user) throws PrincipalAdapterException {
        log.debug("getName({})", (Object)user);
        Properties prop = new Properties();
        String name = null;
        try {
            prop.load(new FileInputStream(Config.HOME_DIR + "/server/default/conf/props/openkm-names.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        name = prop.getProperty(user);
        log.debug("getName: {}", (Object)name);
        return name;
    }
}

