/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet;

import com.openkm.bean.Document;
import com.openkm.core.JcrSessionManager;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.base.BaseDocumentModule;
import com.openkm.servlet.BasicSecuredServlet;
import com.openkm.util.WebUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadServlet
extends BasicSecuredServlet {
    private static Logger log = LoggerFactory.getLogger(DownloadServlet.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        String path = WebUtils.getString(request, "path");
        String uuid = WebUtils.getString(request, "uuid");
        String token = WebUtils.getString(request, "token");
        Session session = null;
        try {
            session = token.equals("") ? this.getSession(request) : JcrSessionManager.getInstance().get(token);
            if (session != null) {
                Node node = null;
                if (!uuid.equals("")) {
                    node = session.getNodeByUUID(uuid);
                    path = node.getPath();
                } else if (!path.equals("")) {
                    node = session.getRootNode().getNode(path.substring(1));
                }
                if (node != null) {
                    Document doc = BaseDocumentModule.getProperties(session, node);
                    String fileName = JCRUtils.getName(doc.getPath());
                    log.info("Download {} by {}", (Object)path, (Object)session.getUserID());
                    InputStream is = BaseDocumentModule.getContent(session, path, false);
                    WebUtils.sendFile(request, response, fileName, doc.getMimeType(), true, is);
                    is.close();
                } else {
                    response.setContentType("text/plain; charset=UTF-8");
                    PrintWriter out = response.getWriter();
                    out.println("Missing document reference");
                    out.close();
                }
            } else {
                response.setContentType("text/plain; charset=UTF-8");
                PrintWriter out = response.getWriter();
                out.println("Missing user credentials");
                out.close();
            }
        }
        catch (LoginException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.setHeader("WWW-Authenticate", "Basic realm=\"OpenKM Download Server\"");
            response.sendError(401, e.getMessage());
        }
        catch (ItemNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, "ItemNotFoundException: " + e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, "PathNotFoundException: " + e.getMessage());
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, "RepositoryException: " + e.getMessage());
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        finally {
            if (token.equals("") && session != null) {
                session.logout();
            }
        }
    }
}

