/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet;

import com.openkm.core.DatabaseException;
import com.openkm.dao.LanguageDAO;
import com.openkm.dao.bean.Language;
import com.openkm.servlet.MimeIconServlet;
import com.openkm.util.SecureStore;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagIconServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(MimeIconServlet.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String lgId = request.getPathInfo();
        ServletOutputStream os = null;
        try {
            Language language;
            if (lgId.length() > 1 && (language = LanguageDAO.findByPk(lgId.substring(1))) != null) {
                byte[] img = SecureStore.b64Decode(new String(language.getImageContent()));
                response.setContentType(language.getImageMime());
                response.setContentLength(img.length);
                os = response.getOutputStream();
                os.write(img);
                os.flush();
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }
}

