/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet;

import com.openkm.bean.StoredFile;
import com.openkm.core.Config;
import com.openkm.util.SecureStore;
import com.openkm.util.WebUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageLogoServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(ImageLogoServlet.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String img = request.getPathInfo();
        try {
            if (img != null && img.length() > 1) {
                StoredFile logo = this.getImage(img.substring(1));
                if (logo != null) {
                    byte[] content = SecureStore.b64Decode(logo.getContent());
                    ByteArrayInputStream bais = new ByteArrayInputStream(content);
                    WebUtils.sendFile(request, response, logo.getName(), logo.getMime(), true, bais);
                } else {
                    this.sendError(request, response);
                }
            }
        }
        catch (MalformedURLException e) {
            this.sendError(request, response);
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.sendError(request, response);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        InputStream is = this.getServletContext().getResource("/img/error.png").openStream();
        WebUtils.sendFile(request, response, "error.png", "image/png", true, is);
        is.close();
    }

    private StoredFile getImage(String img) throws MalformedURLException, IOException {
        log.debug("getImage({})", (Object)img);
        StoredFile stFile = null;
        if ("login".equals(img)) {
            stFile = Config.LOGO_LOGIN;
        } else if ("mobile".equals(img)) {
            stFile = Config.LOGO_MOBILE;
        } else if ("report".equals(img)) {
            stFile = Config.LOGO_REPORT;
        }
        log.debug("getImage: {}", (Object)stFile);
        return stFile;
    }
}

