/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet;

import com.openkm.core.DatabaseException;
import com.openkm.dao.MimeTypeDAO;
import com.openkm.dao.bean.MimeType;
import com.openkm.util.SecureStore;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeIconServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(MimeIconServlet.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String mime = request.getPathInfo();
        ServletOutputStream os = null;
        try {
            MimeType mt;
            if (mime.length() > 1 && (mt = MimeTypeDAO.findByName(mime.substring(1))) != null) {
                byte[] img = SecureStore.b64Decode(new String(mt.getImageContent()));
                response.setContentType(mt.getImageMime());
                response.setContentLength(img.length);
                os = response.getOutputStream();
                os.write(img);
                os.flush();
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }
}

