/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet;

import com.openkm.cache.UserDocumentKeywordsManager;
import com.openkm.cache.UserItemsManager;
import com.openkm.core.Config;
import com.openkm.core.Cron;
import com.openkm.core.DataStoreGarbageCollector;
import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryInfo;
import com.openkm.core.UpdateInfo;
import com.openkm.core.UserMailImporter;
import com.openkm.core.Watchdog;
import com.openkm.dao.HibernateUtil;
import com.openkm.extension.core.ExtensionManager;
import com.openkm.kea.RDFREpository;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.util.DocConverter;
import com.openkm.util.ExecutionUtils;
import com.openkm.util.JBPMUtils;
import com.openkm.util.UserActivity;
import com.openkm.util.WarUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.jbpm.JbpmContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class RepositoryStartupServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(RepositoryStartupServlet.class);
    private static final long serialVersionUID = 1L;
    private static Timer dsgcTimer;
    private static Timer wdTimer;
    private static Timer riTimer;
    private static Timer uiTimer;
    private static Timer umiTimer;
    private static Timer cronTimer;
    private static Watchdog wd;
    private static Cron cron;
    private static UpdateInfo ui;
    private static RepositoryInfo ri;
    private static UserMailImporter umi;
    private static DataStoreGarbageCollector dsgc;
    private static boolean hasConfiguredDataStore;
    private static boolean running;

    public void init() throws ServletException {
        File previewCacheFolder;
        File pdfCacheFolder;
        super.init();
        ServletContext sc = this.getServletContext();
        Config.load(sc);
        SLF4JBridgeHandler.install();
        WarUtils.readAppVersion(sc);
        log.info("*** Application version: " + WarUtils.getAppVersion() + " ***");
        File dxfCacheFolder = new File(Config.CACHE_DXF);
        if (!dxfCacheFolder.exists()) {
            dxfCacheFolder.mkdirs();
        }
        if (!(pdfCacheFolder = new File(Config.CACHE_PDF)).exists()) {
            pdfCacheFolder.mkdirs();
        }
        if (!(previewCacheFolder = new File(Config.CACHE_SWF)).exists()) {
            previewCacheFolder.mkdirs();
        }
        RepositoryStartupServlet.start();
        UserActivity.log(Config.SYSTEM_USER, "MISC_OPENKM_START", null, null);
    }

    public void destroy() {
        super.destroy();
        RepositoryStartupServlet.stop((GenericServlet)this);
        UserActivity.log(Config.SYSTEM_USER, "MISC_OPENKM_STOP", null, null);
    }

    public static synchronized void start() throws ServletException {
        if (running) {
            throw new IllegalStateException("OpenKM already started");
        }
        try {
            log.info("*** Repository initializing... ***");
            DirectRepositoryModule.initialize();
            log.info("*** Repository initialized ***");
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        if (Config.USER_ITEM_CACHE) {
            try {
                log.info("*** Cache deserialization ***");
                UserItemsManager.deserialize();
                UserDocumentKeywordsManager.deserialize();
            }
            catch (DatabaseException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        log.info("*** User database initialized ***");
        SessionImpl si = (SessionImpl)DirectRepositoryModule.getSystemSession();
        hasConfiguredDataStore = ((RepositoryImpl)si.getRepository()).getDataStore() != null;
        uiTimer = new Timer();
        wdTimer = new Timer();
        cronTimer = new Timer();
        riTimer = new Timer();
        umiTimer = new Timer();
        dsgcTimer = new Timer();
        log.info("*** Initializing workflow engine... ***");
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        jbpmContext.setSessionFactory(HibernateUtil.getSessionFactory());
        jbpmContext.getGraphSession();
        jbpmContext.getJbpmConfiguration().getJobExecutor().start();
        jbpmContext.close();
        log.info("*** Initializing MIME types... ***");
        Config.loadMimeTypes();
        if (Config.UPDATE_INFO) {
            log.info("*** Activating update info ***");
            ui = new UpdateInfo();
            uiTimer.schedule((TimerTask)ui, 1000L, 86400000L);
        }
        log.info("*** Activating watchdog ***");
        wd = new Watchdog();
        wdTimer.schedule((TimerTask)wd, 60000L, 300000L);
        log.info("*** Activating cron ***");
        cron = new Cron();
        Calendar calCron = Calendar.getInstance();
        calCron.add(12, 1);
        calCron.set(13, 0);
        calCron.set(14, 0);
        cronTimer.scheduleAtFixedRate((TimerTask)cron, calCron.getTime(), 60000L);
        log.info("*** Activating repository info ***");
        ri = new RepositoryInfo();
        Calendar calGc = Calendar.getInstance();
        calGc.add(6, 1);
        calGc.set(11, 1);
        calGc.set(12, 0);
        calGc.set(13, 0);
        calGc.set(14, 0);
        riTimer.schedule((TimerTask)ri, calGc.getTime(), 86400000L);
        if (Config.SCHEDULE_MAIL_IMPORTER > 0L) {
            log.info("*** Activating user mail importer ***");
            umi = new UserMailImporter();
            umiTimer.schedule((TimerTask)umi, 300000L, Config.SCHEDULE_MAIL_IMPORTER);
        } else {
            log.info("*** User mail importer disabled ***");
        }
        if (hasConfiguredDataStore) {
            log.info("*** Activating datastore garbage collection ***");
            dsgc = new DataStoreGarbageCollector();
        }
        try {
            log.info("*** Activating thesaurus repository ***");
            RDFREpository.getInstance();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            if (!Config.SYSTEM_OPENOFFICE_PATH.equals("")) {
                log.info("*** Start OpenOffice manager ***");
                DocConverter.getInstance().start();
            } else if (!Config.SYSTEM_OPENOFFICE_SERVER.equals("")) {
                log.info("*** Using OpenOffice conversion server ***");
            } else {
                log.warn("*** No OpenOffice manager nor server configured ***");
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        ExtensionManager.getInstance();
        try {
            log.info("*** Ejecute start script ***");
            File script = new File(Config.HOME_DIR + File.separatorChar + "start.bsh");
            ExecutionUtils.runScript(script);
            File jar = new File(Config.HOME_DIR + File.separatorChar + "start.jar");
            ExecutionUtils.getInstance().runJar(jar);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        running = true;
    }

    public static synchronized void stop(GenericServlet gs) {
        if (!running) {
            throw new IllegalStateException("OpenKM not started");
        }
        ExtensionManager.getInstance().shutdown();
        try {
            if (!Config.SYSTEM_OPENOFFICE_PATH.equals("")) {
                if (log == null && gs != null) {
                    gs.log("*** Shutting down OpenOffice manager ***");
                } else {
                    log.info("*** Shutting down OpenOffice manager ***");
                }
                DocConverter.getInstance().stop();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        if (hasConfiguredDataStore) {
            if (log == null && gs != null) {
                gs.log("*** Shutting down datastore garbage collection... ***");
            } else {
                log.info("*** Shutting down datastore garbage collection... ***");
            }
            dsgc.cancel();
        }
        if (Config.SCHEDULE_MAIL_IMPORTER > 0L) {
            if (log == null && gs != null) {
                gs.log("*** Shutting down user mail importer ***");
            } else {
                log.info("*** Shutting down user mail importer ***");
            }
            umi.cancel();
        }
        if (log == null && gs != null) {
            gs.log("*** Shutting down repository info... ***");
        } else {
            log.info("*** Shutting down repository info... ***");
        }
        ri.cancel();
        if (log == null && gs != null) {
            gs.log("*** Shutting down cron... ***");
        } else {
            log.info("*** Shutting down cron... ***");
        }
        cron.cancel();
        if (log == null && gs != null) {
            gs.log("*** Shutting down watchdog... ***");
        } else {
            log.info("*** Shutting down watchdog... ***");
        }
        wd.cancel();
        if (Config.UPDATE_INFO) {
            if (log == null && gs != null) {
                gs.log("*** Shutting down update info... ***");
            } else {
                log.info("*** Shutting down update info... ***");
            }
            ui.cancel();
        }
        dsgcTimer.cancel();
        umiTimer.cancel();
        riTimer.cancel();
        cronTimer.cancel();
        wdTimer.cancel();
        uiTimer.cancel();
        if (log == null && gs != null) {
            gs.log("*** Shutting down workflow engine... ***");
        } else {
            log.info("*** Shutting down workflow engine... ***");
        }
        JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
        jbpmContext.getJbpmConfiguration().getJobExecutor().stop();
        jbpmContext.close();
        if (log == null && gs != null) {
            gs.log("*** Shutting down repository... ***");
        } else {
            log.info("*** Shutting down repository...");
        }
        if (Config.USER_ITEM_CACHE) {
            try {
                log.info("*** Cache serialization ***");
                UserItemsManager.serialize();
                UserDocumentKeywordsManager.serialize();
            }
            catch (DatabaseException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        try {
            DirectRepositoryModule.shutdown();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (log == null && gs != null) {
            gs.log("*** Repository shutted down ***");
        } else {
            log.info("*** Repository shutted down ***");
        }
        try {
            if (log == null && gs != null) {
                gs.log("*** Ejecute stop script ***");
            } else {
                log.info("*** Ejecute stop script ***");
            }
            File script = new File(Config.HOME_DIR + File.separatorChar + "stop.bsh");
            ExecutionUtils.runScript(script);
            File jar = new File(Config.HOME_DIR + File.separatorChar + "stop.jar");
            ExecutionUtils.getInstance().runJar(jar);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        running = false;
    }

    static {
        running = false;
    }
}

