/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet;

import com.openkm.bean.DashboardDocumentResult;
import com.openkm.bean.DashboardFolderResult;
import com.openkm.bean.DashboardMailResult;
import com.openkm.core.Config;
import com.openkm.dao.QueryParamsDAO;
import com.openkm.dao.bean.QueryParams;
import com.openkm.module.direct.DirectDashboardModule;
import com.openkm.servlet.BasicSecuredServlet;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndImageImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyndicationServlet
extends BasicSecuredServlet {
    private static Logger log = LoggerFactory.getLogger(SyndicationServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String FEED_TYPE = "rss_2.0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String action = request.getPathInfo();
        Session session = null;
        log.debug("action: {}", (Object)action);
        try {
            session = this.getSession(request);
            SyndFeed feed = null;
            if ("/userLockedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getUserLockedDocuments(session));
                feed.setTitle("OpenKM: user locked documents");
            } else if ("/userCheckedOutDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getUserCheckedOutDocuments(session));
                feed.setTitle("OpenKM: user checked-out documents");
            } else if ("/userSubscribedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getUserSubscribedDocuments(session));
                feed.setTitle("OpenKM: user subscribed documents");
            } else if ("/userSubscribedFolders".equals(action)) {
                feed = this.getFeedFolders(new DirectDashboardModule().getUserSubscribedFolders(session));
                feed.setTitle("OpenKM: user subscribed folders");
            } else if ("/userLastUploadedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getUserLastUploadedDocuments(session));
                feed.setTitle("OpenKM: user last uploaded documents");
            } else if ("/userLastModifiedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getUserLastModifiedDocuments(session));
                feed.setTitle("OpenKM: user last modified documents");
            } else if ("/userLastDownloadedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getUserLastDownloadedDocuments(session));
                feed.setTitle("OpenKM: user last downloaded documents");
            } else if ("/userLastImportedMails".equals(action)) {
                feed = this.getFeedMails(new DirectDashboardModule().getUserLastImportedMails(session));
                feed.setTitle("OpenKM: user last imported mails");
            } else if ("/userLastImportedMailAttachments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getUserLastImportedMailAttachments(session));
                feed.setTitle("OpenKM: user last imported mail attachments");
            } else if ("/lastWeekTopDownloadedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getLastWeekTopDownloadedDocuments(session));
                feed.setTitle("OpenKM: last week top downloaded documents");
            } else if ("/lastMonthTopDownloadedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getLastMonthTopDownloadedDocuments(session));
                feed.setTitle("OpenKM: last month top downloaded documents");
            } else if ("/lastWeekTopModifiedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getLastWeekTopModifiedDocuments(session));
                feed.setTitle("OpenKM: last week top modified documents");
            } else if ("/lastMonthTopModifiedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getLastMonthTopModifiedDocuments(session));
                feed.setTitle("OpenKM: last month top modified documents");
            } else if ("/lastModifiedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getLastModifiedDocuments(session));
                feed.setTitle("OpenKM: last modified documents");
            } else if ("/lastUploadedDocuments".equals(action)) {
                feed = this.getFeedDocuments(new DirectDashboardModule().getLastUploadedDocuments(session));
                feed.setTitle("OpenKM: last uploaded documents");
            } else if (action != null && action.startsWith("/news_")) {
                String qpStr = action.substring(6);
                int qpId = Integer.parseInt(qpStr);
                QueryParams qp = QueryParamsDAO.findByPk(qpId);
                feed = this.getFeedDocuments(new DirectDashboardModule().find(session, qpId));
                feed.setTitle("OpenKM: " + qp.getQueryName());
            }
            if (feed != null) {
                response.setContentType("application/xml; charset=UTF-8");
                SyndFeedOutput output = new SyndFeedOutput();
                SyndImageImpl img = new SyndImageImpl();
                img.setTitle(feed.getTitle());
                img.setUrl(Config.APPLICATION_BASE + "/img/logo_short.gif");
                img.setLink(Config.APPLICATION_BASE);
                feed.setImage((SyndImage)img);
                feed.setLanguage("en");
                feed.setFeedType(FEED_TYPE);
                feed.setDescription(feed.getTitle());
                feed.setLink(Config.APPLICATION_BASE);
                output.output(feed, (Writer)response.getWriter());
            } else {
                response.setContentType("text/plain; charset=UTF-8");
                PrintWriter out = response.getWriter();
                out.println("Unknown syndicantion feed");
                out.close();
            }
        }
        catch (LoginException e) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"OpenKM Syndication Server\"");
            response.sendError(401, e.getMessage());
        }
        catch (RepositoryException e) {
            response.sendError(500, e.getMessage());
        }
        catch (FeedException e) {
            response.sendError(500, e.getMessage());
        }
        catch (Exception e) {
            response.sendError(500, e.getMessage());
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private SyndFeed getFeedDocuments(List<DashboardDocumentResult> result) throws FeedException, RepositoryException, SQLException, IOException {
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        SyndFeedImpl feed = new SyndFeedImpl();
        for (DashboardDocumentResult item : result) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(item.getDocument().getPath());
            entry.setAuthor(item.getDocument().getActualVersion().getAuthor());
            entry.setPublishedDate(item.getDate().getTime());
            entry.setLink(Config.APPLICATION_URL + "?docPath=" + URLEncoder.encode(item.getDocument().getPath(), "UTF-8"));
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }

    private SyndFeed getFeedFolders(List<DashboardFolderResult> result) throws FeedException, RepositoryException, SQLException, IOException {
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        SyndFeedImpl feed = new SyndFeedImpl();
        for (DashboardFolderResult item : result) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(item.getFolder().getPath());
            entry.setAuthor(item.getFolder().getAuthor());
            entry.setPublishedDate(item.getDate().getTime());
            entry.setLink(Config.APPLICATION_URL + "?fldPath=" + URLEncoder.encode(item.getFolder().getPath(), "UTF-8"));
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }

    private SyndFeed getFeedMails(List<DashboardMailResult> result) throws FeedException, RepositoryException, SQLException, IOException {
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        SyndFeedImpl feed = new SyndFeedImpl();
        for (DashboardMailResult item : result) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(item.getMail().getPath());
            entry.setAuthor(item.getMail().getFrom());
            entry.setPublishedDate(item.getDate().getTime());
            entry.setLink(Config.APPLICATION_URL + "?docPath=" + URLEncoder.encode(item.getMail().getPath(), "UTF-8"));
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }
}

