/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet;

import com.openkm.core.Config;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.webdav.LocatorFactoryImplEx;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavServlet
extends SimpleWebdavServlet {
    private static Logger log = LoggerFactory.getLogger(WebdavServlet.class);
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
        log.info("*** Webdav initializing... ***");
        super.init();
        this.setLocatorFactory((DavLocatorFactory)new LocatorFactoryImplEx(this.getPathPrefix()));
        log.info("*** Webdav initialized ***");
    }

    public Repository getRepository() {
        log.debug("getRepository()");
        Repository repository = null;
        try {
            repository = DirectRepositoryModule.getRepository();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return repository;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (Config.SYSTEM_WEBDAV_SERVER) {
            super.service(request, response);
        } else {
            PrintWriter out = response.getWriter();
            out.println("WebDAV is disabled. Contact with your administrator.");
            out.flush();
            out.close();
        }
    }
}

