/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet;

import com.openkm.core.Config;
import com.openkm.servlet.BasicSecuredServlet;
import com.openkm.util.FormUtils;
import com.openkm.util.JBPMUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.jbpm.JbpmContext;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRegisterServlet
extends BasicSecuredServlet {
    private static Logger log = LoggerFactory.getLogger(WorkflowRegisterServlet.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("service({}, {}", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = request.getPathInfo();
        PrintWriter out = response.getWriter();
        Session session = null;
        log.info("action: {}", (Object)action);
        try {
            if (action != null && action.length() > 1 && action.indexOf(58) > 0) {
                String[] usrpass = action.substring(1).split(":");
                log.info("UserPass: {}, Pass: {}", (Object)usrpass[0], (Object)usrpass[1]);
                if (Config.ADMIN_USER.equals(usrpass[0])) {
                    session = this.getSession(usrpass[0], usrpass[1]);
                }
            } else {
                session = this.getSession(request);
            }
            if (session != null) {
                String msg = this.handleRequest(request);
                log.info("Status: {}", (Object)msg);
                out.print(msg);
                out.flush();
            } else {
                log.warn("Missing user credentials");
                response.setHeader("WWW-Authenticate", "Basic realm=\"OpenKM Worflow Register Server\"");
                response.sendError(401);
            }
        }
        catch (LoginException e) {
            log.warn("LoginException", (Throwable)e);
            response.setHeader("WWW-Authenticate", "Basic realm=\"OpenKM Worflow Register Server\"");
            response.sendError(401, e.getMessage());
        }
        catch (ItemNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, "ItemNotFoundException: " + e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, "PathNotFoundException: " + e.getMessage());
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, "RepositoryException: " + e.getMessage());
        }
        catch (FileUploadException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, "FileUploadException: " + e.getMessage());
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, "IOException: " + e.getMessage());
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleRequest(HttpServletRequest request) throws FileUploadException, IOException, Exception {
        log.warn("handleRequest({})", (Object)request);
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            String string;
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(request);
            if (items.isEmpty()) {
                log.warn("No process file in the request");
                return "No process file in the request";
            }
            FileItem fileItem = (FileItem)items.get(0);
            if (fileItem.getContentType().indexOf("application/x-zip-compressed") == -1) {
                log.warn("Not a process archive");
                throw new Exception("Not a process archive");
            }
            log.debug("Deploying process archive: {}", (Object)fileItem.getName());
            JbpmContext jbpmContext = JBPMUtils.getConfig().createJbpmContext();
            InputStream isForms = null;
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(fileItem.getInputStream());
                ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream((ZipInputStream)zis);
                FileDefinition fileDef = processDefinition.getFileDefinition();
                isForms = fileDef.getInputStream("forms.xml");
                FormUtils.parseWorkflowForms(isForms);
                log.debug("Created a processdefinition: {}", (Object)processDefinition.getName());
                jbpmContext.deployProcessDefinition(processDefinition);
                string = "Process " + processDefinition.getName() + " deployed successfully";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(isForms);
                IOUtils.closeQuietly((InputStream)zis);
                jbpmContext.close();
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)isForms);
            IOUtils.closeQuietly((InputStream)zis);
            jbpmContext.close();
            return string;
        }
        log.warn("Not a multipart request");
        return "Not a multipart request";
    }
}

