/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.api.OKMAuth;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.AuthDAO;
import com.openkm.dao.ProfileDAO;
import com.openkm.dao.bean.Profile;
import com.openkm.dao.bean.Role;
import com.openkm.dao.bean.User;
import com.openkm.frontend.client.OKMException;
import com.openkm.jcr.JCRUtils;
import com.openkm.principal.DatabasePrincipalAdapter;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.servlet.frontend.ChatServlet;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(AuthServlet.class);
    private static boolean db = Config.PRINCIPAL_ADAPTER.equals(DatabasePrincipalAdapter.class.getCanonicalName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        if (AuthServlet.isMultipleInstancesAdmin(request) || request.isUserInRole(Config.DEFAULT_ADMIN_ROLE)) {
            try {
                session = JCRUtils.getSession();
                if (action.equals("userCreate")) {
                    this.userCreate(session, request, response);
                } else if (action.equals("roleCreate")) {
                    this.roleCreate(session, request, response);
                } else if (action.equals("userEdit")) {
                    this.userEdit(session, request, response);
                } else if (action.equals("roleEdit")) {
                    this.roleEdit(session, request, response);
                } else if (action.equals("userDelete")) {
                    this.userDelete(session, request, response);
                } else if (action.equals("roleDelete")) {
                    this.roleDelete(session, request, response);
                } else if (action.equals("userActive")) {
                    this.userActive(session, request, response);
                } else if (action.equals("roleActive")) {
                    this.roleActive(session, request, response);
                } else if (action.equals("userChatDisconnect")) {
                    this.userChatDisconnect(request, response);
                }
                if (action.equals("") || action.equals("userActive") || action.equals("userChatDisconnect") || action.startsWith("user") && WebUtils.getBoolean(request, "persist")) {
                    this.userList(session, request, response);
                    return;
                }
                if (!action.equals("roleList") && !action.equals("roleActive") && (!action.startsWith("role") || !WebUtils.getBoolean(request, "persist"))) return;
                this.roleList(session, request, response);
                return;
            }
            catch (LoginException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.sendErrorRedirect(request, response, e);
                return;
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.sendErrorRedirect(request, response, e);
                return;
            }
            catch (DatabaseException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.sendErrorRedirect(request, response, e);
                return;
            }
            catch (NoSuchAlgorithmException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.sendErrorRedirect(request, response, e);
                return;
            }
            catch (PrincipalAdapterException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.sendErrorRedirect(request, response, e);
                return;
            }
            finally {
                JCRUtils.logout(session);
            }
        } else {
            UserActivity.log(request.getRemoteUser(), "ADMIN_ACCESS_DENIED", request.getRequestURI(), request.getQueryString());
            AccessDeniedException ade = new AccessDeniedException("You should not access this resource");
            this.sendErrorRedirect(request, response, ade);
        }
    }

    private void userCreate(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("userCreate({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            User usr = new User();
            usr.setId(WebUtils.getString(request, "usr_id"));
            usr.setName(WebUtils.getString(request, "usr_name"));
            usr.setPassword(WebUtils.getString(request, "usr_password"));
            usr.setEmail(WebUtils.getString(request, "usr_email"));
            usr.setActive(WebUtils.getBoolean(request, "usr_active"));
            List<String> usrRoles = WebUtils.getStringList(request, "usr_roles");
            for (String rolId : usrRoles) {
                usr.getRoles().add(AuthDAO.findRoleByPk(rolId));
            }
            AuthDAO.createUser(usr);
            UserActivity.log(session.getUserID(), "ADMIN_USER_CREATE", usr.getId(), usr.toString());
        } else {
            ServletContext sc = this.getServletContext();
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("roles", AuthDAO.findAllRoles());
            sc.setAttribute("usr", null);
            sc.getRequestDispatcher("/admin/user_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("userCreate: void");
    }

    private void userEdit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("userEdit({}, {}, {})", new Object[]{session, request, response});
        String usrId = WebUtils.getString(request, "usr_id");
        if (WebUtils.getBoolean(request, "persist")) {
            if (AuthServlet.isMultipleInstancesAdmin(request) || !usrId.equals(Config.ADMIN_USER)) {
                String password = WebUtils.getString(request, "usr_password");
                User usr = new User();
                usr.setId(usrId);
                usr.setName(WebUtils.getString(request, "usr_name"));
                usr.setEmail(WebUtils.getString(request, "usr_email"));
                usr.setActive(WebUtils.getBoolean(request, "usr_active"));
                List<String> usrRoles = WebUtils.getStringList(request, "usr_roles");
                for (String rolId : usrRoles) {
                    usr.getRoles().add(AuthDAO.findRoleByPk(rolId));
                }
                AuthDAO.updateUser(usr);
                if (!password.equals("")) {
                    AuthDAO.updateUserPassword(usr.getId(), password);
                }
                UserActivity.log(session.getUserID(), "ADMIN_USER_EDIT", usr.getId(), usr.toString());
            }
        } else {
            ServletContext sc = this.getServletContext();
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("roles", AuthDAO.findAllRoles());
            sc.setAttribute("usr", (Object)AuthDAO.findUserByPk(usrId));
            sc.getRequestDispatcher("/admin/user_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("userEdit: void");
    }

    private void userDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("userDelete({}, {}, {})", new Object[]{session, request, response});
        String usrId = WebUtils.getString(request, "usr_id");
        if (WebUtils.getBoolean(request, "persist")) {
            if (AuthServlet.isMultipleInstancesAdmin(request) || !usrId.equals(Config.ADMIN_USER)) {
                AuthDAO.deleteUser(usrId);
                UserActivity.log(session.getUserID(), "ADMIN_USER_DELETE", usrId, null);
            }
        } else {
            ServletContext sc = this.getServletContext();
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("roles", AuthDAO.findAllRoles());
            sc.setAttribute("usr", (Object)AuthDAO.findUserByPk(usrId));
            sc.getRequestDispatcher("/admin/user_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("userDelete: void");
    }

    private void userActive(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("userActive({}, {}, {})", new Object[]{session, request, response});
        boolean active = WebUtils.getBoolean(request, "usr_active");
        String usrId = WebUtils.getString(request, "usr_id");
        if (AuthServlet.isMultipleInstancesAdmin(request) || !usrId.equals(Config.ADMIN_USER)) {
            AuthDAO.activeUser(usrId, active);
            UserActivity.log(session.getUserID(), "ADMIN_USER_ACTIVE", usrId, Boolean.toString(active));
        }
        log.debug("userActive: void");
    }

    private void userList(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, PrincipalAdapterException {
        log.debug("userList({}, {}, {})", new Object[]{session, request, response});
        String roleFilter = WebUtils.getString(request, "roleFilter");
        ServletContext sc = this.getServletContext();
        sc.setAttribute("roleFilter", (Object)roleFilter);
        sc.setAttribute("chatUsers", ChatServlet.getChatManager().getLoggedUsers());
        if (roleFilter.equals("")) {
            if (db) {
                List<User> users = this.sortRoles(AuthDAO.findAllUsers(false));
                sc.setAttribute("users", this.toMapSetProfile(users));
                sc.setAttribute("roles", AuthDAO.findAllRoles());
            } else {
                List<User> users = this.str2user(OKMAuth.getInstance().getUsers(null));
                sc.setAttribute("users", this.toMapSetProfile(users));
                sc.setAttribute("roles", this.str2role(OKMAuth.getInstance().getRoles(null)));
            }
        } else if (db) {
            List<User> users = this.sortRoles(AuthDAO.findUsersByRole(roleFilter, false));
            sc.setAttribute("users", this.toMapSetProfile(users));
            sc.setAttribute("roles", AuthDAO.findAllRoles());
        } else {
            List<User> users = this.str2user(OKMAuth.getInstance().getUsersByRole(null, roleFilter));
            sc.setAttribute("users", this.toMapSetProfile(users));
            sc.setAttribute("roles", this.str2role(OKMAuth.getInstance().getRoles(null)));
        }
        sc.setAttribute("db", (Object)db);
        sc.setAttribute("multInstAdmin", (Object)AuthServlet.isMultipleInstancesAdmin(request));
        sc.getRequestDispatcher("/admin/user_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("userList: void");
    }

    private void roleCreate(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("roleCreate({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            Role rol = new Role();
            rol.setId(WebUtils.getString(request, "rol_id"));
            rol.setActive(WebUtils.getBoolean(request, "rol_active"));
            AuthDAO.createRole(rol);
            UserActivity.log(session.getUserID(), "ADMIN_ROLE_CREATE", rol.getId(), rol.toString());
        } else {
            ServletContext sc = this.getServletContext();
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("rol", null);
            sc.getRequestDispatcher("/admin/role_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("roleCreate: void");
    }

    private void roleEdit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("roleEdit({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            Role rol = new Role();
            rol.setId(WebUtils.getString(request, "rol_id"));
            rol.setActive(WebUtils.getBoolean(request, "rol_active"));
            AuthDAO.updateRole(rol);
            UserActivity.log(session.getUserID(), "ADMIN_ROLE_EDIT", rol.getId(), rol.toString());
        } else {
            ServletContext sc = this.getServletContext();
            String rolId = WebUtils.getString(request, "rol_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("rol", (Object)AuthDAO.findRoleByPk(rolId));
            sc.getRequestDispatcher("/admin/role_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("roleEdit: void");
    }

    private void roleDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("roleDelete({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            String rolId = WebUtils.getString(request, "rol_id");
            AuthDAO.deleteRole(rolId);
            UserActivity.log(session.getUserID(), "ADMIN_ROLE_DELETE", rolId, null);
        } else {
            ServletContext sc = this.getServletContext();
            String rolId = WebUtils.getString(request, "rol_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("rol", (Object)AuthDAO.findRoleByPk(rolId));
            sc.getRequestDispatcher("/admin/role_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("roleDelete: void");
    }

    private void roleActive(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("roleActive({}, {}, {})", new Object[]{session, request, response});
        String rolId = WebUtils.getString(request, "rol_id");
        boolean active = WebUtils.getBoolean(request, "rol_active");
        AuthDAO.activeRole(rolId, active);
        UserActivity.log(session.getUserID(), "ADMIN_ROLE_ACTIVE", rolId, Boolean.toString(active));
        log.debug("roleActive: void");
    }

    private void userChatDisconnect(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("userChatDisconnect({}, {})", new Object[]{request, response});
        try {
            String userId = WebUtils.getString(request, "usr_id");
            ChatServlet.getChatManager().logout(userId);
        }
        catch (OKMException e) {
            throw new ServletException(e.getMessage());
        }
        log.debug("userChatDisconnect: void");
    }

    private void roleList(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, PrincipalAdapterException {
        log.debug("roleList({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        if (db) {
            sc.setAttribute("roles", AuthDAO.findAllRoles());
        } else {
            sc.setAttribute("roles", this.str2role(OKMAuth.getInstance().getRoles(null)));
        }
        sc.setAttribute("db", (Object)db);
        sc.getRequestDispatcher("/admin/role_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("roleList: void");
    }

    private List<User> str2user(List<String> strList) throws PrincipalAdapterException {
        ArrayList<User> usrList = new ArrayList<User>();
        for (String usrId : strList) {
            List<String> roleList = OKMAuth.getInstance().getRolesByUser(null, usrId);
            User usr = new User();
            usr.setId(usrId);
            usr.setActive(true);
            usr.setName(OKMAuth.getInstance().getName(null, usrId));
            usr.setEmail(OKMAuth.getInstance().getMail(null, usrId));
            if (!roleList.isEmpty()) {
                TreeSet<Role> roles = new TreeSet<Role>(new RoleComparator());
                for (String rolId : roleList) {
                    Role rol = new Role();
                    rol.setId(rolId);
                    rol.setActive(true);
                    roles.add(rol);
                }
                usr.setRoles(roles);
            }
            usrList.add(usr);
        }
        Collections.sort(usrList, new UserComparator());
        return usrList;
    }

    private List<Role> str2role(List<String> strList) {
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (String id : strList) {
            Role rol = new Role();
            rol.setId(id);
            rol.setActive(true);
            roleList.add(rol);
        }
        Collections.sort(roleList, new RoleComparator());
        return roleList;
    }

    private List<User> sortRoles(List<User> users) {
        ArrayList<User> ret = new ArrayList<User>();
        for (User user : users) {
            TreeSet<Role> sortedRoles = new TreeSet<Role>(new RoleComparator());
            sortedRoles.addAll(user.getRoles());
            user.setRoles(sortedRoles);
            ret.add(user);
        }
        return ret;
    }

    private List<Map<String, Object>> toMapSetProfile(List<User> users) throws DatabaseException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (User user : users) {
            HashMap<String, Object> usrMap = new HashMap<String, Object>();
            Profile prf = ProfileDAO.findByUser(user.getId());
            if (prf != null) {
                usrMap.put("profile", prf.getName());
            } else {
                usrMap.put("profile", "");
            }
            usrMap.put("id", user.getId());
            usrMap.put("name", user.getName());
            usrMap.put("email", user.getEmail());
            usrMap.put("active", user.isActive());
            usrMap.put("roles", user.getRoles());
            ret.add(usrMap);
        }
        return ret;
    }

    private class RoleComparator
    implements Comparator<Role> {
        private RoleComparator() {
        }

        @Override
        public int compare(Role arg0, Role arg1) {
            if (arg0 != null && arg1 != null) {
                return arg0.getId().compareTo(arg1.getId());
            }
            return 0;
        }
    }

    private class UserComparator
    implements Comparator<User> {
        private UserComparator() {
        }

        @Override
        public int compare(User arg0, User arg1) {
            if (arg0 != null && arg1 != null) {
                return arg0.getId().compareTo(arg1.getId());
            }
            return 0;
        }
    }
}

