/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.HttpSessionManager;
import com.openkm.util.UserActivity;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final String METHOD_GET = "GET";
    protected static final String METHOD_POST = "POST";

    protected void sendErrorRedirect(HttpServletRequest request, HttpServletResponse response, Throwable e) throws ServletException, IOException {
        request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
        ServletContext sc = this.getServletConfig().getServletContext();
        sc.getRequestDispatcher("/error.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void sendError(PrintWriter out, String msg) throws ServletException, IOException {
        out.println("<div class=\"error\">" + msg + "</div>");
        out.flush();
    }

    public void updateSessionManager(HttpServletRequest request) {
        HttpSessionManager.getInstance().update(request.getSession().getId());
    }

    public static boolean isAdmin(HttpServletRequest request) {
        return request.isUserInRole(Config.DEFAULT_ADMIN_ROLE);
    }

    public static boolean isMultipleInstancesAdmin(HttpServletRequest request) {
        return request.getRemoteUser().equals(Config.ADMIN_USER) || request.isUserInRole(Config.DEFAULT_ADMIN_ROLE);
    }

    public boolean checkMultipleInstancesAccess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!BaseServlet.isMultipleInstancesAdmin(request)) {
            UserActivity.log(request.getRemoteUser(), "ADMIN_ACCESS_DENIED", request.getRequestURI(), request.getQueryString());
            AccessDeniedException ade = new AccessDeniedException("You should not access this resource");
            this.sendErrorRedirect(request, response, ade);
            return false;
        }
        return true;
    }

    public void header(PrintWriter out, String title) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        out.println("<head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        out.println("<link rel=\"Shortcut icon\" href=\"favicon.ico\" />");
        out.println("<link rel=\"stylesheet\" href=\"css/style.css\" type=\"text/css\" />");
        out.println("<script src=\"js/biblioteca.js\" type=\"text/javascript\"></script>");
        out.println("<script type=\"text/javascript\">scrollToBottom();</script>");
        out.println("<title>" + title + "</title>");
        out.println("</head>");
        out.println("<body>");
    }

    public void footer(PrintWriter out) {
        out.println("</body>");
        out.println("</html>");
    }

    public void ok(PrintWriter out, String msg) {
        out.print("<div class=\"ok\">" + msg + "</div>");
    }

    public void warn(PrintWriter out, String msg) {
        out.print("<div class=\"warn\">" + msg + "</div>");
    }
}

