/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.google.gson.Gson;
import com.openkm.bean.StoredFile;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.ConfigDAO;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.SecureStore;
import com.openkm.util.WebUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.artofsolving.jodconverter.office.OfficeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ConfigServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String method = request.getMethod();
        if (this.checkMultipleInstancesAccess(request, response)) {
            if (method.equals("GET")) {
                this.doGet(request, response);
            } else if (method.equals("POST")) {
                this.doPost(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
            types.put("string", "String");
            types.put("text", "Text");
            types.put("boolean", "Boolean");
            types.put("integer", "Integer");
            types.put("long", "Long");
            types.put("file", "File");
            if (action.equals("create")) {
                this.create(session, types, request, response);
            } else if (action.equals("edit")) {
                this.edit(session, types, request, response);
            } else if (action.equals("delete")) {
                this.delete(session, types, request, response);
            } else if (action.equals("view")) {
                this.view(session, request, response);
            } else if (action.equals("check")) {
                this.check(session, request, response);
            } else {
                this.list(session, request, response);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    /*
     * Exception decompiling
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void create(Session session, Map<String, String> types, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        ServletContext sc = this.getServletContext();
        com.openkm.dao.bean.Config cfg = new com.openkm.dao.bean.Config();
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("types", types);
        sc.setAttribute("cfg", (Object)cfg);
        sc.getRequestDispatcher("/admin/config_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void edit(Session session, Map<String, String> types, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        ServletContext sc = this.getServletContext();
        String cfgKey = WebUtils.getString(request, "cfg_key");
        com.openkm.dao.bean.Config cfg = ConfigDAO.findByPk(cfgKey);
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("types", types);
        sc.setAttribute("cfg", (Object)cfg);
        sc.getRequestDispatcher("/admin/config_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void delete(Session session, Map<String, String> types, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        ServletContext sc = this.getServletContext();
        String cfgKey = WebUtils.getString(request, "cfg_key");
        com.openkm.dao.bean.Config cfg = ConfigDAO.findByPk(cfgKey);
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("types", types);
        sc.setAttribute("cfg", (Object)cfg);
        sc.getRequestDispatcher("/admin/config_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void list(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("list({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        List<com.openkm.dao.bean.Config> list = ConfigDAO.findAll();
        for (com.openkm.dao.bean.Config cfg : list) {
            if ("string".equals(cfg.getType())) {
                cfg.setType("String");
                continue;
            }
            if ("text".equals(cfg.getType())) {
                cfg.setType("Text");
                continue;
            }
            if ("boolean".equals(cfg.getType())) {
                cfg.setType("Boolean");
                continue;
            }
            if ("integer".equals(cfg.getType())) {
                cfg.setType("Integer");
                continue;
            }
            if ("long".equals(cfg.getType())) {
                cfg.setType("Long");
                continue;
            }
            if (!"file".equals(cfg.getType())) continue;
            cfg.setType("File");
        }
        sc.setAttribute("configs", list);
        sc.getRequestDispatcher("/admin/config_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("list: void");
    }

    private void view(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("view({}, {}, {})", new Object[]{session, request, response});
        String cfgKey = WebUtils.getString(request, "cfg_key");
        com.openkm.dao.bean.Config cfg = ConfigDAO.findByPk(cfgKey);
        if (cfg != null) {
            StoredFile stFile = (StoredFile)new Gson().fromJson(cfg.getValue(), StoredFile.class);
            byte[] content = SecureStore.b64Decode(stFile.getContent());
            ByteArrayInputStream bais = new ByteArrayInputStream(content);
            WebUtils.sendFile(request, response, stFile.getName(), stFile.getMime(), true, bais);
        }
        log.debug("view: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("check({}, {}, {})", new Object[]{session, request, response});
        PrintWriter out = response.getWriter();
        response.setContentType("text/html");
        this.header(out, "Configuration check");
        out.flush();
        out.println("<h1>Configuration check</h1>");
        out.println("<ul>");
        out.flush();
        try {
            out.print("<li>");
            out.print("<b>system.swftools.pdf2swf</b>");
            this.checkExecutable(out, Config.SYSTEM_SWFTOOLS_PDF2SWF);
            out.print("</li>");
            out.print("<li>");
            out.print("<b>system.imagemagick.convert</b>");
            this.checkExecutable(out, Config.SYSTEM_IMAGEMAGICK_CONVERT);
            out.print("</li>");
            out.print("<li>");
            out.print("<b>system.ocr</b>");
            this.checkExecutable(out, Config.SYSTEM_OCR);
            out.print("</li>");
            out.print("<li>");
            out.print("<b>system.openoffice.path</b>");
            this.checkOpenOffice(out, Config.SYSTEM_OPENOFFICE_PATH);
            out.print("</li>");
            out.println("</ul>");
            out.flush();
        }
        catch (Exception e) {
            out.println("<div class=\"warn\">Exception: " + e.getMessage() + "</div>");
            out.flush();
        }
        finally {
            this.footer(out);
            out.flush();
            out.close();
        }
        log.debug("check: void");
    }

    private void checkExecutable(PrintWriter out, String cmd) {
        if (cmd.equals("")) {
            this.warn(out, "Not configured");
        } else {
            int idx = cmd.indexOf(" ");
            String exec = null;
            exec = idx > -1 ? cmd.substring(0, idx) : cmd;
            File prg = new File(exec);
            if (prg.exists() && prg.canRead() && prg.canExecute()) {
                this.ok(out, "OK - " + prg.getPath());
            } else {
                this.warn(out, "Can't read or execute: " + prg.getPath());
            }
        }
    }

    private void checkOpenOffice(PrintWriter out, String path) {
        if (path.equals("")) {
            this.warn(out, "Not configured");
        } else {
            File prg = new File(path);
            if (prg.exists() && prg.canRead()) {
                File offExec = OfficeUtils.getOfficeExecutable((File)prg);
                if (offExec.exists() && offExec.canRead() && offExec.canExecute()) {
                    this.ok(out, "OK - " + offExec.getPath());
                } else {
                    this.warn(out, "Can't read or execute: " + offExec.getPath());
                }
            } else {
                this.warn(out, "Can't read: " + prg.getPath());
            }
        }
    }
}

