/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import bsh.EvalError;
import com.openkm.core.Cron;
import com.openkm.core.DatabaseException;
import com.openkm.dao.CronTabDAO;
import com.openkm.dao.bean.CronTab;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.SecureStore;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronTabServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(CronTabServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String method = request.getMethod();
        if (this.checkMultipleInstancesAccess(request, response)) {
            if (method.equals("GET")) {
                this.doGet(request, response);
            } else if (method.equals("POST")) {
                this.doPost(request, response);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        this.updateSessionManager(request);
        try {
            LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
            types.put("application/x-bsh", "BSH");
            types.put("application/x-java-archive", "JAR");
            if (action.equals("create")) {
                ServletContext sc = this.getServletContext();
                CronTab ct = new CronTab();
                sc.setAttribute("action", (Object)action);
                sc.setAttribute("types", types);
                sc.setAttribute("ct", (Object)ct);
                sc.getRequestDispatcher("/admin/crontab_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else if (action.equals("edit")) {
                ServletContext sc = this.getServletContext();
                int ctId = WebUtils.getInt(request, "ct_id");
                CronTab ct = CronTabDAO.findByPk(ctId);
                sc.setAttribute("action", (Object)action);
                sc.setAttribute("types", types);
                sc.setAttribute("ct", (Object)ct);
                sc.getRequestDispatcher("/admin/crontab_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else if (action.equals("delete")) {
                ServletContext sc = this.getServletContext();
                int ctId = WebUtils.getInt(request, "ct_id");
                CronTab ct = CronTabDAO.findByPk(ctId);
                sc.setAttribute("action", (Object)action);
                sc.setAttribute("types", types);
                sc.setAttribute("ct", (Object)ct);
                sc.getRequestDispatcher("/admin/crontab_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else if (action.equals("execute")) {
                this.execute(request, response);
                this.list(request, response);
            } else {
                this.list(request, response);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (EvalError e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
    }

    /*
     * Exception decompiling
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void list(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("list({}, {})", new Object[]{request, response});
        ServletContext sc = this.getServletContext();
        List<CronTab> list = CronTabDAO.findAll();
        sc.setAttribute("crontabs", list);
        sc.getRequestDispatcher("/admin/crontab_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("list: void");
    }

    private void execute(HttpServletRequest request, HttpServletResponse response) throws IOException, DatabaseException, EvalError {
        log.debug("execute({}, {})", new Object[]{request, response});
        int ctId = WebUtils.getInt(request, "ct_id");
        CronTab ct = CronTabDAO.findByPk(ctId);
        if ("application/x-bsh".equals(ct.getFileMime())) {
            Cron.RunnerBsh runner = new Cron.RunnerBsh(ct.getId(), ct.getName(), ct.getMail(), new String(SecureStore.b64Decode(ct.getFileContent())));
            runner.run();
        } else if ("application/x-java-archive".equals(ct.getFileMime())) {
            Cron.RunnerJar runner = new Cron.RunnerJar(ct.getId(), ct.getName(), ct.getMail(), SecureStore.b64Decode(ct.getFileContent()));
            runner.run();
        }
        UserActivity.log(request.getRemoteUser(), "ADMIN_CRONTAB_EXECUTE", Integer.toString(ctId), ct.toString());
        log.debug("execute: void");
    }
}

