/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBrowserServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DataBrowserServlet.class);
    private static final String SEL_BOTH = "both";
    private static final String SEL_FOLDER = "fld";
    private static final String SEL_DOCUMENT = "doc";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String method = request.getMethod();
        if (this.checkMultipleInstancesAccess(request, response)) {
            if (method.equals("GET")) {
                this.doGet(request, response);
            } else if (method.equals("POST")) {
                this.doPost(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        this.updateSessionManager(request);
        Session session = null;
        try {
            session = JCRUtils.getSession();
            if (action.equals("fs")) {
                this.fileSystemList(request, response);
            } else if (action.equals("repo")) {
                this.repositoryList(session, request, response);
            }
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    private void fileSystemList(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("fileSystemList({}, {})", (Object)request, (Object)response);
        String path = WebUtils.getString(request, "path", System.getProperty("user.home"));
        String sel = WebUtils.getString(request, "sel", SEL_BOTH);
        String dst = WebUtils.getString(request, "dst");
        File dir = new File(path);
        ArrayList folders = new ArrayList();
        ArrayList documents = new ArrayList();
        if (!Arrays.asList(File.listRoots()).contains(dir)) {
            HashMap<String, String> item = new HashMap<String, String>();
            File parent = dir.getParentFile();
            item.put("name", "&lt;PARENT FOLDER&gt;");
            item.put("path", parent.getPath());
            item.put("sel", "false");
            folders.add(item);
        }
        for (File f : dir.listFiles()) {
            HashMap<String, String> item = new HashMap<String, String>();
            if (f.isDirectory() && !f.isHidden()) {
                item.put("name", f.getName());
                item.put("path", f.getPath());
                if (sel.equals(SEL_BOTH) || sel.equals(SEL_FOLDER)) {
                    item.put("sel", "true");
                } else {
                    item.put("sel", "false");
                }
                folders.add(item);
                continue;
            }
            if (!f.isFile() || f.isHidden() || !sel.equals(SEL_BOTH) && !sel.equals(SEL_DOCUMENT)) continue;
            item.put("name", f.getName());
            item.put("path", f.getPath());
            item.put("sel", "true");
            documents.add(item);
        }
        Collections.sort(folders, new MapComparator());
        Collections.sort(documents, new MapComparator());
        ServletContext sc = this.getServletContext();
        sc.setAttribute("action", (Object)"fs");
        sc.setAttribute("path", (Object)path);
        sc.setAttribute("dst", (Object)dst);
        sc.setAttribute("sel", (Object)sel);
        sc.setAttribute("folders", folders);
        sc.setAttribute("documents", documents);
        sc.getRequestDispatcher("/admin/data_browser.jsp").forward((ServletRequest)request, (ServletResponse)response);
        UserActivity.log(request.getRemoteUser(), "ADMIN_FILESYSTEM_LIST", path, null);
        log.debug("fileSystemList: void");
    }

    private void repositoryList(Session session, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, PathNotFoundException, RepositoryException {
        log.debug("repositoryList({}, {})", (Object)request, (Object)response);
        Node root = session.getRootNode();
        String path = WebUtils.getString(request, "path", root.getNode("okm:root").getPath());
        String sel = WebUtils.getString(request, "sel", SEL_BOTH);
        String dst = WebUtils.getString(request, "dst");
        ArrayList folders = new ArrayList();
        ArrayList documents = new ArrayList();
        Node base = null;
        if ("/".equals(path)) {
            base = session.getRootNode();
        } else {
            base = session.getRootNode().getNode(path.substring(1));
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("name", "&lt;PARENT FOLDER&gt;");
            item.put("path", base.getParent().getPath());
            item.put("sel", "false");
            folders.add(item);
        }
        NodeIterator ni = base.getNodes();
        while (ni.hasNext()) {
            HashMap<String, String> item;
            Node child = ni.nextNode();
            if (child.isNodeType("okm:folder")) {
                item = new HashMap<String, String>();
                item.put("name", child.getName());
                item.put("path", child.getPath());
                if (sel.equals(SEL_BOTH) || sel.equals(SEL_FOLDER)) {
                    item.put("sel", "true");
                } else {
                    item.put("sel", "false");
                }
                folders.add(item);
                continue;
            }
            if (!child.isNodeType("okm:document") || !sel.equals(SEL_BOTH) && !sel.equals(SEL_DOCUMENT)) continue;
            item = new HashMap();
            item.put("name", child.getName());
            item.put("path", child.getPath());
            item.put("sel", "true");
            documents.add(item);
        }
        Collections.sort(folders, new MapComparator());
        Collections.sort(documents, new MapComparator());
        ServletContext sc = this.getServletContext();
        sc.setAttribute("action", (Object)"repo");
        sc.setAttribute("path", (Object)path);
        sc.setAttribute("dst", (Object)dst);
        sc.setAttribute("sel", (Object)sel);
        sc.setAttribute("folders", folders);
        sc.setAttribute("documents", documents);
        sc.getRequestDispatcher("/admin/data_browser.jsp").forward((ServletRequest)request, (ServletResponse)response);
        UserActivity.log(request.getRemoteUser(), "ADMIN_REPOSITORY_LIST", path, null);
        log.debug("repositoryList: void");
    }

    private class MapComparator
    implements Comparator<Map<String, String>> {
        private MapComparator() {
        }

        @Override
        public int compare(Map<String, String> o1, Map<String, String> o2) {
            return o1.get("name").compareToIgnoreCase(o2.get("name"));
        }
    }
}

