/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.DatabaseMetadataDAO;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.LegacyDAO;
import com.openkm.dao.bean.DatabaseMetadataType;
import com.openkm.dao.bean.DatabaseMetadataValue;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.DatabaseMetadataUtils;
import com.openkm.util.UserActivity;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.classic.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseQueryServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DatabaseQueryServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String method = request.getMethod();
        if (this.checkMultipleInstancesAccess(request, response)) {
            if (method.equals("GET")) {
                this.doGet(request, response);
            } else if (method.equals("POST")) {
                this.doPost(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        this.updateSessionManager(request);
        ServletContext sc = this.getServletContext();
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            sc.setAttribute("qs", null);
            sc.setAttribute("type", null);
            sc.setAttribute("exception", null);
            sc.setAttribute("globalResults", null);
            sc.setAttribute("tables", this.listTables((org.hibernate.Session)session));
            sc.setAttribute("vtables", this.listVirtualTables());
            sc.getRequestDispatcher("/admin/database_query.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            this.sendError(sc, request, response, e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doPost({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        this.updateSessionManager(request);
        ServletContext sc = this.getServletContext();
        Session session = null;
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List items = upload.parseRequest(request);
                InputStream is = null;
                String type = "";
                String qs = "";
                byte[] data = null;
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        if (item.getFieldName().equals("qs")) {
                            qs = item.getString("UTF-8");
                            continue;
                        }
                        if (!item.getFieldName().equals("type")) continue;
                        type = item.getString("UTF-8");
                        continue;
                    }
                    is = item.getInputStream();
                    data = IOUtils.toByteArray((InputStream)is);
                    is.close();
                }
                if (!qs.equals("") && !type.equals("")) {
                    session = HibernateUtil.getSessionFactory().openSession();
                    sc.setAttribute("qs", (Object)qs);
                    sc.setAttribute("type", (Object)type);
                    if (type.equals("jdbc")) {
                        this.executeJdbc((org.hibernate.Session)session, qs, sc, request, response);
                    } else if (type.equals("hibernate")) {
                        this.executeHibernate((org.hibernate.Session)session, qs, sc, request, response);
                    } else if (type.equals("metadata")) {
                        this.executeMetadata((org.hibernate.Session)session, qs, sc, request, response);
                    }
                    UserActivity.log(request.getRemoteUser(), "ADMIN_DATABASE_QUERY", null, qs);
                } else if (data != null && data.length > 0) {
                    sc.setAttribute("exception", null);
                    session = HibernateUtil.getSessionFactory().openSession();
                    this.executeUpdate((org.hibernate.Session)session, data, sc, request, response);
                    UserActivity.log(request.getRemoteUser(), "ADMIN_DATABASE_UPDATE", null, new String(data));
                } else {
                    sc.setAttribute("qs", (Object)qs);
                    sc.setAttribute("type", (Object)type);
                    sc.setAttribute("exception", null);
                    sc.setAttribute("globalResults", new ArrayList());
                    sc.getRequestDispatcher("/admin/database_query.jsp").forward((ServletRequest)request, (ServletResponse)response);
                }
            }
        }
        catch (FileUploadException e) {
            this.sendError(sc, request, response, (Exception)((Object)e));
        }
        catch (SQLException e) {
            this.sendError(sc, request, response, e);
        }
        catch (HibernateException e) {
            this.sendError(sc, request, response, (Exception)((Object)e));
        }
        catch (DatabaseException e) {
            this.sendError(sc, request, response, e);
        }
        catch (IllegalAccessException e) {
            this.sendError(sc, request, response, e);
        }
        catch (InvocationTargetException e) {
            this.sendError(sc, request, response, e);
        }
        catch (NoSuchMethodException e) {
            this.sendError(sc, request, response, e);
        }
        finally {
            HibernateUtil.close(session);
        }
    }

    private void executeMetadata(org.hibernate.Session session, String qs, ServletContext sc, HttpServletRequest request, HttpServletResponse response) throws DatabaseException, ServletException, IOException, HibernateException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        StringTokenizer st = new StringTokenizer(qs, "\n\r");
        ArrayList<GlobalResult> globalResults = new ArrayList<GlobalResult>();
        while (st.hasMoreTokens()) {
            String mds = st.nextToken();
            String[] parts = mds.split("\\|");
            if (parts.length > 1) {
                String hql = null;
                if (parts[0].toUpperCase().equals("SENTENCE")) {
                    if (parts.length <= 2) continue;
                    List<String> tables = Arrays.asList(parts[1].split(","));
                    hql = DatabaseMetadataUtils.replaceVirtual(tables, parts[2]);
                    log.debug("Metadata SENTENCE: {}", (Object)hql);
                    globalResults.add(this.executeHQL(session, hql, tables));
                    continue;
                }
                if (parts[0].toUpperCase().equals("SELECT")) {
                    hql = parts.length > 2 ? DatabaseMetadataUtils.buildQuery(parts[1], parts[2]) : DatabaseMetadataUtils.buildQuery(parts[1], null);
                    log.debug("Metadata SELECT: {}", (Object)hql);
                    globalResults.add(this.executeHQL(session, hql, Arrays.asList(parts[1])));
                    continue;
                }
                if (parts[0].toUpperCase().equals("UPDATE")) {
                    hql = parts.length > 3 ? DatabaseMetadataUtils.buildUpdate(parts[1], parts[2], parts[3]) : (parts.length > 2 ? DatabaseMetadataUtils.buildUpdate(parts[1], parts[2], null) : DatabaseMetadataUtils.buildUpdate(parts[1], null, null));
                    log.debug("Metadata UPDATE: {}", (Object)hql);
                    globalResults.add(this.executeHQL(session, hql, Arrays.asList(parts[1])));
                    continue;
                }
                if (parts[0].toUpperCase().equals("DELETE")) {
                    hql = parts.length > 2 ? DatabaseMetadataUtils.buildDelete(parts[1], parts[2]) : DatabaseMetadataUtils.buildDelete(parts[1], null);
                    log.debug("Metadata DELETE: {}", (Object)hql);
                    globalResults.add(this.executeHQL(session, hql, Arrays.asList(parts[1])));
                    continue;
                }
                throw new DatabaseException("Error in metadata action");
            }
            throw new DatabaseException("Error in metadata sentence parameters");
        }
        sc.setAttribute("exception", null);
        sc.setAttribute("globalResults", globalResults);
        sc.getRequestDispatcher("/admin/database_query.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void executeHibernate(org.hibernate.Session session, String qs, ServletContext sc, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, HibernateException, DatabaseException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        StringTokenizer st = new StringTokenizer(qs, "\n\r");
        ArrayList<GlobalResult> globalResults = new ArrayList<GlobalResult>();
        while (st.hasMoreTokens()) {
            String tk = st.nextToken().trim();
            if (tk.toUpperCase().startsWith("--") || tk.equals("") || tk.equals("\r")) continue;
            globalResults.add(this.executeHQL(session, tk, null));
        }
        sc.setAttribute("exception", null);
        sc.setAttribute("globalResults", globalResults);
        sc.getRequestDispatcher("/admin/database_query.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private GlobalResult executeHQL(org.hibernate.Session session, String hql, List<String> vtables) throws HibernateException, DatabaseException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (hql.toUpperCase().startsWith("SELECT") || hql.toUpperCase().startsWith("FROM")) {
            Query q = session.createQuery(hql);
            List ret = q.list();
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> vcolumns = new ArrayList<String>();
            ArrayList<List<String>> results = new ArrayList<List<String>>();
            Type[] rt = q.getReturnTypes();
            int i = 0;
            if (vtables == null) {
                for (i = 0; i < rt.length; ++i) {
                    columns.add(rt[i].getName());
                }
            } else {
                for (String vtable : vtables) {
                    String query = "select dmt.virtualColumn, dmt.realColumn from DatabaseMetadataType dmt where dmt.table='" + vtable + "'";
                    List<Object> tmp = LegacyDAO.executeQuery(query);
                    for (Object obj : tmp) {
                        Object[] dt = (Object[])obj;
                        vcolumns.add(String.valueOf(dt[0]));
                        columns.add(String.valueOf(dt[0]).concat(" (").concat(String.valueOf(dt[1])).concat(")"));
                    }
                }
            }
            Iterator it = ret.iterator();
            while (it.hasNext() && i++ < Config.MAX_SEARCH_RESULTS) {
                ArrayList<String> row = new ArrayList<String>();
                Object obj = it.next();
                if (vtables == null) {
                    if (obj instanceof Object[]) {
                        Object[] ao = (Object[])obj;
                        for (int j = 0; j < ao.length; ++j) {
                            row.add(String.valueOf(ao[j]));
                        }
                    } else {
                        row.add(String.valueOf(obj));
                    }
                } else if (obj instanceof DatabaseMetadataValue) {
                    for (String column : vcolumns) {
                        row.add(DatabaseMetadataUtils.getString((DatabaseMetadataValue)obj, column));
                    }
                } else if (obj instanceof Object[]) {
                    for (Object objChild : (Object[])obj) {
                        if (objChild instanceof DatabaseMetadataValue) {
                            DatabaseMetadataValue dmvChild = (DatabaseMetadataValue)objChild;
                            List<DatabaseMetadataType> types = DatabaseMetadataDAO.findAllTypes(dmvChild.getTable());
                            for (DatabaseMetadataType emt : types) {
                                for (String column : vcolumns) {
                                    if (!emt.getVirtualColumn().equals(column)) continue;
                                    row.add(BeanUtils.getProperty((Object)dmvChild, (String)emt.getRealColumn()));
                                }
                            }
                            continue;
                        }
                        row.add(String.valueOf(objChild));
                    }
                } else {
                    row.add("Query result should be instance of DatabaseMetadataValue");
                }
                results.add(row);
            }
            GlobalResult gr = new GlobalResult();
            gr.setColumns(columns);
            gr.setResults(results);
            gr.setRows(null);
            gr.setSql(hql);
            return gr;
        }
        GlobalResult gr = new GlobalResult();
        int rows = session.createQuery(hql).executeUpdate();
        gr.setColumns(null);
        gr.setResults(null);
        gr.setRows(rows);
        gr.setSql(hql);
        return gr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJdbc(org.hibernate.Session session, String qs, ServletContext sc, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<GlobalResult> globalResults = new ArrayList<GlobalResult>();
        try {
            con = session.connection();
            stmt = con.createStatement();
            StringTokenizer st = new StringTokenizer(qs, "\n\r");
            while (st.hasMoreTokens()) {
                String tk = st.nextToken().trim();
                if (tk.toUpperCase().startsWith("--") || tk.equals("") || tk.equals("\r")) continue;
                if (tk.endsWith(";")) {
                    tk = tk.substring(0, tk.length() - 1);
                }
                if (tk.toUpperCase().startsWith("SELECT")) {
                    int i;
                    rs = stmt.executeQuery(tk);
                    ResultSetMetaData md = rs.getMetaData();
                    ArrayList<String> columns = new ArrayList<String>();
                    ArrayList<List<String>> results = new ArrayList<List<String>>();
                    for (i = 1; i < md.getColumnCount() + 1; ++i) {
                        columns.add(md.getColumnName(i));
                    }
                    i = 0;
                    while (rs.next() && i++ < Config.MAX_SEARCH_RESULTS) {
                        ArrayList<String> row = new ArrayList<String>();
                        for (int j = 1; j < md.getColumnCount() + 1; ++j) {
                            row.add(rs.getString(j));
                        }
                        results.add(row);
                    }
                    GlobalResult gr = new GlobalResult();
                    gr.setColumns(columns);
                    gr.setResults(results);
                    gr.setRows(null);
                    gr.setSql(tk);
                    globalResults.add(gr);
                    continue;
                }
                GlobalResult gr = new GlobalResult();
                int rows = stmt.executeUpdate(tk);
                gr.setColumns(null);
                gr.setResults(null);
                gr.setRows(rows);
                gr.setSql(tk);
                globalResults.add(gr);
            }
        }
        finally {
            LegacyDAO.close(rs);
            LegacyDAO.close(stmt);
            LegacyDAO.close(con);
        }
        sc.setAttribute("exception", null);
        sc.setAttribute("globalResults", globalResults);
        sc.getRequestDispatcher("/admin/database_query.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(org.hibernate.Session session, byte[] data, ServletContext sc, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException {
        log.debug("executeUpdate({}, {}, {})", new Object[]{session, request, response});
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<HashMap<String, String>> errors = new ArrayList<HashMap<String, String>>();
        ArrayList<GlobalResult> globalResults = new ArrayList<GlobalResult>();
        int rows = 0;
        try {
            String sql;
            con = session.connection();
            stmt = con.createStatement();
            InputStreamReader is = new InputStreamReader(new ByteArrayInputStream(data));
            BufferedReader br = new BufferedReader(is);
            int ln = 0;
            while ((sql = br.readLine()) != null) {
                String trimmedSql = sql.trim();
                ++ln;
                if (trimmedSql.length() <= 0 || trimmedSql.startsWith("--")) continue;
                try {
                    if (trimmedSql.endsWith(";")) {
                        trimmedSql = trimmedSql.substring(0, trimmedSql.length() - 1);
                    }
                    rows += stmt.executeUpdate(trimmedSql);
                }
                catch (SQLException e) {
                    HashMap<String, String> error = new HashMap<String, String>();
                    error.put("ln", Integer.toString(ln));
                    error.put("sql", trimmedSql);
                    error.put("msg", e.getMessage());
                    errors.add(error);
                }
            }
        }
        finally {
            LegacyDAO.close(rs);
            LegacyDAO.close(stmt);
            LegacyDAO.close(con);
        }
        GlobalResult gr = new GlobalResult();
        gr.setColumns(null);
        gr.setResults(null);
        gr.setRows(rows);
        gr.setErrors(errors);
        globalResults.add(gr);
        sc.setAttribute("qs", null);
        sc.setAttribute("type", null);
        sc.setAttribute("globalResults", globalResults);
        sc.getRequestDispatcher("/admin/database_query.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("executeUpdate: void");
    }

    private List<String> listTables(org.hibernate.Session session) {
        final ArrayList<String> tables = new ArrayList<String>();
        final String[] tableTypes = new String[]{"TABLE"};
        final String[] tablePatterns = new String[]{"JBPM_%", "OKM_%", "DEFAULT_%", "VERSION_%", "jbpm_%", "okm_%", "default_%", "version_%"};
        session.doWork(new Work(){

            public void execute(Connection con) throws SQLException {
                DatabaseMetaData md = con.getMetaData();
                for (String table : tablePatterns) {
                    ResultSet rs = md.getTables(null, null, table, tableTypes);
                    while (rs.next()) {
                        tables.add(rs.getString(3));
                    }
                    rs.close();
                }
            }
        });
        return tables;
    }

    private List<String> listVirtualTables() throws DatabaseException {
        String query = "select distinct(dmv.table) from DatabaseMetadataType dmv order by dmv.table";
        List<Object> tmp = LegacyDAO.executeQuery(query);
        ArrayList<String> tables = new ArrayList<String>();
        for (Object obj : tmp) {
            tables.add(String.valueOf(obj));
        }
        return tables;
    }

    protected void sendError(ServletContext sc, HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException, IOException {
        sc.setAttribute("exception", (Object)e);
        sc.setAttribute("globalResults", null);
        sc.getRequestDispatcher("/admin/database_query.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public class GlobalResult {
        private List<HashMap<String, String>> errors = new ArrayList<HashMap<String, String>>();
        private List<List<String>> results = new ArrayList<List<String>>();
        private List<String> columns = new ArrayList<String>();
        private Integer rows = new Integer(0);
        private String sql = new String();

        public List<String> getColumns() {
            return this.columns;
        }

        public void setColumns(List<String> columns) {
            this.columns = columns;
        }

        public List<List<String>> getResults() {
            return this.results;
        }

        public void setResults(List<List<String>> results) {
            this.results = results;
        }

        public Integer getRows() {
            return this.rows;
        }

        public void setRows(Integer rows) {
            this.rows = rows;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public List<HashMap<String, String>> getErrors() {
            return this.errors;
        }

        public void setErrors(List<HashMap<String, String>> errors) {
            this.errors = errors;
        }
    }
}

