/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.api.OKMPropertyGroup;
import com.openkm.api.OKMWorkflow;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.RepositoryException;
import com.openkm.core.WorkflowException;
import com.openkm.dao.DocumentFilterDAO;
import com.openkm.dao.MimeTypeDAO;
import com.openkm.dao.bean.DocumentFilter;
import com.openkm.dao.bean.DocumentFilterRule;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.IOException;
import javax.jcr.LoginException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentFilterServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DocumentFilterServlet.class);
    String[] types = new String[]{"PATH", "MIME_TYPE"};
    String[] actions = new String[]{"WIZARD_PROPERTY_GROUP", "WIZARD_WORKFLOW", "WIZARD_CATEGORY", "WIZARD_KEYWORD", "ASSIGN_PROPERTY_GROUP", "ASSIGN_WORKFLOW", "ADD_CATEGORY", "ADD_KEYWORD", "EXTRACT_METADATA"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("create")) {
                this.create(session, request, response);
            } else if (action.equals("edit")) {
                this.edit(session, request, response);
            } else if (action.equals("delete")) {
                this.delete(session, request, response);
            } else if (action.equals("ruleList")) {
                this.ruleList(session, request, response);
            } else if (action.equals("ruleCreate")) {
                this.ruleCreate(session, request, response);
            } else if (action.equals("ruleEdit")) {
                this.ruleEdit(session, request, response);
            } else if (action.equals("ruleDelete")) {
                this.ruleDelete(session, request, response);
            }
            if (action.equals("") || WebUtils.getBoolean(request, "persist")) {
                if (action.startsWith("rule")) {
                    this.ruleList(session, request, response);
                } else {
                    this.list(session, request, response);
                }
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    private void list(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("list({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        sc.setAttribute("documentFilters", DocumentFilterDAO.findAll(false));
        sc.getRequestDispatcher("/admin/document_filter_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("list: void");
    }

    private void create(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, javax.jcr.RepositoryException {
        log.debug("create({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            DocumentFilter df = new DocumentFilter();
            df.setType(WebUtils.getString(request, "df_type"));
            df.setActive(WebUtils.getBoolean(request, "df_active"));
            if ("MIME_TYPE".equals(df.getType())) {
                df.setValue(WebUtils.getString(request, "df_value_mime"));
                if (MimeTypeDAO.findByName(df.getValue()) == null) {
                    throw new DatabaseException("Mime type not registered");
                }
            } else if ("PATH".equals(df.getType())) {
                df.setValue(WebUtils.getString(request, "df_value_path"));
                if (!session.getRootNode().hasNode(df.getValue())) {
                    throw new javax.jcr.RepositoryException("Node path not found");
                }
            }
            DocumentFilterDAO.create(df);
            UserActivity.log(session.getUserID(), "ADMIN_DOCUMENT_FILTER_CREATE", Integer.toString(df.getId()), df.toString());
        } else {
            ServletContext sc = this.getServletContext();
            DocumentFilter df = new DocumentFilter();
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("types", (Object)this.types);
            sc.setAttribute("mimes", MimeTypeDAO.findAll("mt.name"));
            sc.setAttribute("df", (Object)df);
            sc.getRequestDispatcher("/admin/document_filter_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("create: void");
    }

    private void edit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, javax.jcr.RepositoryException {
        log.debug("edit({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            DocumentFilter df = new DocumentFilter();
            df.setId(WebUtils.getInt(request, "df_id"));
            df.setType(WebUtils.getString(request, "df_type"));
            df.setActive(WebUtils.getBoolean(request, "df_active"));
            if ("MIME_TYPE".equals(df.getType())) {
                df.setValue(WebUtils.getString(request, "df_value_mime"));
                if (MimeTypeDAO.findByName(df.getValue()) == null) {
                    throw new DatabaseException("Mime type not registered");
                }
            } else if ("PATH".equals(df.getType())) {
                df.setValue(WebUtils.getString(request, "df_value_path"));
                if (!session.getRootNode().hasNode(df.getValue())) {
                    throw new javax.jcr.RepositoryException("Node path not found");
                }
            }
            DocumentFilterDAO.update(df);
            UserActivity.log(session.getUserID(), "ADMIN_DOCUMENT_FILTER_EDIT", Integer.toString(df.getId()), df.toString());
        } else {
            ServletContext sc = this.getServletContext();
            int dfId = WebUtils.getInt(request, "df_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("types", (Object)this.types);
            sc.setAttribute("mimes", MimeTypeDAO.findAll("mt.name"));
            sc.setAttribute("df", (Object)DocumentFilterDAO.findByPk(dfId));
            sc.getRequestDispatcher("/admin/document_filter_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("edit: void");
    }

    private void delete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, javax.jcr.RepositoryException {
        log.debug("delete({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int dfId = WebUtils.getInt(request, "df_id");
            DocumentFilterDAO.delete(dfId);
            UserActivity.log(session.getUserID(), "ADMIN_DOCUMENT_FILTER_DELETE", Integer.toString(dfId), null);
        } else {
            ServletContext sc = this.getServletContext();
            int dfId = WebUtils.getInt(request, "df_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("types", (Object)this.types);
            sc.setAttribute("mimes", MimeTypeDAO.findAll("mt.name"));
            sc.setAttribute("df", (Object)DocumentFilterDAO.findByPk(dfId));
            sc.getRequestDispatcher("/admin/document_filter_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("delete: void");
    }

    private void ruleList(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("ruleList({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        int dfId = WebUtils.getInt(request, "df_id");
        DocumentFilter df = DocumentFilterDAO.findByPk(dfId);
        sc.setAttribute("df_id", (Object)dfId);
        sc.setAttribute("filterRules", df.getFilterRules());
        sc.getRequestDispatcher("/admin/document_filter_rule_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("ruleList: void");
    }

    private void ruleCreate(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, javax.jcr.RepositoryException, ParseException, RepositoryException, WorkflowException {
        log.debug("ruleCreate({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int df_id = WebUtils.getInt(request, "df_id");
            DocumentFilterRule dfr = new DocumentFilterRule();
            dfr.setAction(WebUtils.getString(request, "dfr_action"));
            dfr.setActive(WebUtils.getBoolean(request, "dfr_active"));
            if ("WIZARD_PROPERTY_GROUP".equals(dfr.getAction()) || "ASSIGN_PROPERTY_GROUP".equals(dfr.getAction())) {
                dfr.setValue(WebUtils.getString(request, "dfr_value_pg"));
            } else if ("WIZARD_WORKFLOW".equals(dfr.getAction()) || "ASSIGN_WORKFLOW".equals(dfr.getAction())) {
                dfr.setValue(WebUtils.getString(request, "dfr_value_wf"));
            } else if ("WIZARD_CATEGORY".equals(dfr.getAction()) || "WIZARD_KEYWORD".equals(dfr.getAction()) || "EXTRACT_METADATA".equals(dfr.getAction())) {
                dfr.setValue(Boolean.toString(WebUtils.getBoolean(request, "dfr_value_bool")));
            } else if ("ADD_CATEGORY".equals(dfr.getAction()) || "ADD_KEYWORD".equals(dfr.getAction())) {
                dfr.setValue(WebUtils.getString(request, "dfr_value_str"));
            }
            DocumentFilter df = DocumentFilterDAO.findByPk(df_id);
            df.getFilterRules().add(dfr);
            DocumentFilterDAO.update(df);
            UserActivity.log(session.getUserID(), "ADMIN_DOCUMENT_FILTER_RULE_CREATE", Integer.toString(df.getId()), df.toString());
        } else {
            ServletContext sc = this.getServletContext();
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("df_id", (Object)WebUtils.getInt(request, "df_id"));
            sc.setAttribute("dfr", (Object)new DocumentFilterRule());
            sc.setAttribute("actions", (Object)this.actions);
            sc.setAttribute("pgroups", OKMPropertyGroup.getInstance().getAllGroups(null));
            sc.setAttribute("wflows", OKMWorkflow.getInstance().findAllProcessDefinitions(null));
            sc.getRequestDispatcher("/admin/document_filter_rule_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("ruleCreate: void");
    }

    private void ruleEdit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, javax.jcr.RepositoryException, ParseException, RepositoryException, WorkflowException {
        log.debug("ruleEdit({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int dfrId = WebUtils.getInt(request, "dfr_id");
            DocumentFilterRule dfr = DocumentFilterDAO.findRuleByPk(dfrId);
            if (dfr != null) {
                dfr.setAction(WebUtils.getString(request, "dfr_action"));
                dfr.setActive(WebUtils.getBoolean(request, "dfr_active"));
                if ("WIZARD_PROPERTY_GROUP".equals(dfr.getAction()) || "ASSIGN_PROPERTY_GROUP".equals(dfr.getAction())) {
                    dfr.setValue(WebUtils.getString(request, "dfr_value_pg"));
                } else if ("WIZARD_WORKFLOW".equals(dfr.getAction()) || "ASSIGN_WORKFLOW".equals(dfr.getAction())) {
                    dfr.setValue(WebUtils.getString(request, "dfr_value_wf"));
                } else if ("WIZARD_CATEGORY".equals(dfr.getAction()) || "WIZARD_KEYWORD".equals(dfr.getAction()) || "EXTRACT_METADATA".equals(dfr.getAction())) {
                    dfr.setValue(Boolean.toString(WebUtils.getBoolean(request, "dfr_value_bool")));
                } else if ("ADD_CATEGORY".equals(dfr.getAction()) || "ADD_KEYWORD".equals(dfr.getAction())) {
                    dfr.setValue(WebUtils.getString(request, "dfr_value_str"));
                }
                DocumentFilterDAO.updateRule(dfr);
            }
            UserActivity.log(session.getUserID(), "ADMIN_DOCUMENT_FILTER_RULE_EDIT", Integer.toString(dfr.getId()), dfr.toString());
        } else {
            ServletContext sc = this.getServletContext();
            int dfrId = WebUtils.getInt(request, "dfr_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("df_id", (Object)WebUtils.getInt(request, "df_id"));
            sc.setAttribute("dfr", (Object)DocumentFilterDAO.findRuleByPk(dfrId));
            sc.setAttribute("actions", (Object)this.actions);
            sc.setAttribute("pgroups", OKMPropertyGroup.getInstance().getAllGroups(null));
            sc.setAttribute("wflows", OKMWorkflow.getInstance().findAllProcessDefinitions(null));
            sc.getRequestDispatcher("/admin/document_filter_rule_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("ruleEdit: void");
    }

    private void ruleDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, ParseException, RepositoryException, WorkflowException {
        log.debug("ruleDelete({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int dfrId = WebUtils.getInt(request, "dfr_id");
            DocumentFilterDAO.deleteRule(dfrId);
            UserActivity.log(session.getUserID(), "ADMIN_DOCUMENT_FILTER_RULE_DELETE", Integer.toString(dfrId), null);
        } else {
            ServletContext sc = this.getServletContext();
            int dfrId = WebUtils.getInt(request, "dfr_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("df_id", (Object)WebUtils.getInt(request, "df_id"));
            sc.setAttribute("dfr", (Object)DocumentFilterDAO.findRuleByPk(dfrId));
            sc.setAttribute("actions", (Object)this.actions);
            sc.setAttribute("pgroups", OKMPropertyGroup.getInstance().getAllGroups(null));
            sc.setAttribute("wflows", OKMWorkflow.getInstance().findAllProcessDefinitions(null));
            sc.getRequestDispatcher("/admin/document_filter_rule_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("ruleDelete: void");
    }
}

