/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.LanguageDAO;
import com.openkm.dao.LegacyDAO;
import com.openkm.dao.bean.Language;
import com.openkm.dao.bean.Translation;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.SecureStore;
import com.openkm.util.WarUtils;
import com.openkm.util.WebUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(LanguageServlet.class);
    private final String LANG_BASE_CODE = "en-GB";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String method = request.getMethod();
        if (this.checkMultipleInstancesAccess(request, response)) {
            if (method.equals("GET")) {
                this.doGet(request, response);
            } else if (method.equals("POST")) {
                this.doPost(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("edit")) {
                this.edit(session, request, response);
            } else if (action.equals("delete")) {
                this.delete(session, request, response);
            } else if (action.equals("create")) {
                this.create(session, request, response);
            } else if (action.equals("translate")) {
                this.translate(session, request, response);
            } else if (action.equals("flag")) {
                this.flag(session, request, response);
            } else if (action.equals("export")) {
                this.export(session, request, response);
            } else if (action.equals("addTranslation")) {
                this.addTranslation(session, request, response);
            }
            if (action.equals("") || WebUtils.getBoolean(request, "persist")) {
                this.list(session, request, response);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    /*
     * Exception decompiling
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void list(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, RepositoryException {
        log.debug("list({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        sc.setAttribute("langs", LanguageDAO.findAll());
        sc.setAttribute("max", (Object)LanguageDAO.findByPk("en-GB").getTranslations().size());
        sc.getRequestDispatcher("/admin/language_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("list: void");
    }

    private void delete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("delete({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        String lgId = WebUtils.getString(request, "lg_id");
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("lang", (Object)LanguageDAO.findByPk(lgId));
        sc.getRequestDispatcher("/admin/language_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("delete: void");
    }

    private void edit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("edit({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        String lgId = WebUtils.getString(request, "lg_id");
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("lang", (Object)LanguageDAO.findByPk(lgId));
        sc.getRequestDispatcher("/admin/language_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("edit: void");
    }

    private void create(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("edit({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("lang", null);
        sc.getRequestDispatcher("/admin/language_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("edit: void");
    }

    private void addTranslation(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("addTranslation({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            Language lang = LanguageDAO.findByPk("en-GB");
            Translation trans = new Translation();
            trans.getTranslationId().setModule(WebUtils.getString(request, "tr_module"));
            trans.getTranslationId().setKey(WebUtils.getString(request, "tr_key"));
            trans.getTranslationId().setLanguage(lang.getId());
            trans.setText(WebUtils.getString(request, "tr_text"));
            lang.getTranslations().add(trans);
            LanguageDAO.update(lang);
        }
        ArrayList<String> modules = new ArrayList<String>();
        modules.add("frontend");
        modules.add("extension");
        modules.add("administration");
        ServletContext sc = this.getServletContext();
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("tr_module", modules);
        sc.setAttribute("tr_key", (Object)"");
        sc.setAttribute("tr_text", (Object)"");
        sc.setAttribute("lang", (Object)LanguageDAO.findByPk("en-GB"));
        sc.getRequestDispatcher("/admin/translation_add.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("addTranslation: void");
    }

    private void translate(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("translate({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            HashSet<Translation> newTranslations = new HashSet<Translation>();
            Language langBase = LanguageDAO.findByPk("en-GB");
            Language lang = LanguageDAO.findByPk(request.getParameter("lg_id"));
            for (Translation translation : langBase.getTranslations()) {
                String text = request.getParameter(translation.getTranslationId().getKey());
                if (text == null || text.equals("")) continue;
                Translation newTranslation = new Translation();
                newTranslation.getTranslationId().setModule(translation.getTranslationId().getModule());
                newTranslation.getTranslationId().setKey(translation.getTranslationId().getKey());
                newTranslation.getTranslationId().setLanguage(lang.getId());
                newTranslation.setText(text);
                newTranslations.add(newTranslation);
            }
            lang.setTranslations(newTranslations);
            LanguageDAO.update(lang);
        } else {
            ServletContext sc = this.getServletContext();
            String lgId = WebUtils.getString(request, "lg_id");
            Language langToTranslate = LanguageDAO.findByPk(lgId);
            HashMap<String, String> translations = new HashMap<String, String>();
            for (Translation translation : langToTranslate.getTranslations()) {
                translations.put(translation.getTranslationId().getKey(), translation.getText());
            }
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("lg_id", (Object)lgId);
            sc.setAttribute("langToTranslateName", (Object)langToTranslate.getName());
            sc.setAttribute("translations", translations);
            sc.setAttribute("langBase", (Object)LanguageDAO.findByPk("en-GB"));
            sc.getRequestDispatcher("/admin/translation_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("translate: void");
    }

    private void flag(Session session, HttpServletRequest request, HttpServletResponse response) throws DatabaseException, IOException {
        log.debug("flag({}, {}, {})", new Object[]{session, request, response});
        String lgId = WebUtils.getString(request, "lg_id");
        ServletOutputStream out = response.getOutputStream();
        Language language = LanguageDAO.findByPk(lgId);
        byte[] img = SecureStore.b64Decode(new String(language.getImageContent()));
        response.setContentType(language.getImageMime());
        response.setContentLength(img.length);
        out.write(img);
        out.flush();
        log.debug("flag: void");
    }

    private void export(Session session, HttpServletRequest request, HttpServletResponse response) throws DatabaseException, IOException {
        log.debug("export({}, {}, {})", new Object[]{session, request, response});
        String lgId = WebUtils.getString(request, "lg_id");
        Language language = LanguageDAO.findByPk(lgId);
        response.setHeader("Expires", "Sat, 6 May 1971 12:00:00 GMT");
        response.setHeader("Cache-Control", "max-age=0, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        String fileName = "OpenKM_" + WarUtils.getAppVersion().getVersion() + "_" + language.getId() + ".sql";
        response.setHeader("Content-disposition", "inline; filename=\"" + fileName + "\"");
        response.setContentType("text/x-sql; charset=UTF-8");
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF8"), true);
        out.println("DELETE FROM OKM_TRANSLATION WHERE TR_LANGUAGE='" + language.getId() + "';");
        out.println("DELETE FROM OKM_LANGUAGE WHERE LG_ID='" + language.getId() + "';");
        StringBuffer insertLang = new StringBuffer("INSERT INTO OKM_LANGUAGE (LG_ID, LG_NAME, LG_IMAGE_CONTENT, LG_IMAGE_MIME) VALUES ('");
        insertLang.append(language.getId()).append("', '");
        insertLang.append(language.getName()).append("', '");
        insertLang.append(language.getImageContent()).append("', '");
        insertLang.append(language.getImageMime()).append("');");
        out.println(insertLang);
        for (Translation translation : language.getTranslations()) {
            StringBuffer insertTranslation = new StringBuffer("INSERT INTO OKM_TRANSLATION (TR_MODULE, TR_KEY, TR_TEXT, TR_LANGUAGE) VALUES (");
            insertTranslation.append("'");
            insertTranslation.append(translation.getTranslationId().getModule()).append("', '");
            insertTranslation.append(translation.getTranslationId().getKey()).append("', '");
            insertTranslation.append(translation.getText().replaceAll("'", "''")).append("', '");
            insertTranslation.append(language.getId()).append("');");
            out.println(insertTranslation);
        }
        out.flush();
        log.debug("export: void");
    }

    private void importLanguage(Session session, HttpServletRequest request, HttpServletResponse response, byte[] data, org.hibernate.classic.Session dbSession) throws DatabaseException, IOException, SQLException {
        String query;
        log.debug("import({}, {}, {}, {}, {})", new Object[]{session, request, response, data, dbSession});
        Connection con = dbSession.connection();
        Statement stmt = con.createStatement();
        InputStreamReader is = new InputStreamReader(new ByteArrayInputStream(data));
        BufferedReader br = new BufferedReader(is);
        while ((query = br.readLine()) != null) {
            stmt.executeUpdate(query);
        }
        LegacyDAO.close(stmt);
        LegacyDAO.close(con);
        log.debug("import: void");
    }
}

