/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.core.DatabaseException;
import com.openkm.core.UserMailImporter;
import com.openkm.dao.MailAccountDAO;
import com.openkm.dao.bean.MailAccount;
import com.openkm.dao.bean.MailFilter;
import com.openkm.dao.bean.MailFilterRule;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.MailUtils;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAccountServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(MailAccountServlet.class);
    String[] fields = new String[]{"FROM", "TO", "SUBJECT", "CONTENT"};
    String[] operations = new String[]{"CONTAINS", "EQUALS"};
    String[] protocols = new String[]{"pop3", "pop3s", "imap", "imaps"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("create")) {
                this.create(session, request, response);
            } else if (action.equals("edit")) {
                this.edit(session, request, response);
            } else if (action.equals("delete")) {
                this.delete(session, request, response);
            } else if (action.equals("filterList")) {
                this.filterList(session, request, response);
            } else if (action.equals("filterCreate")) {
                this.filterCreate(session, request, response);
            } else if (action.equals("filterEdit")) {
                this.filterEdit(session, request, response);
            } else if (action.equals("filterDelete")) {
                this.filterDelete(session, request, response);
            } else if (action.equals("ruleList")) {
                this.ruleList(session, request, response);
            } else if (action.equals("ruleCreate")) {
                this.ruleCreate(session, request, response);
            } else if (action.equals("ruleEdit")) {
                this.ruleEdit(session, request, response);
            } else if (action.equals("ruleDelete")) {
                this.ruleDelete(session, request, response);
            }
            if (action.equals("") || WebUtils.getBoolean(request, "persist")) {
                if (action.startsWith("filter")) {
                    this.filterList(session, request, response);
                } else if (action.startsWith("rule")) {
                    this.ruleList(session, request, response);
                } else {
                    this.list(session, request, response);
                }
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        PrintWriter pw = response.getWriter();
        try {
            session = JCRUtils.getSession();
            if (action.equals("check")) {
                this.check(session, request, response);
                pw.print("Success!");
            } else if (action.equals("checkAll")) {
                UserMailImporter umi = new UserMailImporter();
                if (umi.isRunning()) {
                    pw.print("User mail import already running");
                } else {
                    umi.run();
                    if (umi.getExceptionMessages().isEmpty()) {
                        pw.print("Success!");
                    } else {
                        for (String em : umi.getExceptionMessages()) {
                            pw.print(em + "<br/>");
                        }
                    }
                }
                UserActivity.log(session.getUserID(), "ADMIN_MAIL_ACCOUNT_CHECK_ALL", null, null);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            pw.print(e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            pw.print(e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            pw.print(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            pw.print(e.getMessage());
        }
        finally {
            JCRUtils.logout(session);
            pw.flush();
            pw.close();
        }
    }

    private void create(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("create({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            MailAccount ma = new MailAccount();
            ma.setUser(WebUtils.getString(request, "ma_user"));
            ma.setMailProtocol(WebUtils.getString(request, "ma_mprotocol"));
            ma.setMailUser(WebUtils.getString(request, "ma_muser"));
            ma.setMailPassword(WebUtils.getString(request, "ma_mpassword"));
            ma.setMailHost(WebUtils.getString(request, "ma_mhost"));
            ma.setMailFolder(WebUtils.getString(request, "ma_mfolder"));
            ma.setMailMarkSeen(WebUtils.getBoolean(request, "ma_mmark_seen"));
            ma.setMailMarkDeleted(WebUtils.getBoolean(request, "ma_mmark_deleted"));
            ma.setActive(WebUtils.getBoolean(request, "ma_active"));
            MailAccountDAO.create(ma);
            UserActivity.log(session.getUserID(), "ADMIN_MAIL_ACCOUNT_CREATE", ma.getUser(), ma.toString());
        } else {
            ServletContext sc = this.getServletContext();
            MailAccount ma = new MailAccount();
            ma.setUser(WebUtils.getString(request, "ma_user"));
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ma", (Object)ma);
            sc.setAttribute("protocols", (Object)this.protocols);
            sc.getRequestDispatcher("/admin/mail_account_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("create: void");
    }

    private void edit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("edit({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            String password = WebUtils.getString(request, "ma_mpassword");
            MailAccount ma = new MailAccount();
            ma.setId(WebUtils.getInt(request, "ma_id"));
            ma.setUser(WebUtils.getString(request, "ma_user"));
            ma.setMailProtocol(WebUtils.getString(request, "ma_mprotocol"));
            ma.setMailUser(WebUtils.getString(request, "ma_muser"));
            ma.setMailHost(WebUtils.getString(request, "ma_mhost"));
            ma.setMailFolder(WebUtils.getString(request, "ma_mfolder"));
            ma.setMailMarkSeen(WebUtils.getBoolean(request, "ma_mmark_seen"));
            ma.setMailMarkDeleted(WebUtils.getBoolean(request, "ma_mmark_deleted"));
            ma.setActive(WebUtils.getBoolean(request, "ma_active"));
            MailAccountDAO.update(ma);
            if (!password.equals("")) {
                MailAccountDAO.updatePassword(ma.getId(), password);
            }
            UserActivity.log(session.getUserID(), "ADMIN_MAIL_ACCOUNT_EDIT", Integer.toString(ma.getId()), ma.toString());
        } else {
            ServletContext sc = this.getServletContext();
            int maId = WebUtils.getInt(request, "ma_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ma", (Object)MailAccountDAO.findByPk(maId));
            sc.setAttribute("protocols", (Object)this.protocols);
            sc.getRequestDispatcher("/admin/mail_account_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("edit: void");
    }

    private void check(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("check({}, {}, {})", new Object[]{session, request, response});
        MailAccount ma = new MailAccount();
        ma.setId(WebUtils.getInt(request, "ma_id"));
        ma.setUser(WebUtils.getString(request, "ma_user"));
        ma.setMailUser(WebUtils.getString(request, "ma_muser"));
        ma.setMailProtocol(WebUtils.getString(request, "ma_mprotocol"));
        ma.setMailPassword(WebUtils.getString(request, "ma_mpassword"));
        ma.setMailHost(WebUtils.getString(request, "ma_mhost"));
        ma.setMailFolder(WebUtils.getString(request, "ma_mfolder"));
        ma.setMailMarkSeen(WebUtils.getBoolean(request, "ma_mmark_seen"));
        ma.setMailMarkDeleted(WebUtils.getBoolean(request, "ma_mmark_deleted"));
        ma.setActive(WebUtils.getBoolean(request, "ma_active"));
        MailUtils.testConnection(ma);
        UserActivity.log(session.getUserID(), "ADMIN_MAIL_ACCOUNT_CHECK", Integer.toString(ma.getId()), ma.toString());
        log.debug("check: void");
    }

    private void delete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("delete({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int maId = WebUtils.getInt(request, "ma_id");
            MailAccountDAO.delete(maId);
            UserActivity.log(session.getUserID(), "ADMIN_MAIL_ACCOUNT_DELETE", Integer.toString(maId), null);
        } else {
            ServletContext sc = this.getServletContext();
            int maId = WebUtils.getInt(request, "ma_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ma", (Object)MailAccountDAO.findByPk(maId));
            sc.setAttribute("protocols", (Object)this.protocols);
            sc.getRequestDispatcher("/admin/mail_account_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("delete: void");
    }

    private void list(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("list({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        String usrId = WebUtils.getString(request, "ma_user");
        sc.setAttribute("ma_user", (Object)usrId);
        sc.setAttribute("mailAccounts", MailAccountDAO.findByUser(usrId, false));
        sc.getRequestDispatcher("/admin/mail_account_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("list: void");
    }

    private void filterList(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("filterList({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        int maId = WebUtils.getInt(request, "ma_id");
        String ma_user = WebUtils.getString(request, "ma_user");
        sc.setAttribute("ma_id", (Object)maId);
        sc.setAttribute("ma_user", (Object)ma_user);
        MailAccount ma = MailAccountDAO.findByPk(maId);
        sc.setAttribute("mailFilters", ma.getMailFilters());
        sc.getRequestDispatcher("/admin/mail_filter_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("filterList: void");
    }

    private void filterCreate(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, RepositoryException {
        log.debug("filterCreate({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int maId = WebUtils.getInt(request, "ma_id");
            MailFilter mf = new MailFilter();
            mf.setPath(WebUtils.getString(request, "mf_path"));
            mf.setUuid(JCRUtils.getUUID(session, mf.getPath()));
            mf.setGrouping(WebUtils.getBoolean(request, "mf_grouping"));
            mf.setActive(WebUtils.getBoolean(request, "mf_active"));
            MailAccount ma = MailAccountDAO.findByPk(maId);
            ma.getMailFilters().add(mf);
            MailAccountDAO.update(ma);
            UserActivity.log(session.getUserID(), "ADMIN_MAIL_FILTER_CREATE", Integer.toString(ma.getId()), mf.toString());
        } else {
            ServletContext sc = this.getServletContext();
            MailFilter mf = new MailFilter();
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("mf", (Object)mf);
            sc.getRequestDispatcher("/admin/mail_filter_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("filterCreate: void");
    }

    private void filterEdit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, RepositoryException {
        log.debug("filterEdit({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int mfId = WebUtils.getInt(request, "mf_id");
            MailFilter mf = MailAccountDAO.findFilterByPk(session, mfId);
            if (mf != null) {
                mf.setPath(WebUtils.getString(request, "mf_path"));
                mf.setUuid(JCRUtils.getUUID(session, mf.getPath()));
                mf.setGrouping(WebUtils.getBoolean(request, "mf_grouping"));
                mf.setActive(WebUtils.getBoolean(request, "mf_active"));
                MailAccountDAO.updateFilter(mf);
            }
            UserActivity.log(session.getUserID(), "ADMIN_MAIL_FILTER_EDIT", Integer.toString(mf.getId()), mf.toString());
        } else {
            ServletContext sc = this.getServletContext();
            int maId = WebUtils.getInt(request, "ma_id");
            int mfId = WebUtils.getInt(request, "mf_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ma_id", (Object)maId);
            sc.setAttribute("mf", (Object)MailAccountDAO.findFilterByPk(session, mfId));
            sc.getRequestDispatcher("/admin/mail_filter_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("filterEdit: void");
    }

    private void filterDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, RepositoryException {
        log.debug("filterDelete({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int maId = WebUtils.getInt(request, "ma_id");
            int mfId = WebUtils.getInt(request, "mf_id");
            MailAccountDAO.deleteFilter(mfId);
            UserActivity.log(session.getUserID(), "ADMIN_MAIL_FILTER_DELETE", Integer.toString(maId), null);
        } else {
            ServletContext sc = this.getServletContext();
            int maId = WebUtils.getInt(request, "ma_id");
            int mfId = WebUtils.getInt(request, "mf_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ma_id", (Object)maId);
            sc.setAttribute("mf", (Object)MailAccountDAO.findFilterByPk(session, mfId));
            sc.getRequestDispatcher("/admin/mail_filter_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("filterDelete: void");
    }

    private void ruleList(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("ruleList({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        int maId = WebUtils.getInt(request, "ma_id");
        int mfId = WebUtils.getInt(request, "mf_id");
        sc.setAttribute("ma_id", (Object)maId);
        sc.setAttribute("mf_id", (Object)mfId);
        MailAccount ma = MailAccountDAO.findByPk(maId);
        for (MailFilter mf : ma.getMailFilters()) {
            if (mf.getId() != mfId) continue;
            sc.setAttribute("filterRules", mf.getFilterRules());
        }
        sc.getRequestDispatcher("/admin/mail_filter_rule_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("ruleList: void");
    }

    private void ruleCreate(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, RepositoryException {
        log.debug("ruleCreate({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int mf_id = WebUtils.getInt(request, "mf_id");
            MailFilterRule mfr = new MailFilterRule();
            mfr.setField(WebUtils.getString(request, "mfr_field"));
            mfr.setOperation(WebUtils.getString(request, "mfr_operation"));
            mfr.setValue(WebUtils.getString(request, "mfr_value"));
            mfr.setActive(WebUtils.getBoolean(request, "mfr_active"));
            MailFilter mf = MailAccountDAO.findFilterByPk(session, mf_id);
            mf.getFilterRules().add(mfr);
            MailAccountDAO.updateFilter(mf);
            UserActivity.log(session.getUserID(), "ADMIN_MAIL_FILTER_RULE_CREATE", Integer.toString(mf.getId()), mf.toString());
        } else {
            ServletContext sc = this.getServletContext();
            MailFilterRule mfr = new MailFilterRule();
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("mfr", (Object)mfr);
            sc.setAttribute("fields", (Object)this.fields);
            sc.setAttribute("operations", (Object)this.operations);
            sc.getRequestDispatcher("/admin/mail_filter_rule_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("ruleCreate: void");
    }

    private void ruleEdit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, RepositoryException {
        log.debug("ruleEdit({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int mfrId = WebUtils.getInt(request, "mfr_id");
            MailFilterRule mfr = MailAccountDAO.findRuleByPk(mfrId);
            if (mfr != null) {
                mfr.setField(WebUtils.getString(request, "mfr_field"));
                mfr.setOperation(WebUtils.getString(request, "mfr_operation"));
                mfr.setValue(WebUtils.getString(request, "mfr_value"));
                mfr.setActive(WebUtils.getBoolean(request, "mfr_active"));
                MailAccountDAO.updateRule(mfr);
            }
            UserActivity.log(session.getUserID(), "ADMIN_MAIL_FILTER_RULE_EDIT", Integer.toString(mfr.getId()), mfr.toString());
        } else {
            ServletContext sc = this.getServletContext();
            int maId = WebUtils.getInt(request, "ma_id");
            int mfId = WebUtils.getInt(request, "mf_id");
            int mfrId = WebUtils.getInt(request, "mfr_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ma_id", (Object)maId);
            sc.setAttribute("mf_id", (Object)mfId);
            sc.setAttribute("mfr", (Object)MailAccountDAO.findRuleByPk(mfrId));
            sc.setAttribute("fields", (Object)this.fields);
            sc.setAttribute("operations", (Object)this.operations);
            sc.getRequestDispatcher("/admin/mail_filter_rule_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("ruleEdit: void");
    }

    private void ruleDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("ruleDelete({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int mfrId = WebUtils.getInt(request, "mfr_id");
            MailAccountDAO.deleteRule(mfrId);
            UserActivity.log(session.getUserID(), "ADMIN_MAIL_FILTER_RULE_DELETE", Integer.toString(mfrId), null);
        } else {
            ServletContext sc = this.getServletContext();
            int maId = WebUtils.getInt(request, "ma_id");
            int mfId = WebUtils.getInt(request, "mf_id");
            int mfrId = WebUtils.getInt(request, "mfr_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ma_id", (Object)maId);
            sc.setAttribute("mf_id", (Object)mfId);
            sc.setAttribute("mfr", (Object)MailAccountDAO.findRuleByPk(mfrId));
            sc.setAttribute("fields", (Object)this.fields);
            sc.setAttribute("operations", (Object)this.operations);
            sc.getRequestDispatcher("/admin/mail_filter_rule_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("ruleDelete: void");
    }
}

