/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.core.DatabaseException;
import com.openkm.dao.LegacyDAO;
import com.openkm.dao.MimeTypeDAO;
import com.openkm.dao.bean.MimeType;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.WarUtils;
import com.openkm.util.WebUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(MimeTypeServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("create")) {
                this.create(session, request, response);
            } else if (action.equals("edit")) {
                this.edit(session, request, response);
            } else if (action.equals("delete")) {
                this.delete(session, request, response);
            } else if (action.equals("export")) {
                this.export(session, request, response);
            } else {
                this.list(session, request, response);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    /*
     * Exception decompiling
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void list(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("list({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        sc.setAttribute("mimeTypes", MimeTypeDAO.findAll("mt.name"));
        sc.getRequestDispatcher("/admin/mime_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("list: void");
    }

    private void delete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("delete({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        int mtId = WebUtils.getInt(request, "mt_id");
        MimeType mt = MimeTypeDAO.findByPk(mtId);
        String extensions = "";
        for (String ext : mt.getExtensions()) {
            extensions = extensions + ext + " ";
        }
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("extensions", (Object)extensions.trim());
        sc.setAttribute("mt", (Object)mt);
        sc.getRequestDispatcher("/admin/mime_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("delete: void");
    }

    private void create(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("create({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        MimeType mt = new MimeType();
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("extensions", null);
        sc.setAttribute("mt", (Object)mt);
        sc.getRequestDispatcher("/admin/mime_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("create: void");
    }

    private void edit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("edit({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        int mtId = WebUtils.getInt(request, "mt_id");
        MimeType mt = MimeTypeDAO.findByPk(mtId);
        String extensions = "";
        for (String ext : mt.getExtensions()) {
            extensions = extensions + ext + " ";
        }
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("extensions", (Object)extensions.trim());
        sc.setAttribute("mt", (Object)mt);
        sc.getRequestDispatcher("/admin/mime_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("edit: void");
    }

    private void export(Session session, HttpServletRequest request, HttpServletResponse response) throws DatabaseException, IOException {
        log.debug("export({}, {}, {})", new Object[]{session, request, response});
        response.setHeader("Expires", "Sat, 6 May 1971 12:00:00 GMT");
        response.setHeader("Cache-Control", "max-age=0, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        String fileName = "OpenKM_" + WarUtils.getAppVersion().getVersion() + "_MimeTypes.sql";
        response.setHeader("Content-disposition", "inline; filename=\"" + fileName + "\"");
        response.setContentType("text/x-sql; charset=UTF-8");
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF8"), true);
        out.println("DELETE FROM OKM_MIME_TYPE;");
        out.println("DELETE FROM OKM_MIME_TYPE_EXTENSION;");
        for (MimeType mimeType : MimeTypeDAO.findAll("mt.id")) {
            StringBuffer insertMime = new StringBuffer("INSERT INTO OKM_MIME_TYPE (MT_ID, MT_NAME, MT_IMAGE_CONTENT, MT_IMAGE_MIME) VALUES (");
            insertMime.append(mimeType.getId()).append(", '");
            insertMime.append(mimeType.getName()).append("', '");
            insertMime.append(mimeType.getImageContent()).append("', '");
            insertMime.append(mimeType.getImageMime()).append("');");
            out.println(insertMime);
            for (String ext : mimeType.getExtensions()) {
                StringBuffer insertExtension = new StringBuffer("INSERT INTO OKM_MIME_TYPE_EXTENSION (MTE_ID, MTE_NAME) VALUES (");
                insertExtension.append(mimeType.getId()).append(", '");
                insertExtension.append(ext).append("');");
                out.println(insertExtension);
            }
        }
        out.flush();
        log.debug("export: sql-file");
    }

    private void importMimeTypes(Session session, HttpServletRequest request, HttpServletResponse response, byte[] data, org.hibernate.classic.Session dbSession) throws DatabaseException, IOException, SQLException {
        String query;
        log.debug("import({}, {}, {}, {}, {})", new Object[]{session, request, response, data, dbSession});
        Connection con = dbSession.connection();
        Statement stmt = con.createStatement();
        InputStreamReader is = new InputStreamReader(new ByteArrayInputStream(data));
        BufferedReader br = new BufferedReader(is);
        while ((query = br.readLine()) != null) {
            stmt.executeUpdate(query);
        }
        LegacyDAO.close(stmt);
        LegacyDAO.close(con);
        log.debug("import: void");
    }
}

