/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.api.OKMPropertyGroup;
import com.openkm.bean.PropertyGroup;
import com.openkm.bean.form.FormElement;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.FormUtils;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyGroupsServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(PropertyGroupsServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String method = request.getMethod();
        if (this.checkMultipleInstancesAccess(request, response)) {
            if (method.equals("GET")) {
                this.doGet(request, response);
            } else if (method.equals("POST")) {
                this.doPost(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("register")) {
                this.register(session, request, response);
            }
            this.list(request, response);
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (com.openkm.core.ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (InvalidNodeTypeDefException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, com.openkm.core.ParseException, ParseException, javax.jcr.RepositoryException, InvalidNodeTypeDefException {
        log.debug("register({}, {}, {})", new Object[]{session, request, response});
        FormUtils.resetPropertyGroupsForms();
        FormUtils.parsePropertyGroupsForms(Config.PROPERTY_GROUPS_XML);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(Config.PROPERTY_GROUPS_CND);
            DirectRepositoryModule.registerCustomNodeTypes(session, fis);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        UserActivity.log(request.getRemoteUser(), "ADMIN_PROPERTY_GROUP_REGISTER", Config.PROPERTY_GROUPS_CND, null);
        log.debug("register: void");
    }

    private void list(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, com.openkm.core.ParseException, RepositoryException, DatabaseException {
        log.debug("list({}, {})", new Object[]{request, response});
        ServletContext sc = this.getServletContext();
        FormUtils.resetPropertyGroupsForms();
        OKMPropertyGroup okmPropGroups = OKMPropertyGroup.getInstance();
        List<PropertyGroup> groups = okmPropGroups.getAllGroups(null);
        LinkedHashMap pGroups = new LinkedHashMap();
        for (PropertyGroup group : groups) {
            List<FormElement> mData = okmPropGroups.getPropertyGroupForm(null, group.getName());
            ArrayList<Map<String, String>> fMaps = new ArrayList<Map<String, String>>();
            for (FormElement fe : mData) {
                fMaps.add(FormUtils.toString(fe));
            }
            pGroups.put(group, fMaps);
        }
        sc.setAttribute("pgCnd", (Object)JCRUtils.getName(Config.PROPERTY_GROUPS_CND));
        sc.setAttribute("pGroups", pGroups);
        sc.getRequestDispatcher("/admin/property_groups.jsp").forward((ServletRequest)request, (ServletResponse)response);
        UserActivity.log(request.getRemoteUser(), "ADMIN_PROPERTY_GROUP_LIST", null, null);
        log.debug("list: void");
    }
}

