/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.api.OKMWorkflow;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.WorkflowException;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.UserActivity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterWorkflowServlet
extends BaseServlet {
    private static Logger log = LoggerFactory.getLogger(RegisterWorkflowServlet.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileName = null;
        byte[] content = null;
        PrintWriter out = null;
        this.updateSessionManager(request);
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            out = response.getWriter();
            if (isMultipart) {
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                upload.setHeaderEncoding("UTF-8");
                List items = upload.parseRequest(request);
                for (FileItem item : items) {
                    if (item.isFormField()) continue;
                    fileName = item.getName();
                    content = item.get();
                }
                if (fileName != null && !fileName.equals("")) {
                    fileName = FilenameUtils.getName((String)fileName);
                    log.debug("Upload file: {}", (Object)fileName);
                    ByteArrayInputStream is = new ByteArrayInputStream(content);
                    OKMWorkflow.getInstance().registerProcessDefinition(null, is);
                    ((InputStream)is).close();
                }
                UserActivity.log(request.getRemoteUser(), "ADMIN_WORKFLOW_REGISTER", fileName, null);
                response.sendRedirect("Workflow");
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            out.flush();
            out.close();
        }
    }
}

