/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import bsh.EvalError;
import com.openkm.bean.form.FormElement;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.dao.ReportDAO;
import com.openkm.dao.bean.Report;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.FormUtils;
import com.openkm.util.ReportUtils;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ReportServlet.class);
    private static Map<String, String> types = new LinkedHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("create")) {
                ServletContext sc = this.getServletContext();
                Report rp = new Report();
                sc.setAttribute("action", (Object)action);
                sc.setAttribute("types", types);
                sc.setAttribute("rp", (Object)rp);
                sc.getRequestDispatcher("/admin/report_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else if (action.equals("edit")) {
                ServletContext sc = this.getServletContext();
                int rpId = WebUtils.getInt(request, "rp_id");
                Report rp = ReportDAO.findByPk(rpId);
                sc.setAttribute("action", (Object)action);
                sc.setAttribute("types", types);
                sc.setAttribute("rp", (Object)rp);
                sc.getRequestDispatcher("/admin/report_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else if (action.equals("delete")) {
                ServletContext sc = this.getServletContext();
                int rpId = WebUtils.getInt(request, "rp_id");
                Report rp = ReportDAO.findByPk(rpId);
                sc.setAttribute("action", (Object)action);
                sc.setAttribute("types", types);
                sc.setAttribute("rp", (Object)rp);
                sc.getRequestDispatcher("/admin/report_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else if (action.equals("paramList")) {
                this.paramList(session, request, response);
            } else if (action.equals("getParams")) {
                this.getParams(session, request, response);
            } else if (action.equals("execute")) {
                this.execute(session, request, response);
            } else {
                this.list(session, request, response);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (JRException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (EvalError e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    /*
     * Exception decompiling
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void list(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("list({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        List<Report> list = ReportDAO.findAll();
        sc.setAttribute("reports", list);
        sc.getRequestDispatcher("/admin/report_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("list: void");
    }

    private void getParams(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, ParseException {
        log.debug("getParams({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        int rpId = WebUtils.getInt(request, "rp_id");
        List<FormElement> params = ReportUtils.getReportParameters(rpId);
        sc.setAttribute("rp_id", (Object)rpId);
        sc.setAttribute("params", params);
        sc.setAttribute("ReportUtil", (Object)new ReportUtils());
        sc.getRequestDispatcher("/admin/report_get_params.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("getParams: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Session session, HttpServletRequest request, HttpServletResponse response) throws IOException, DatabaseException, JRException, EvalError, ParseException {
        log.debug("execute({}, {}, {})", new Object[]{session, request, response});
        int rpId = WebUtils.getInt(request, "rp_id");
        int format = WebUtils.getInt(request, "format", 2);
        Report rp = ReportDAO.findByPk(rpId);
        String fileName = rp.getFileName().substring(0, rp.getFileName().indexOf(46)) + ReportUtils.FILE_EXTENSION[format];
        HashMap<String, Object> params = new HashMap<String, Object>();
        String host = Config.APPLICATION_URL;
        params.put("host", host.substring(0, host.lastIndexOf("/") + 1));
        for (FormElement fe : ReportUtils.getReportParameters(rpId)) {
            params.put(fe.getName(), WebUtils.getString(request, fe.getName()));
        }
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        try {
            baos = ReportUtils.execute(rp, params, format);
            bais = new ByteArrayInputStream(baos.toByteArray());
            WebUtils.sendFile(request, response, fileName, ReportUtils.FILE_MIME[format], false, bais);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bais);
            IOUtils.closeQuietly((OutputStream)baos);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        IOUtils.closeQuietly((OutputStream)baos);
        UserActivity.log(request.getRemoteUser(), "ADMIN_REPORT_EXECUTE", Integer.toString(rpId), rp.toString());
        log.debug("execute: void");
    }

    private void paramList(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, ParseException {
        log.debug("paramList({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        int rpId = WebUtils.getInt(request, "rp_id");
        List<FormElement> params = ReportUtils.getReportParameters(rpId);
        ArrayList<Map<String, String>> fMaps = new ArrayList<Map<String, String>>();
        for (FormElement fe : params) {
            fMaps.add(FormUtils.toString(fe));
        }
        sc.setAttribute("rp_id", (Object)rpId);
        sc.setAttribute("params", fMaps);
        sc.getRequestDispatcher("/admin/report_param_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("paramList: void");
    }
}

