/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.core.DatabaseException;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositorySearchServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(RepositorySearchServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String method = request.getMethod();
        if (this.checkMultipleInstancesAccess(request, response)) {
            if (method.equals("GET")) {
                this.doGet(request, response);
            } else if (method.equals("POST")) {
                this.doPost(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String statement = WebUtils.getString(request, "statement");
        String type = WebUtils.getString(request, "type");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (!statement.equals("") && !type.equals("")) {
                this.search(session, statement, type, request, response);
                UserActivity.log(request.getRemoteUser(), "ADMIN_REPOSITORY_SEARCH", null, type + ", " + statement);
            } else {
                ServletContext sc = this.getServletContext();
                sc.setAttribute("statement", null);
                sc.setAttribute("type", null);
                sc.setAttribute("size", null);
                sc.setAttribute("columns", null);
                sc.setAttribute("results", null);
                sc.getRequestDispatcher("/admin/repository_search.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    private void search(Session session, String statement, String type, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, RepositoryException {
        log.debug("search({}, {}, {}, {}, {})", new Object[]{session, statement, type, request, response});
        ServletContext sc = this.getServletContext();
        Workspace workspace = session.getWorkspace();
        QueryManager queryManager = workspace.getQueryManager();
        Query query = queryManager.createQuery(statement, type);
        QueryResult result = query.execute();
        RowIterator it = result.getRows();
        String[] cols = result.getColumnNames();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList results = new ArrayList();
        for (int i = 0; i < cols.length; ++i) {
            columns.add(cols[i]);
        }
        while (it.hasNext()) {
            Row row = it.nextRow();
            ArrayList<String> tmp = new ArrayList<String>();
            for (int j = 0; j < cols.length; ++j) {
                if (cols[j].startsWith("jcr:")) {
                    tmp.add(row.getValue(cols[j]) != null ? row.getValue(cols[j]).getString() : "NULL");
                    continue;
                }
                String path = row.getValue("jcr:path").getString();
                Node node = session.getRootNode().getNode(path.substring(1));
                if (node.hasProperty(cols[j])) {
                    Property prop = node.getProperty(cols[j]);
                    if (prop == null) continue;
                    if (prop.getDefinition().isMultiple()) {
                        Value[] values = prop.getValues();
                        StringBuilder sb = new StringBuilder();
                        for (int k = 0; k < values.length; ++k) {
                            sb.append(values[k].getString() + " ");
                        }
                        tmp.add(sb.toString());
                        continue;
                    }
                    tmp.add(prop.getValue() != null ? prop.getValue().getString() : "NULL");
                    continue;
                }
                tmp.add("");
            }
            results.add(tmp);
        }
        sc.setAttribute("statement", (Object)statement);
        sc.setAttribute("type", (Object)type);
        sc.setAttribute("size", (Object)it.getSize());
        sc.setAttribute("columns", columns);
        sc.setAttribute("results", results);
        sc.getRequestDispatcher("/admin/repository_search.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("search: void");
    }
}

