/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.api.OKMFolder;
import com.openkm.api.OKMScripting;
import com.openkm.bean.ContentInfo;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.RepositoryException;
import com.openkm.dao.LockTokenDAO;
import com.openkm.extractor.RegisteredExtractors;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.FormatUtil;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.ItemVisitor;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.util.TraversingItemVisitor;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.NodeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryViewServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(RepositoryViewServlet.class);
    private static final String[] NODE_TYPE = new String[]{"UNDEFINED", "STRING", "BINARY", "LONG", "DOUBLE", "DATE", "BOOLEAN", "NAME", "PATH", "REFERENCE"};

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String method = request.getMethod();
        if (this.checkMultipleInstancesAccess(request, response)) {
            if (method.equals("GET")) {
                this.doGet(request, response);
            } else if (method.equals("POST")) {
                this.doPost(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        String path = WebUtils.getString(request, "path");
        String nodeUuid = WebUtils.getString(request, "nodeUuid");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("unlock")) {
                this.unlock(session, path, request, response);
            } else if (action.equals("forceUnlock")) {
                this.forceUnlock(session, nodeUuid, request, response);
            } else if (action.equals("checkin")) {
                this.checkin(session, path, request, response);
            } else if (action.equals("remove_content")) {
                this.removeContent(session, path, request, response);
            } else if (action.equals("remove_current")) {
                path = this.removeCurrent(session, path, request, response);
            } else if (action.equals("remove_mixin")) {
                this.removeMixin(session, path, request, response);
            } else if (action.equals("edit")) {
                this.edit(session, path, request, response);
            } else if (action.equals("set_script")) {
                OKMScripting.getInstance().setScript(null, path, Config.DEFAULT_SCRIPT);
            } else if (action.equals("remove_script")) {
                OKMScripting.getInstance().removeScript(null, path);
            } else if (action.equals("textExtraction")) {
                this.textExtraction(session, path, request, response);
            }
            if (!action.equals("edit")) {
                this.list(session, path, request, response);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (com.openkm.core.PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (AccessDeniedException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doPost({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        String path = WebUtils.getString(request, "path");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if ("save".equals(action)) {
                this.save(session, path, request, response);
                this.list(session, path, request, response);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    private void unlock(Session session, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException, DatabaseException {
        log.debug("unlock({}, {}, {}, {})", new Object[]{session, path, request, response});
        Node node = session.getRootNode().getNode(path.substring(1));
        Lock lock = node.getLock();
        String lt = JCRUtils.getLockToken(node.getUUID());
        if (lock.getLockOwner().equals(session.getUserID())) {
            JCRUtils.loadLockToken(session, node.getUUID());
            if (Arrays.asList(session.getLockTokens()).contains(lt)) {
                node.unlock();
                JCRUtils.removeLockToken(session, node);
            } else {
                try {
                    session.addLockToken(lt);
                    node.unlock();
                    LockTokenDAO.remove(lock.getLockOwner(), lt);
                }
                catch (LockException e) {
                    this.forceUnlockByExistingSession(path, lt);
                }
            }
        } else {
            try {
                session.addLockToken(lt);
                node.unlock();
                LockTokenDAO.remove(lock.getLockOwner(), lt);
            }
            catch (LockException e) {
                this.forceUnlockByExistingSession(path, lt);
            }
        }
        UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_UNLOCK", node.getUUID(), path);
        log.debug("unlock: void");
    }

    private void forceUnlock(Session session, String nodeUuid, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException, DatabaseException {
        log.debug("forceUnlock({}, {}, {}, {})", new Object[]{session, nodeUuid, request, response});
        Node node = session.getNodeByUUID(nodeUuid);
        String lockToken = JCRUtils.getLockToken(node.getUUID());
        boolean unlocked = false;
        for (String sessionToken : JcrSessionManager.getInstance().getTokens()) {
            Session tmpSession = JcrSessionManager.getInstance().get(sessionToken);
            try {
                node = tmpSession.getNodeByUUID(nodeUuid);
            }
            catch (Exception e) {
                continue;
            }
            Lock lock = node.getLock();
            try {
                node.unlock();
                LockTokenDAO.remove(lock.getLockOwner(), lockToken);
                unlocked = true;
                break;
            }
            catch (LockException e) {
            }
        }
        if (unlocked) {
            UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_UNLOCK", nodeUuid, "force");
            log.debug("forceUnlock: void");
        } else {
            this.unlock(session, node.getPath(), request, response);
        }
    }

    private void forceUnlockByExistingSession(String path, String lockToken) throws PathNotFoundException, javax.jcr.RepositoryException, DatabaseException {
        log.debug("forceUnlockByExistingSession()");
        for (String token : JcrSessionManager.getInstance().getTokens()) {
            try {
                Session session = JcrSessionManager.getInstance().get(token);
                Node node = session.getRootNode().getNode(path.substring(1));
                List<String> lockTokens = Arrays.asList(session.getLockTokens());
                if (!lockTokens.contains(lockToken)) continue;
                Lock lock = node.getLock();
                node.unlock();
                LockTokenDAO.remove(lock.getLockOwner(), lockToken);
                log.debug("forceUnlockByExistingSession:void");
                return;
            }
            catch (LockException e) {
            }
        }
        throw new LockException("There is no session that can unlock node");
    }

    private void checkin(Session session, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException {
        log.debug("checkin({}, {}, {}, {})", new Object[]{session, path, request, response});
        Node node = session.getRootNode().getNode(path.substring(1));
        node.checkin();
        UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_CHECKIN", node.getUUID(), path);
        log.debug("checkin: void");
    }

    private void removeContent(Session session, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException {
        log.debug("removeCurrent({}, {}, {}, {})", new Object[]{session, path, request, response});
        Node node = session.getRootNode().getNode(path.substring(1));
        NodeIterator ni = node.getNodes();
        while (ni.hasNext()) {
            Node child = ni.nextNode();
            child.remove();
            node.save();
        }
        UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_REMOVE_CONTENT", node.getUUID(), path);
        log.debug("removeCurrent: void");
    }

    private String removeCurrent(Session session, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException {
        log.debug("removeCurrent({}, {}, {}, {})", new Object[]{session, path, request, response});
        Node node = session.getRootNode().getNode(path.substring(1));
        String uuid = node.getUUID();
        Node parent = node.getParent();
        String parentPath = parent.getPath();
        node.remove();
        parent.save();
        UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_REMOVE_CURRENT", uuid, path);
        log.debug("removeCurrent: {}", (Object)path);
        return parentPath;
    }

    private void removeMixin(Session session, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException {
        log.debug("removeMixin({}, {}, {}, {})", new Object[]{session, path, request, response});
        Node node = session.getRootNode().getNode(path.substring(1));
        String mixin = WebUtils.getString(request, "mixin");
        node.removeMixin(mixin);
        node.save();
        UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_REMOVE_MIXIN", node.getUUID(), mixin + ", " + path);
        log.debug("removeMixin: {}", (Object)path);
    }

    private void edit(Session session, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException {
        String value;
        log.debug("edit({}, {}, {}, {})", new Object[]{session, path, request, response});
        String property = WebUtils.getString(request, "property");
        ServletContext sc = this.getServletContext();
        Node node = session.getRootNode().getNode(path.substring(1));
        Property prop = node.getProperty(property);
        boolean multiple = false;
        if (prop.getDefinition().isMultiple()) {
            value = this.toString(prop.getValues(), "\n");
            multiple = true;
        } else {
            value = prop.getValue().getString();
        }
        UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_EDIT", node.getUUID(), property + ", " + value + ", " + path);
        sc.setAttribute("node", (Object)node);
        sc.setAttribute("property", (Object)prop);
        sc.setAttribute("multiple", (Object)(multiple || prop.getName().equals("okm:scriptCode") ? 1 : 0));
        sc.setAttribute("value", (Object)value);
        sc.getRequestDispatcher("/admin/repository_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("edit: void");
    }

    private void save(Session session, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException {
        log.debug("save({}, {}, {}, {})", new Object[]{session, path, request, response});
        String value = WebUtils.getString(request, "value");
        String property = WebUtils.getString(request, "property");
        Node node = session.getRootNode().getNode(path.substring(1));
        Property prop = node.getProperty(property);
        ValueFactory vf = session.getValueFactory();
        if (prop.getDefinition().isMultiple()) {
            StringTokenizer st = new StringTokenizer(value, "\n");
            Value[] values = new Value[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                values[i] = vf.createValue(st.nextToken().trim());
                ++i;
            }
            node.setProperty(property, values);
        } else {
            node.setProperty(property, value);
        }
        node.save();
        UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_SAVE", node.getUUID(), property + ", " + value + ", " + path);
        log.debug("save: void");
    }

    private void textExtraction(Session session, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException {
        log.debug("textExtraction({}, {}, {}, {})", new Object[]{session, path, request, response});
        TraversingItemVisitor.Default tiv = new TraversingItemVisitor.Default(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void entering(Node node, int level) throws javax.jcr.RepositoryException {
                if (node.isNodeType("okm:resource")) {
                    Node docNode = node.getParent();
                    log.info("Document: {}", (Object)docNode.getPath());
                    String mimeType = node.getProperty("jcr:mimeType").getString();
                    if (!node.isLocked()) {
                        try {
                            node.checkout();
                            RegisteredExtractors.index(docNode, node, mimeType);
                            node.setProperty("okm:versionComment", "Text extraction");
                            node.save();
                        }
                        catch (IOException e) {
                            log.error("Error when extracting text: {}", (Object)e.getMessage());
                        }
                        finally {
                            if (node.isCheckedOut()) {
                                node.checkin();
                            }
                        }
                    }
                }
            }
        };
        Node node = session.getRootNode().getNode(path.substring(1));
        session.getItem(node.getPath()).accept((ItemVisitor)tiv);
        UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_TEXT_EXTRACTION", node.getUUID(), null);
        log.debug("textExtraction: void");
    }

    private void list(Session session, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, PathNotFoundException, javax.jcr.RepositoryException {
        log.debug("list({}, {}, {}, {})", new Object[]{session, path, request, response});
        String stats = WebUtils.getString(request, "stats");
        String uuid = WebUtils.getString(request, "uuid");
        ServletContext sc = this.getServletContext();
        ContentInfo ci = null;
        Node node = null;
        if (!stats.equals("")) {
            if (stats.equals("0")) {
                request.getSession().removeAttribute("stats");
            } else {
                request.getSession().setAttribute("stats", (Object)true);
            }
        }
        if (!path.equals("")) {
            node = path.equals("/") ? session.getRootNode() : session.getRootNode().getNode(path.substring(1));
        } else if (!uuid.equals("")) {
            node = session.getNodeByUUID(uuid);
            path = node.getPath();
        } else {
            node = session.getRootNode();
        }
        if (request.getSession().getAttribute("stats") != null && node.isNodeType("okm:folder")) {
            try {
                ci = OKMFolder.getInstance().getContentInfo(null, node.getPath());
            }
            catch (AccessDeniedException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            catch (com.openkm.core.PathNotFoundException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            catch (DatabaseException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (node.isNodeType("mix:referenceable")) {
            UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_LIST", node.getUUID(), node.getPath());
        } else {
            UserActivity.log(session.getUserID(), "ADMIN_REPOSITORY_LIST", ((NodeImpl)node).getId().toString(), node.getPath());
        }
        sc.setAttribute("contentInfo", (Object)ci);
        sc.setAttribute("node", (Object)node);
        sc.setAttribute("isFolder", (Object)node.isNodeType("okm:folder"));
        sc.setAttribute("isDocument", (Object)node.isNodeType("okm:document"));
        sc.setAttribute("isDocumentContent", (Object)node.isNodeType("okm:resource"));
        sc.setAttribute("isScripting", (Object)node.isNodeType("mix:scripting"));
        sc.setAttribute("holdsLock", (Object)node.holdsLock());
        sc.setAttribute("breadcrumb", (Object)this.createBreadcrumb(node.getPath()));
        sc.setAttribute("properties", this.getProperties(node));
        sc.setAttribute("children", this.getChildren(node));
        sc.getRequestDispatcher("/admin/repository_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("list: void");
    }

    private String createBreadcrumb(String path) throws UnsupportedEncodingException {
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            String name = path.substring(idx + 1);
            String parent = path.substring(0, idx);
            return this.createBreadcrumb(parent) + " / <a href=\"RepositoryView?path=" + URLEncoder.encode(path, "UTF-8") + "\">" + name + "</a>";
        }
        if (!path.substring(1).equals("")) {
            return "<a href=\"RepositoryView?path=\">ROOT</a> / <a href=\"RepositoryView?path=" + URLEncoder.encode(path, "UTF-8") + "\">" + path.substring(1) + "</a>";
        }
        return "<a href=\"RepositoryView?path=\">ROOT</a> /";
    }

    private Collection<Map<String, Object>> getChildren(Node node) throws javax.jcr.RepositoryException {
        ArrayList<Map<String, Object>> al = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        NodeIterator ni = node.getNodes();
        while (ni.hasNext()) {
            Node child = ni.nextNode();
            hm = new HashMap();
            if (child.isNodeType("okm:document")) {
                Node contentNode = child.getNode("okm:content");
                contentNode.isCheckedOut();
                hm.put("checkedOut", contentNode.isCheckedOut());
            } else if (child.isNodeType("okm:resource")) {
                hm.put("checkedOut", child.isCheckedOut());
            }
            hm.put("name", child.getName());
            hm.put("path", child.getPath());
            hm.put("locked", child.isLocked());
            hm.put("locked", child.isLocked());
            hm.put("primaryNodeType", child.getPrimaryNodeType().getName());
            hm.put("isFolder", child.isNodeType("okm:folder"));
            hm.put("isDocument", child.isNodeType("okm:document"));
            hm.put("isDocumentContent", child.isNodeType("okm:resource"));
            al.add(hm);
        }
        Collections.sort(al, new ChildCmp());
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<HashMap<String, String>> getProperties(Node node) throws ValueFormatException, javax.jcr.RepositoryException {
        ArrayList<HashMap<String, String>> al = new ArrayList<HashMap<String, String>>();
        PropertyIterator pi = node.getProperties();
        while (pi.hasNext()) {
            HashMap<String, String> hm = new HashMap<String, String>();
            Property p = pi.nextProperty();
            PropertyDefinition pd = p.getDefinition();
            hm.put("pName", p.getName());
            hm.put("pProtected", Boolean.toString(pd.isProtected()));
            hm.put("pMultiple", Boolean.toString(pd.isMultiple()));
            hm.put("pType", NODE_TYPE[pd.getRequiredType()]);
            if (pd.getRequiredType() == 2) {
                InputStream is = p.getStream();
                try {
                    hm.put("pValue", "DATA: " + FormatUtil.formatSize(is.available()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            } else if (pd.isMultiple()) {
                hm.put("pValue", this.toString(p.getValues(), "<br/>"));
            } else if (p.getName().equals("okm:scriptCode")) {
                hm.put("pValue", p.getString());
            } else {
                hm.put("pValue", p.getString());
            }
            al.add(hm);
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("pName", "jcr:aid");
        hm.put("pProtected", Boolean.toString(true));
        hm.put("pMultiple", Boolean.toString(false));
        hm.put("pType", "VIRTUAL");
        hm.put("pValue", ((NodeImpl)node).getId().toString());
        al.add(hm);
        Collections.sort(al, new PropertyCmp());
        return al;
    }

    private String toString(Value[] v, String delim) throws ValueFormatException, IllegalStateException, javax.jcr.RepositoryException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v.length - 1; ++i) {
            sb.append(v[i].getString());
            sb.append(delim);
        }
        if (v.length > 0) {
            sb.append(v[v.length - 1].getString());
        }
        return sb.toString();
    }

    protected class PropertyCmp
    implements Comparator<HashMap<String, String>> {
        protected PropertyCmp() {
        }

        @Override
        public int compare(HashMap<String, String> arg0, HashMap<String, String> arg1) {
            return arg0.get("pName").compareTo(arg1.get("pName"));
        }
    }

    protected class ChildCmp
    implements Comparator<Map<String, Object>> {
        protected ChildCmp() {
        }

        @Override
        public int compare(Map<String, Object> arg0, Map<String, Object> arg1) {
            return ((String)arg0.get("name")).compareTo((String)arg1.get("name"));
        }
    }
}

