/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import bsh.EvalError;
import com.lowagie.text.DocumentException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.AuthDAO;
import com.openkm.extension.dao.StampImageDAO;
import com.openkm.extension.dao.StampTextDAO;
import com.openkm.extension.dao.bean.StampImage;
import com.openkm.extension.dao.bean.StampText;
import com.openkm.jcr.JCRUtils;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.PDFUtils;
import com.openkm.util.SecureStore;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StampServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(StampServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("textCreate")) {
                this.textCreate(session, request, response);
            } else if (action.equals("imageCreate")) {
                this.imageCreate(session, request, response);
            } else if (action.equals("textEdit")) {
                this.textEdit(session, request, response);
            } else if (action.equals("imageEdit")) {
                this.imageEdit(session, request, response);
            } else if (action.equals("textDelete")) {
                this.textDelete(session, request, response);
            } else if (action.equals("textColor")) {
                this.textColor(session, request, response);
            } else if (action.equals("textTest")) {
                this.textTest(session, request, response);
            } else if (action.equals("imageDelete")) {
                this.imageDelete(session, request, response);
            } else if (action.equals("textActive")) {
                this.textActive(session, request, response);
            } else if (action.equals("imageActive")) {
                this.imageActive(session, request, response);
            } else if (action.equals("imageView")) {
                this.imageView(session, request, response);
            } else if (action.equals("imageTest")) {
                this.imageTest(session, request, response);
            }
            if (action.equals("") || action.equals("textList") || action.equals("textActive") || action.startsWith("text") && WebUtils.getBoolean(request, "persist")) {
                this.textList(session, request, response);
            } else if (action.equals("imageList") || action.equals("imageActive")) {
                this.imageList(session, request, response);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DocumentException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (EvalError e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    /*
     * Exception decompiling
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void textCreate(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("textCreate({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            StampText st = new StampText();
            st.setName(WebUtils.getString(request, "st_name"));
            st.setDescription(WebUtils.getString(request, "st_description"));
            st.setText(WebUtils.getString(request, "st_text"));
            st.setLayer(WebUtils.getInt(request, "st_layer"));
            st.setOpacity(WebUtils.getFloat(request, "st_opacity"));
            st.setSize(WebUtils.getInt(request, "st_size"));
            st.setColor(WebUtils.getString(request, "st_color"));
            st.setAlign(WebUtils.getInt(request, "st_align"));
            st.setRotation(WebUtils.getInt(request, "st_rotation"));
            st.setExprX(WebUtils.getString(request, "st_expr_x"));
            st.setExprY(WebUtils.getString(request, "st_expr_y"));
            st.setActive(WebUtils.getBoolean(request, "st_active"));
            st.setUsers(new HashSet<String>(WebUtils.getStringList(request, "st_users")));
            int id = StampTextDAO.create(st);
            UserActivity.log(session.getUserID(), "ADMIN_STAMP_TEXT_CREATE", Integer.toString(id), st.toString());
        } else {
            ServletContext sc = this.getServletContext();
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("users", AuthDAO.findAllUsers(true));
            sc.setAttribute("stamp", (Object)new StampText());
            sc.getRequestDispatcher("/admin/stamp_text_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("textCreate: void");
    }

    private void textEdit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("textEdit({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            StampText st = new StampText();
            st.setId(WebUtils.getInt(request, "st_id"));
            st.setName(WebUtils.getString(request, "st_name"));
            st.setDescription(WebUtils.getString(request, "st_description"));
            st.setText(WebUtils.getString(request, "st_text"));
            st.setLayer(WebUtils.getInt(request, "st_layer"));
            st.setOpacity(WebUtils.getFloat(request, "st_opacity"));
            st.setSize(WebUtils.getInt(request, "st_size"));
            st.setColor(WebUtils.getString(request, "st_color"));
            st.setAlign(WebUtils.getInt(request, "st_align"));
            st.setRotation(WebUtils.getInt(request, "st_rotation"));
            st.setExprX(WebUtils.getString(request, "st_expr_x"));
            st.setExprY(WebUtils.getString(request, "st_expr_y"));
            st.setActive(WebUtils.getBoolean(request, "st_active"));
            st.setUsers(new HashSet<String>(WebUtils.getStringList(request, "st_users")));
            StampTextDAO.update(st);
            UserActivity.log(session.getUserID(), "ADMIN_STAMP_TEXT_EDIT", Integer.toString(st.getId()), st.toString());
        } else {
            ServletContext sc = this.getServletContext();
            int stId = WebUtils.getInt(request, "st_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("users", AuthDAO.findAllUsers(true));
            sc.setAttribute("stamp", (Object)StampTextDAO.findByPk(stId));
            sc.getRequestDispatcher("/admin/stamp_text_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("textEdit: void");
    }

    private void textDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("textDelete({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int stId = WebUtils.getInt(request, "st_id");
            StampTextDAO.delete(stId);
            UserActivity.log(session.getUserID(), "ADMIN_STAMP_TEXT_DELETE", Integer.toString(stId), null);
        } else {
            ServletContext sc = this.getServletContext();
            int stId = WebUtils.getInt(request, "st_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("users", AuthDAO.findAllUsers(true));
            sc.setAttribute("stamp", (Object)StampTextDAO.findByPk(stId));
            sc.getRequestDispatcher("/admin/stamp_text_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("textDelete: void");
    }

    private void textActive(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("textActive({}, {}, {})", new Object[]{session, request, response});
        int stId = WebUtils.getInt(request, "st_id");
        boolean active = WebUtils.getBoolean(request, "st_active");
        StampTextDAO.active(stId, active);
        UserActivity.log(session.getUserID(), "ADMIN_STAMP_TEXT_ACTIVE", Integer.toString(stId), Boolean.toString(active));
        log.debug("textActive: void");
    }

    private void textList(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, PrincipalAdapterException {
        log.debug("textList({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        sc.setAttribute("stamps", StampTextDAO.findAll());
        sc.getRequestDispatcher("/admin/stamp_text_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("textList: void");
    }

    private void textColor(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("textColor({}, {}, {})", new Object[]{session, request, response});
        int stId = WebUtils.getInt(request, "st_id");
        StampText st = StampTextDAO.findByPk(stId);
        BufferedImage bi = new BufferedImage(16, 16, 1);
        Graphics g = bi.getGraphics();
        g.setColor(Color.decode(st.getColor()));
        g.fillRect(0, 0, 16, 16);
        response.setContentType("image/jpeg");
        ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)response.getOutputStream());
        log.debug("textColor: void");
    }

    private void textTest(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, DocumentException, EvalError {
        log.debug("textTest({}, {}, {})", new Object[]{session, request, response});
        int stId = WebUtils.getInt(request, "st_id");
        StampText st = StampTextDAO.findByPk(stId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PDFUtils.generateSample(5, baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        baos = new ByteArrayOutputStream();
        PDFUtils.stampText(bais, st.getText(), st.getLayer(), st.getOpacity(), st.getSize(), Color.decode(st.getColor()), st.getRotation(), st.getAlign(), st.getExprX(), st.getExprY(), baos);
        bais = new ByteArrayInputStream(baos.toByteArray());
        WebUtils.sendFile(request, response, "sample.pdf", Config.MIME_PDF, true, bais);
        log.debug("textTest: void");
    }

    private void imageCreate(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("imageCreate({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("users", AuthDAO.findAllUsers(true));
        sc.setAttribute("stamp", (Object)new StampImage());
        sc.getRequestDispatcher("/admin/stamp_image_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("imageCreate: void");
    }

    private void imageEdit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("imageEdit({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        int siId = WebUtils.getInt(request, "si_id");
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("users", AuthDAO.findAllUsers(true));
        sc.setAttribute("stamp", (Object)StampImageDAO.findByPk(siId));
        sc.getRequestDispatcher("/admin/stamp_image_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("imageEdit: void");
    }

    private void imageDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("imageDelete({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        int siId = WebUtils.getInt(request, "si_id");
        sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
        sc.setAttribute("persist", (Object)true);
        sc.setAttribute("users", AuthDAO.findAllUsers(true));
        sc.setAttribute("stamp", (Object)StampImageDAO.findByPk(siId));
        sc.getRequestDispatcher("/admin/stamp_image_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("imageDelete: void");
    }

    private void imageActive(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("imageActive({}, {}, {})", new Object[]{session, request, response});
        int siId = WebUtils.getInt(request, "si_id");
        boolean active = WebUtils.getBoolean(request, "si_active");
        StampImageDAO.active(siId, active);
        UserActivity.log(session.getUserID(), "ADMIN_STAMP_IMAGE_ACTIVE", Integer.toString(siId), Boolean.toString(active));
        log.debug("imageActive: void");
    }

    private void imageList(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("imageList({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        sc.setAttribute("stamps", StampImageDAO.findAll());
        sc.getRequestDispatcher("/admin/stamp_image_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("imageList: void");
    }

    private void imageView(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("imageView({}, {}, {})", new Object[]{session, request, response});
        int siId = WebUtils.getInt(request, "si_id");
        StampImage si = StampImageDAO.findByPk(siId);
        response.setContentType(si.getImageMime());
        ServletOutputStream sos = response.getOutputStream();
        sos.write(SecureStore.b64Decode(si.getImageContent()));
        sos.flush();
        sos.close();
        log.debug("imageView: void");
    }

    private void imageTest(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, DocumentException, EvalError {
        log.debug("imageTest({}, {}, {})", new Object[]{session, request, response});
        int siId = WebUtils.getInt(request, "si_id");
        StampImage si = StampImageDAO.findByPk(siId);
        byte[] image = SecureStore.b64Decode(si.getImageContent());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PDFUtils.generateSample(5, baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        baos = new ByteArrayOutputStream();
        PDFUtils.stampImage(bais, image, si.getLayer(), si.getOpacity(), si.getExprX(), si.getExprY(), baos);
        bais = new ByteArrayInputStream(baos.toByteArray());
        WebUtils.sendFile(request, response, "sample.pdf", Config.MIME_PDF, true, bais);
        log.debug("imageTest: void");
    }
}

