/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.bean.StatsInfo;
import com.openkm.core.Config;
import com.openkm.core.RepositoryInfo;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.FormatUtil;
import com.openkm.util.WebUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.ColumnArrangement;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsGraphServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(StatsGraphServlet.class);
    private static final String DOCUMENTS = "0";
    private static final String DOCUMENTS_SIZE = "1";
    private static final String FOLDERS = "2";
    private static final String MEMORY = "3";
    private static final String DISK = "4";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String type = WebUtils.getString(request, "t");
        JFreeChart chart = null;
        this.updateSessionManager(request);
        try {
            response.setContentType("image/png");
            ServletOutputStream out = response.getOutputStream();
            if (DOCUMENTS.equals(type) || DOCUMENTS_SIZE.equals(type) || FOLDERS.equals(type)) {
                chart = this.repoStats(type);
            } else if (DISK.equals(type)) {
                chart = this.diskStats();
            } else if (MEMORY.equals(type)) {
                chart = this.memStats();
            }
            if (chart != null) {
                chart.getTitle().setFont(new Font("Tahoma", 1, 16));
                chart.setBackgroundPaint((Paint)new Color(246, 246, 238));
                PiePlot plot = (PiePlot)chart.getPlot();
                plot.setNoDataMessage("No data to display");
                plot.setLabelGenerator(null);
                LegendTitle legend = new LegendTitle((LegendItemSource)plot, (Arrangement)new ColumnArrangement(), (Arrangement)new ColumnArrangement());
                legend.setPosition(RectangleEdge.BOTTOM);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setItemFont(new Font("Tahoma", 0, 12));
                chart.removeLegend();
                chart.addLegend(legend);
                if (DISK.equals(type) || MEMORY.equals(type)) {
                    ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)225, (int)225);
                } else {
                    ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)250, (int)250);
                }
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JFreeChart diskStats() throws IOException, ServletException {
        String title = "Disk usage";
        String repHome = null;
        repHome = new File(Config.REPOSITORY_HOME).isAbsolute() ? Config.REPOSITORY_HOME : Config.HOME_DIR + File.separator + Config.REPOSITORY_HOME;
        File df = new File(repHome);
        long total = df.getTotalSpace();
        long usable = df.getUsableSpace();
        long used = total - usable;
        log.debug("Total space: {}", (Object)FormatUtil.formatSize(total));
        log.debug("Usable space: {}", (Object)FormatUtil.formatSize(usable));
        log.debug("Used space: {}", (Object)FormatUtil.formatSize(used));
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)("Available (" + FormatUtil.formatSize(usable) + ")")), (double)(usable * 100L / total));
        dataset.setValue((Comparable)((Object)("Used (" + FormatUtil.formatSize(used) + ")")), (double)(used * 100L / total));
        return ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
    }

    public JFreeChart memStats() throws IOException, ServletException {
        String title = "Memory usage";
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long available = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = max - available;
        long total = free + used;
        log.debug("Maximun memory: {}", (Object)FormatUtil.formatSize(max));
        log.debug("Available memory: {}", (Object)FormatUtil.formatSize(available));
        log.debug("Free memory: {}", (Object)FormatUtil.formatSize(free));
        log.debug("Used memory: {}", (Object)FormatUtil.formatSize(used));
        log.debug("Total memory: {}", (Object)FormatUtil.formatSize(total));
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)("Available (" + FormatUtil.formatSize(free) + ")")), (double)(free * 100L / total));
        dataset.setValue((Comparable)((Object)("Used (" + FormatUtil.formatSize(used) + ")")), (double)(used * 100L / total));
        return ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
    }

    public JFreeChart repoStats(String type) throws IOException, ServletException {
        String title = null;
        long[] sizes = null;
        double[] percents = null;
        DefaultPieDataset dataset = new DefaultPieDataset();
        if (DOCUMENTS.equals(type)) {
            StatsInfo si = RepositoryInfo.getDocumentsByContext();
            percents = si.getPercents();
            sizes = si.getSizes();
            title = "Documents by context";
        } else if (DOCUMENTS_SIZE.equals(type)) {
            StatsInfo si = RepositoryInfo.getDocumentsSizeByContext();
            percents = si.getPercents();
            sizes = si.getSizes();
            title = "Documents size by context";
        } else if (FOLDERS.equals(type)) {
            StatsInfo si = RepositoryInfo.getFoldersByContext();
            percents = si.getPercents();
            sizes = si.getSizes();
            title = "Folders by context";
        }
        if (title != null && sizes.length > 0 && percents.length > 0) {
            dataset.setValue((Comparable)((Object)("Taxonomy (" + FormatUtil.formatSize(sizes[0]) + ")")), percents[0]);
            dataset.setValue((Comparable)((Object)("Personal (" + FormatUtil.formatSize(sizes[1]) + ")")), percents[1]);
            dataset.setValue((Comparable)((Object)("Template (" + FormatUtil.formatSize(sizes[2]) + ")")), percents[2]);
            dataset.setValue((Comparable)((Object)("Trash (" + FormatUtil.formatSize(sizes[3]) + ")")), percents[3]);
        }
        return ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
    }

    public String repoStatsXML(String title, DefaultPieDataset dataset) throws IOException, ServletException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("RepoStats");
        root.addElement("Title").addCDATA(title);
        Element dataSetElement = root.addElement("DataSet");
        for (int i = 0; i < dataset.getItemCount(); ++i) {
            Element itemElement = dataSetElement.addElement("Item");
            itemElement.addElement("name").addCDATA(dataset.getKey(i).toString());
            itemElement.addAttribute("percent", dataset.getValue(i).toString());
            dataSetElement.add(itemElement);
        }
        return document.asXML();
    }
}

