/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.core.DatabaseException;
import com.openkm.dao.TwitterAccountDAO;
import com.openkm.dao.bean.TwitterAccount;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterAccountServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(TwitterAccountServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("create")) {
                this.create(session, request, response);
            } else if (action.equals("edit")) {
                this.edit(session, request, response);
            } else if (action.equals("delete")) {
                this.delete(session, request, response);
            }
            if (action.equals("") || WebUtils.getBoolean(request, "persist")) {
                this.list(session, request, response);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    private void create(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.info("create({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            TwitterAccount ta = new TwitterAccount();
            ta.setUser(WebUtils.getString(request, "ta_user"));
            ta.setTwitterUser(WebUtils.getString(request, "ta_tuser"));
            ta.setActive(WebUtils.getBoolean(request, "ta_active"));
            TwitterAccountDAO.create(ta);
            UserActivity.log(session.getUserID(), "ADMIN_TWITTER_ACCOUNT_CREATE", ta.getUser(), ta.toString());
        } else {
            ServletContext sc = this.getServletContext();
            TwitterAccount ta = new TwitterAccount();
            ta.setUser(WebUtils.getString(request, "ta_user"));
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ta", (Object)ta);
            sc.getRequestDispatcher("/admin/twitter_account_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("create: void");
    }

    private void edit(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("edit({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            TwitterAccount ta = new TwitterAccount();
            ta.setId(WebUtils.getInt(request, "ta_id"));
            ta.setUser(WebUtils.getString(request, "ta_user"));
            ta.setTwitterUser(WebUtils.getString(request, "ta_tuser"));
            ta.setActive(WebUtils.getBoolean(request, "ta_active"));
            TwitterAccountDAO.update(ta);
            UserActivity.log(session.getUserID(), "ADMIN_TWITTER_ACCOUNT_EDIT", Integer.toString(ta.getId()), ta.toString());
        } else {
            ServletContext sc = this.getServletContext();
            int taId = WebUtils.getInt(request, "ta_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ta", (Object)TwitterAccountDAO.findByPk(taId));
            sc.getRequestDispatcher("/admin/twitter_account_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("edit: void");
    }

    private void delete(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException, NoSuchAlgorithmException {
        log.debug("delete({}, {}, {})", new Object[]{session, request, response});
        if (WebUtils.getBoolean(request, "persist")) {
            int taId = WebUtils.getInt(request, "ta_id");
            TwitterAccountDAO.delete(taId);
            UserActivity.log(session.getUserID(), "ADMIN_TWITTER_ACCOUNT_DELETE", Integer.toString(taId), null);
        } else {
            ServletContext sc = this.getServletContext();
            int taId = WebUtils.getInt(request, "ta_id");
            sc.setAttribute("action", (Object)WebUtils.getString(request, "action"));
            sc.setAttribute("persist", (Object)true);
            sc.setAttribute("ta", (Object)TwitterAccountDAO.findByPk(taId));
            sc.getRequestDispatcher("/admin/twitter_account_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        log.debug("delete: void");
    }

    private void list(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, DatabaseException {
        log.debug("list({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        String usrId = WebUtils.getString(request, "ta_user");
        sc.setAttribute("ta_user", (Object)usrId);
        sc.setAttribute("twitterAccounts", TwitterAccountDAO.findByUser(usrId, false));
        sc.getRequestDispatcher("/admin/twitter_account_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("list: void");
    }
}

