/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.core.DatabaseException;
import com.openkm.dao.ProfileDAO;
import com.openkm.dao.UserConfigDAO;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.IOException;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserConfigServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(UserConfigServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (WebUtils.getBoolean(request, "persist")) {
                ServletContext sc = this.getServletContext();
                String ucUser = WebUtils.getString(request, "uc_user");
                int upId = WebUtils.getInt(request, "uc_profile");
                UserConfigDAO.updateProfile(ucUser, upId);
                sc.getRequestDispatcher("/admin/Auth").forward((ServletRequest)request, (ServletResponse)response);
                UserActivity.log(session.getUserID(), "ADMIN_USER_CONFIG_EDIT", ucUser, Integer.toString(upId));
            } else {
                ServletContext sc = this.getServletContext();
                String ucUser = WebUtils.getString(request, "uc_user");
                sc.setAttribute("persist", (Object)true);
                sc.setAttribute("profiles", ProfileDAO.findAll(true));
                sc.setAttribute("uc", (Object)UserConfigDAO.findByPk(session, ucUser));
                sc.getRequestDispatcher("/admin/user_config_edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }
}

