/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.admin;

import com.openkm.api.OKMAuth;
import com.openkm.api.OKMDocument;
import com.openkm.api.OKMWorkflow;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.workflow.ProcessInstance;
import com.openkm.bean.workflow.TaskInstance;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.RepositoryException;
import com.openkm.core.WorkflowException;
import com.openkm.jcr.JCRUtils;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.servlet.admin.BaseServlet;
import com.openkm.util.FormUtils;
import com.openkm.util.FormatUtil;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(WorkflowServlet.class);
    private static Map<String, String> statusFilterValues = new LinkedHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        Session session = null;
        this.updateSessionManager(request);
        try {
            session = JCRUtils.getSession();
            if (action.equals("processDefinitionDelete")) {
                this.processDefinitionDelete(session, request, response);
                this.processDefinitionList(session, request, response);
            } else if (action.equals("processDefinitionView")) {
                this.processDefinitionView(session, request, response);
            } else if (action.equals("processInstanceView")) {
                this.processInstanceView(session, request, response);
            } else if (action.equals("processInstanceDelete")) {
                this.processInstanceDelete(session, request, response);
                this.processDefinitionView(session, request, response);
            } else if (action.equals("processInstanceEnd")) {
                this.processInstanceEnd(session, request, response);
                this.processDefinitionView(session, request, response);
            } else if (action.equals("processInstanceResume")) {
                this.processInstanceResume(session, request, response);
                this.processDefinitionView(session, request, response);
            } else if (action.equals("processInstanceSuspend")) {
                this.processInstanceSuspend(session, request, response);
                this.processDefinitionView(session, request, response);
            } else if (action.equals("processInstanceVariableDelete")) {
                this.processInstanceVariableDelete(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("processInstanceVariableAdd")) {
                this.processInstanceVariableAdd(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("taskInstanceSetActor")) {
                this.taskInstanceSetActor(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("taskInstanceSuspend")) {
                this.taskInstanceSuspend(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("taskInstanceResume")) {
                this.taskInstanceResume(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("taskInstanceStart")) {
                this.taskInstanceStart(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("taskInstanceEnd")) {
                this.taskInstanceEnd(session, request, response);
                if (request.getParameter("transition") == null) {
                    this.processInstanceView(session, request, response);
                } else {
                    this.taskInstanceView(session, request, response);
                }
            } else if (action.equals("taskInstanceView")) {
                this.taskInstanceView(session, request, response);
            } else if (action.equals("taskInstanceAddComment")) {
                this.taskInstanceAddComment(session, request, response);
                this.taskInstanceView(session, request, response);
            } else if (action.equals("taskInstanceVariableDelete")) {
                this.taskInstanceVariableDelete(session, request, response);
                this.taskInstanceView(session, request, response);
            } else if (action.equals("taskInstanceVariableAdd")) {
                this.taskInstanceVariableAdd(session, request, response);
                this.taskInstanceView(session, request, response);
            } else if (action.equals("tokenView")) {
                this.tokenView(session, request, response);
            } else if (action.equals("tokenEnd")) {
                this.tokenEnd(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("tokenSuspend")) {
                this.tokenSuspend(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("tokenResume")) {
                this.tokenResume(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("processInstanceAddComment")) {
                this.processInstanceAddComment(session, request, response);
                this.processInstanceView(session, request, response);
            } else if (action.equals("tokenSignal")) {
                this.tokenSignal(session, request, response);
                this.tokenView(session, request, response);
            } else if (action.equals("tokenSetNode")) {
                this.tokenSetNode(session, request, response);
                this.tokenView(session, request, response);
            } else {
                this.processDefinitionList(session, request, response);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        catch (AccessDeniedException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendErrorRedirect(request, response, e);
        }
        finally {
            JCRUtils.logout(session);
        }
    }

    private void processDefinitionList(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, RepositoryException, DatabaseException, WorkflowException {
        log.debug("listProcessDefinition({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        sc.setAttribute("processDefinitions", OKMWorkflow.getInstance().findAllProcessDefinitions(null));
        sc.getRequestDispatcher("/admin/process_definition_list.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("listProcessDefinition: void");
    }

    private void processDefinitionDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("deleteProcessDefinition({}, {}, {})", new Object[]{session, request, response});
        long pdid = WebUtils.getLong(request, "pdid");
        OKMWorkflow.getInstance().deleteProcessDefinition(null, pdid);
        UserActivity.log(session.getUserID(), "ADMIN_PROCESS_DEFINITION_DELETE", Long.toString(pdid), null);
        log.debug("deleteProcessDefinition: void");
    }

    private void processDefinitionView(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, RepositoryException, DatabaseException, WorkflowException, ParseException {
        log.debug("viewProcessDefinition({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        long pdid = WebUtils.getLong(request, "pdid");
        int statusFilter = WebUtils.getInt(request, "statusFilter", 1);
        Map<String, List<FormElement>> procDefForms = OKMWorkflow.getInstance().getProcessDefinitionForms(null, pdid);
        HashMap pdf = new HashMap();
        for (String key : procDefForms.keySet()) {
            ArrayList<Map<String, String>> value = new ArrayList<Map<String, String>>();
            for (FormElement fe : procDefForms.get(key)) {
                value.add(FormUtils.toString(fe));
            }
            pdf.put(key, value);
        }
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        for (ProcessInstance pi : OKMWorkflow.getInstance().findProcessInstances(null, pdid)) {
            if (statusFilter == 1) {
                if (pi.getEnd() != null || pi.isSuspended()) continue;
                processInstances.add(pi);
                continue;
            }
            if (statusFilter == 2) {
                if (pi.getEnd() == null || pi.isSuspended()) continue;
                processInstances.add(pi);
                continue;
            }
            processInstances.add(pi);
        }
        sc.setAttribute("processDefinition", (Object)OKMWorkflow.getInstance().getProcessDefinition(null, pdid));
        sc.setAttribute("processInstances", processInstances);
        sc.setAttribute("processDefinitionForms", pdf);
        sc.setAttribute("statusFilterValues", statusFilterValues);
        sc.setAttribute("statusFilter", (Object)statusFilter);
        sc.getRequestDispatcher("/admin/process_definition_view.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("viewProcessDefinition: void");
    }

    private void processInstanceView(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, RepositoryException, DatabaseException, WorkflowException, PrincipalAdapterException, AccessDeniedException {
        log.debug("processInstanceView({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        long piid = WebUtils.getLong(request, "piid");
        ProcessInstance pi = OKMWorkflow.getInstance().getProcessInstance(null, piid);
        HashMap<String, String> vars = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : pi.getVariables().entrySet()) {
            vars.put(entry.getKey(), FormatUtil.formatObject(entry.getValue()));
            if (!entry.getKey().equals(Config.WORKFLOW_PROCESS_INSTANCE_VARIABLE_UUID)) continue;
            vars.put(Config.WORKFLOW_PROCESS_INSTANCE_VARIABLE_PATH, OKMDocument.getInstance().getPath(null, entry.getValue().toString()));
        }
        sc.setAttribute("variables", vars);
        sc.setAttribute("processInstance", (Object)pi);
        sc.setAttribute("taskInstances", OKMWorkflow.getInstance().findTaskInstances(null, piid));
        sc.setAttribute("users", OKMAuth.getInstance().getUsers(null));
        sc.getRequestDispatcher("/admin/process_instance_view.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("processInstanceView: void");
    }

    private void processInstanceDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("processInstanceDelete({}, {}, {})", new Object[]{session, request, response});
        long piid = WebUtils.getLong(request, "piid");
        OKMWorkflow.getInstance().deleteProcessInstance(null, piid);
        UserActivity.log(session.getUserID(), "ADMIN_PROCESS_INSTANCE_DELETE", Long.toString(piid), null);
        log.debug("processInstanceDelete: void");
    }

    private void processInstanceEnd(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("processInstanceEnd({}, {}, {})", new Object[]{session, request, response});
        long piid = WebUtils.getLong(request, "piid");
        OKMWorkflow.getInstance().endProcessInstance(null, piid);
        UserActivity.log(session.getUserID(), "ADMIN_PROCESS_INSTANCE_END", Long.toString(piid), null);
        log.debug("processInstanceEnd: void");
    }

    private void processInstanceResume(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("processInstanceResume({}, {}, {})", new Object[]{session, request, response});
        long piid = WebUtils.getLong(request, "piid");
        OKMWorkflow.getInstance().resumeProcessInstance(null, piid);
        UserActivity.log(session.getUserID(), "ADMIN_PROCESS_INSTANCE_RESUME", Long.toString(piid), null);
        log.debug("processInstanceResume: void");
    }

    private void processInstanceSuspend(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("processInstanceSuspend({}, {}, {})", new Object[]{session, request, response});
        long piid = WebUtils.getLong(request, "piid");
        OKMWorkflow.getInstance().suspendProcessInstance(null, piid);
        UserActivity.log(session.getUserID(), "ADMIN_PROCESS_INSTANCE_SUSPEND", Long.toString(piid), null);
        log.debug("processInstanceSuspend: void");
    }

    private void processInstanceAddComment(Session session, HttpServletRequest request, HttpServletResponse response) throws DatabaseException, WorkflowException, RepositoryException {
        log.debug("processInstanceAddComment({}, {}, {})", new Object[]{session, request, response});
        long tid = WebUtils.getLong(request, "tid");
        String message = WebUtils.getString(request, "message");
        if (!message.equals("")) {
            OKMWorkflow.getInstance().addTokenComment(null, tid, message);
        }
        UserActivity.log(session.getUserID(), "ADMIN_PROCESS_INSTANCE_ADD_COMMENT", Long.toString(tid), null);
        log.debug("processInstanceAddComment: void");
    }

    private void processInstanceVariableDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("processInstanceVariableDelete({}, {}, {})", new Object[]{session, request, response});
        long piid = WebUtils.getLong(request, "piid");
        String name = WebUtils.getString(request, "name");
        OKMWorkflow.getInstance().deleteProcessInstanceVariable(null, piid, name);
        UserActivity.log(session.getUserID(), "ADMIN_PROCESS_INSTANCE_VARIABLE_DELETE", Long.toString(piid), null);
        log.debug("processInstanceVariableDelete: void");
    }

    private void processInstanceVariableAdd(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("processInstanceVariableAdd({}, {}, {})", new Object[]{session, request, response});
        long piid = WebUtils.getLong(request, "piid");
        String name = WebUtils.getString(request, "name");
        String value = WebUtils.getString(request, "value");
        OKMWorkflow.getInstance().addProcessInstanceVariable(null, piid, name, value);
        UserActivity.log(session.getUserID(), "ADMIN_PROCESS_INSTANCE_VARIABLE_ADD", Long.toString(piid), name + "=" + value);
        log.debug("processInstanceVariableAdd: void");
    }

    private void taskInstanceSetActor(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("taskInstanceSetActor({}, {}, {})", new Object[]{session, request, response});
        long tiid = WebUtils.getLong(request, "tiid");
        String actor = WebUtils.getString(request, "actor");
        OKMWorkflow.getInstance().setTaskInstanceActorId(null, tiid, actor);
        UserActivity.log(session.getUserID(), "ADMIN_TASK_INSTANCE_SET_ACTOR", Long.toString(tiid), actor);
        log.debug("taskInstanceSetActor: void");
    }

    private void taskInstanceView(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, RepositoryException, DatabaseException, WorkflowException, ParseException, AccessDeniedException {
        log.debug("taskInstanceView({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        long tiid = WebUtils.getLong(request, "tiid");
        TaskInstance ti = OKMWorkflow.getInstance().getTaskInstance(null, tiid);
        Map<String, List<FormElement>> procDefForms = OKMWorkflow.getInstance().getProcessDefinitionForms(null, ti.getProcessInstance().getProcessDefinition().getId());
        ArrayList<Map<String, String>> pdf = new ArrayList<Map<String, String>>();
        HashMap vars = new HashMap();
        List<FormElement> fes = procDefForms.get(ti.getName());
        if (fes != null) {
            for (FormElement formElement : fes) {
                pdf.add(FormUtils.toString(formElement));
            }
        }
        for (Map.Entry entry : ti.getVariables().entrySet()) {
            vars.put(entry.getKey(), FormatUtil.formatObject(entry.getValue()));
            if (!((String)entry.getKey()).equals(Config.WORKFLOW_PROCESS_INSTANCE_VARIABLE_UUID)) continue;
            vars.put(Config.WORKFLOW_PROCESS_INSTANCE_VARIABLE_PATH, OKMDocument.getInstance().getPath(null, entry.getValue().toString()));
        }
        sc.setAttribute("variables", vars);
        sc.setAttribute("taskInstance", (Object)ti);
        sc.setAttribute("taskInstanceForm", pdf);
        sc.getRequestDispatcher("/admin/task_instance_view.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("taskInstanceView: void");
    }

    private void taskInstanceStart(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("taskInstanceStart({}, {}, {})", new Object[]{session, request, response});
        long tiid = WebUtils.getLong(request, "tiid");
        OKMWorkflow.getInstance().startTaskInstance(null, tiid);
        UserActivity.log(session.getUserID(), "ADMIN_TASK_INSTANCE_START", Long.toString(tiid), null);
        log.debug("taskInstanceStart: void");
    }

    private void taskInstanceEnd(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("taskInstanceEnd({}, {}, {})", new Object[]{session, request, response});
        long tiid = WebUtils.getLong(request, "tiid");
        String transition = WebUtils.getString(request, "transition", null);
        OKMWorkflow.getInstance().endTaskInstance(null, tiid, transition);
        UserActivity.log(session.getUserID(), "ADMIN_TASK_INSTANCE_END", Long.toString(tiid), null);
        log.debug("taskInstanceEnd: void");
    }

    private void taskInstanceSuspend(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("taskInstanceSuspend({}, {}, {})", new Object[]{session, request, response});
        long tiid = WebUtils.getLong(request, "tiid");
        OKMWorkflow.getInstance().suspendTaskInstance(null, tiid);
        UserActivity.log(session.getUserID(), "ADMIN_TASK_INSTANCE_SUSPEND", Long.toString(tiid), null);
        log.debug("taskInstanceSuspend: void");
    }

    private void taskInstanceAddComment(Session session, HttpServletRequest request, HttpServletResponse response) throws DatabaseException, WorkflowException, RepositoryException {
        log.debug("processInstanceAddComment({}, {}, {})", new Object[]{session, request, response});
        long tiid = WebUtils.getLong(request, "tiid");
        String message = WebUtils.getString(request, "message");
        if (!message.equals("")) {
            OKMWorkflow.getInstance().addTaskInstanceComment(null, tiid, message);
        }
        UserActivity.log(session.getUserID(), "ADMIN_TASK_INSTANCE_ADD_COMMENT", Long.toString(tiid), null);
        log.debug("processInstanceAddComment: void");
    }

    private void taskInstanceVariableDelete(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("taskInstanceVariableDelete({}, {}, {})", new Object[]{session, request, response});
        long tiid = WebUtils.getLong(request, "tiid");
        String name = WebUtils.getString(request, "name");
        OKMWorkflow.getInstance().deleteTaskInstanceVariable(null, tiid, name);
        UserActivity.log(session.getUserID(), "ADMIN_TASK_INSTANCE_VARIABLE_DELETE", Long.toString(tiid), null);
        log.debug("taskInstanceVariableDelete: void");
    }

    private void taskInstanceVariableAdd(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("taskInstanceVariableAdd({}, {}, {})", new Object[]{session, request, response});
        long tiid = WebUtils.getLong(request, "tiid");
        String name = WebUtils.getString(request, "name");
        String value = WebUtils.getString(request, "value");
        OKMWorkflow.getInstance().addTaskInstanceVariable(null, tiid, name, value);
        UserActivity.log(session.getUserID(), "ADMIN_TASK_INSTANCE_VARIABLE_ADD", Long.toString(tiid), name + "=" + value);
        log.debug("taskInstanceVariableAdd: void");
    }

    private void taskInstanceResume(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("taskInstanceResume({}, {}, {})", new Object[]{session, request, response});
        long tiid = WebUtils.getLong(request, "tiid");
        OKMWorkflow.getInstance().resumeTaskInstance(null, tiid);
        UserActivity.log(session.getUserID(), "ADMIN_TASK_INSTANCE_RESUME", Long.toString(tiid), null);
        log.debug("taskInstanceResume: void");
    }

    private void tokenSuspend(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("tokenSuspend({}, {}, {})", new Object[]{session, request, response});
        long tid = WebUtils.getLong(request, "tid");
        OKMWorkflow.getInstance().suspendToken(null, tid);
        UserActivity.log(session.getUserID(), "ADMIN_TOKEN_SUSPEND", Long.toString(tid), null);
        log.debug("tokenSuspend: void");
    }

    private void tokenResume(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("tokenResume({}, {}, {})", new Object[]{session, request, response});
        long tid = WebUtils.getLong(request, "tid");
        OKMWorkflow.getInstance().resumeToken(null, tid);
        UserActivity.log(session.getUserID(), "ADMIN_TOKEN_RESUME", Long.toString(tid), null);
        log.debug("tokenResume: void");
    }

    private void tokenEnd(Session session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("tokenEnd({}, {}, {})", new Object[]{session, request, response});
        long tid = WebUtils.getLong(request, "tid");
        OKMWorkflow.getInstance().endToken(null, tid);
        UserActivity.log(session.getUserID(), "ADMIN_TOKEN_END", Long.toString(tid), null);
        log.debug("tokenEnd: void");
    }

    private void tokenSetNode(Session session, HttpServletRequest request, HttpServletResponse response) throws DatabaseException, WorkflowException, RepositoryException {
        log.debug("tokenSetNode({}, {}, {})", new Object[]{session, request, response});
        long tid = WebUtils.getLong(request, "tid");
        String node = WebUtils.getString(request, "node");
        OKMWorkflow.getInstance().setTokenNode(null, tid, node);
        UserActivity.log(session.getUserID(), "ADMIN_TOKEN_SET_NODE", Long.toString(tid), node);
        log.debug("tokenSetNode: void");
    }

    private void tokenSignal(Session session, HttpServletRequest request, HttpServletResponse response) throws DatabaseException, WorkflowException, RepositoryException {
        log.debug("tokenSignal({}, {}, {})", new Object[]{session, request, response});
        long tid = WebUtils.getLong(request, "tid");
        String transition = WebUtils.getString(request, "transition");
        OKMWorkflow.getInstance().sendTokenSignal(null, tid, transition);
        UserActivity.log(session.getUserID(), "ADMIN_TOKEN_SIGNAL", Long.toString(tid), transition);
        log.debug("tokenSignal: void");
    }

    private void tokenView(Session session, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, RepositoryException, DatabaseException, WorkflowException {
        log.debug("tokenView({}, {}, {})", new Object[]{session, request, response});
        ServletContext sc = this.getServletContext();
        long tid = WebUtils.getLong(request, "tid");
        sc.setAttribute("token", (Object)OKMWorkflow.getInstance().getToken(null, tid));
        sc.getRequestDispatcher("/admin/token_view.jsp").forward((ServletRequest)request, (ServletResponse)response);
        log.debug("tokenView: void");
    }

    static {
        statusFilterValues.put("0", "All");
        statusFilterValues.put("1", "Running");
        statusFilterValues.put("2", "Ended");
    }
}

