/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMAuth;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMAuthService;
import com.openkm.frontend.client.util.RoleComparator;
import com.openkm.frontend.client.util.UserComparator;
import com.openkm.jcr.JCRUtils;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.UserActivity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.LoginException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthServlet
extends OKMRemoteServiceServlet
implements OKMAuthService {
    private static Logger log = LoggerFactory.getLogger(AuthServlet.class);
    private static final long serialVersionUID = 2638205115826644606L;

    @Override
    public void logout() throws OKMException {
        log.debug("logout()");
        this.updateSessionManager();
        try {
            OKMAuth.getInstance().logout(null);
            this.getThreadLocalRequest().getSession().invalidate();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("logout: void");
    }

    @Override
    public Map<String, Byte> getGrantedRoles(String nodePath) throws OKMException {
        log.debug("getGrantedRoles({})", (Object)nodePath);
        HashMap<String, Byte> hm = new HashMap();
        this.updateSessionManager();
        try {
            hm = OKMAuth.getInstance().getGrantedRoles(null, nodePath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getGrantedRoles: {}", hm);
        return hm;
    }

    @Override
    public Map<String, Byte> getGrantedUsers(String nodePath) throws OKMException {
        log.debug("getGrantedUsers({})", (Object)nodePath);
        HashMap<String, Byte> hm = new HashMap();
        this.updateSessionManager();
        try {
            hm = OKMAuth.getInstance().getGrantedUsers(null, nodePath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getGrantedUsers: {}", hm);
        return hm;
    }

    @Override
    public String getRemoteUser() {
        log.debug("getRemoteUser()");
        String user = this.getThreadLocalRequest().getRemoteUser();
        log.debug("getRemoteUser: {}", (Object)user);
        return user;
    }

    @Override
    public List<String> getUngrantedUsers(String nodePath) throws OKMException {
        log.debug("getUngrantedUsers({})", (Object)nodePath);
        ArrayList<String> userList = new ArrayList<String>();
        this.updateSessionManager();
        try {
            List<String> col = OKMAuth.getInstance().getUsers(null);
            Set<String> grantedUsers = OKMAuth.getInstance().getGrantedUsers(null, nodePath).keySet();
            for (String user : col) {
                if (grantedUsers.contains(user)) continue;
                userList.add(user);
            }
            Collections.sort(userList, UserComparator.getInstance());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getUngrantedUsers: {}", userList);
        return userList;
    }

    @Override
    public List<String> getUngrantedRoles(String nodePath) throws OKMException {
        log.debug("getUngrantedRoles({})", (Object)nodePath);
        ArrayList<String> roleList = new ArrayList<String>();
        this.updateSessionManager();
        try {
            List<String> col = OKMAuth.getInstance().getRoles(null);
            Set<String> grantedRoles = OKMAuth.getInstance().getGrantedRoles(null, nodePath).keySet();
            for (String rol : col) {
                if (grantedRoles.contains(rol) || rol.equals(Config.DEFAULT_USER_ROLE) || rol.equals(Config.DEFAULT_ADMIN_ROLE)) continue;
                roleList.add(rol);
            }
            Collections.sort(roleList, RoleComparator.getInstance());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getUngrantedRoles: {}", roleList);
        return roleList;
    }

    @Override
    public List<String> getFilteredUngrantedUsers(String nodePath, String filter) throws OKMException {
        log.debug("getFilteredUngrantedUsers({})", (Object)nodePath);
        ArrayList<String> userList = new ArrayList<String>();
        this.updateSessionManager();
        try {
            List<String> col = OKMAuth.getInstance().getUsers(null);
            Set<String> grantedUsers = OKMAuth.getInstance().getGrantedUsers(null, nodePath).keySet();
            for (String user : col) {
                if (grantedUsers.contains(user) || !user.toLowerCase().startsWith(filter.toLowerCase())) continue;
                userList.add(user);
            }
            Collections.sort(userList, UserComparator.getInstance());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getFilteredUngrantedUsers: {}", userList);
        return userList;
    }

    @Override
    public List<String> getFilteredUngrantedRoles(String nodePath, String filter) throws OKMException {
        log.debug("getFilteredUngrantedRoles({})", (Object)nodePath);
        ArrayList<String> roleList = new ArrayList<String>();
        this.updateSessionManager();
        try {
            List<String> col = OKMAuth.getInstance().getRoles(null);
            Set<String> grantedRoles = OKMAuth.getInstance().getGrantedRoles(null, nodePath).keySet();
            for (String rol : col) {
                if (grantedRoles.contains(rol) || !rol.toLowerCase().startsWith(filter.toLowerCase()) || rol.equals(Config.DEFAULT_USER_ROLE) || rol.equals(Config.DEFAULT_ADMIN_ROLE)) continue;
                roleList.add(rol);
            }
            Collections.sort(roleList, RoleComparator.getInstance());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getFilteredUngrantedRoles: {}", roleList);
        return roleList;
    }

    @Override
    public void grantUser(String path, String user, int permissions, boolean recursive) throws OKMException {
        log.debug("grantUser({}, {}, {}, {})", new Object[]{path, user, permissions, recursive});
        this.updateSessionManager();
        try {
            OKMAuth.getInstance().grantUser(null, path, user, permissions, recursive);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("grantUser: void");
    }

    @Override
    public void revokeUser(String path, String user, boolean recursive) throws OKMException {
        log.debug("revokeUser({}, {}, {})", new Object[]{path, user, recursive});
        this.updateSessionManager();
        try {
            OKMAuth oKMAuth = OKMAuth.getInstance();
            oKMAuth.revokeUser(null, path, user, 1, recursive);
            oKMAuth.revokeUser(null, path, user, 2, recursive);
            oKMAuth.revokeUser(null, path, user, 4, recursive);
            oKMAuth.revokeUser(null, path, user, 8, recursive);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("revokeUser: void");
    }

    @Override
    public void revokeUser(String path, String user, int permissions, boolean recursive) throws OKMException {
        log.debug("revokeUser({}, {}, {}, {})", new Object[]{path, user, permissions, recursive});
        this.updateSessionManager();
        try {
            OKMAuth.getInstance().revokeUser(null, path, user, permissions, recursive);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("revokeUser: void");
    }

    @Override
    public void grantRole(String path, String role, int permissions, boolean recursive) throws OKMException {
        log.debug("grantRole({}, {}, {}, {})", new Object[]{path, role, permissions, recursive});
        this.updateSessionManager();
        try {
            OKMAuth.getInstance().grantRole(null, path, role, permissions, recursive);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("grantRole: void");
    }

    @Override
    public void revokeRole(String path, String role, boolean recursive) throws OKMException {
        log.debug("revokeRole({}, {}, {})", new Object[]{path, role, recursive});
        this.updateSessionManager();
        try {
            if (!path.equals("/okm:root")) {
                OKMAuth oKMAuth = OKMAuth.getInstance();
                oKMAuth.revokeRole(null, path, role, 1, recursive);
                oKMAuth.revokeRole(null, path, role, 2, recursive);
                oKMAuth.revokeRole(null, path, role, 4, recursive);
                oKMAuth.revokeRole(null, path, role, 8, recursive);
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("revokeRole: void");
    }

    @Override
    public void revokeRole(String path, String role, int permissions, boolean recursive) throws OKMException {
        log.debug("revokeRole({}, {}, {}, {})", new Object[]{path, role, permissions, recursive});
        this.updateSessionManager();
        try {
            if (!path.equals("/okm:root")) {
                OKMAuth.getInstance().revokeRole(null, path, role, permissions, recursive);
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("revokeRole: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keepAlive() throws OKMException {
        log.debug("keepAlive()");
        this.updateSessionManager();
        Session session = null;
        try {
            session = JCRUtils.getSession();
            UserActivity.log(session.getUserID(), "KEEP_ALIVE", null, null);
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            JCRUtils.logout(session);
        }
        log.debug("keepAlive: void");
    }

    @Override
    public List<String> getAllUsers() throws OKMException {
        log.debug("getAllUsers()");
        ArrayList<String> userList = new ArrayList<String>();
        this.updateSessionManager();
        try {
            List<String> col = OKMAuth.getInstance().getUsers(null);
            for (String user : col) {
                userList.add(user);
            }
            Collections.sort(userList, UserComparator.getInstance());
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "025"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getAllUsers: {}", userList);
        return userList;
    }

    @Override
    public List<String> getAllRoles() throws OKMException {
        log.debug("getAllRoles()");
        ArrayList<String> roleList = new ArrayList<String>();
        this.updateSessionManager();
        try {
            List<String> col = OKMAuth.getInstance().getRoles(null);
            for (String rol : col) {
                if (rol.equals(Config.DEFAULT_USER_ROLE) || rol.equals(Config.DEFAULT_ADMIN_ROLE)) continue;
                roleList.add(rol);
            }
            Collections.sort(roleList, RoleComparator.getInstance());
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "025"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getAllRoles: {}", roleList);
        return roleList;
    }

    @Override
    public List<String> getFilteredAllUsers(String filter, List<String> selectedUsers) throws OKMException {
        log.debug("getFilteredAllUsers()");
        ArrayList<String> userList = new ArrayList<String>();
        this.updateSessionManager();
        try {
            List<String> col = OKMAuth.getInstance().getUsers(null);
            for (String user : col) {
                if (!user.toLowerCase().startsWith(filter.toLowerCase()) || selectedUsers.contains(user)) continue;
                userList.add(user);
            }
            Collections.sort(userList, UserComparator.getInstance());
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "025"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getFilteredAllUsers: {}", userList);
        return userList;
    }

    @Override
    public List<String> getFilteredAllRoles(String filter, List<String> selectedRoles) throws OKMException {
        log.debug("getFilteredAllRoles()");
        ArrayList<String> roleList = new ArrayList<String>();
        this.updateSessionManager();
        try {
            List<String> col = OKMAuth.getInstance().getRoles(null);
            for (String rol : col) {
                if (rol.equals(Config.DEFAULT_USER_ROLE) || rol.equals(Config.DEFAULT_ADMIN_ROLE) || !rol.toLowerCase().startsWith(filter.toLowerCase()) || selectedRoles.contains(rol)) continue;
                roleList.add(rol);
            }
            Collections.sort(roleList, RoleComparator.getInstance());
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "025"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("007", "006"), e.getMessage());
        }
        log.debug("getFilteredAllRoles: {}", roleList);
        return roleList;
    }
}

