/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMBookmark;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.bean.Bookmark;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTBookmark;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMBookmarkService;
import com.openkm.frontend.client.util.BookmarkComparator;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkServlet
extends OKMRemoteServiceServlet
implements OKMBookmarkService {
    private static Logger log = LoggerFactory.getLogger(BookmarkServlet.class);
    private static final long serialVersionUID = 1L;

    @Override
    public List<GWTBookmark> getAll() throws OKMException {
        log.debug("getAll()");
        ArrayList<GWTBookmark> bookmarkList = new ArrayList<GWTBookmark>();
        this.updateSessionManager();
        try {
            List<Bookmark> col = OKMBookmark.getInstance().getAll(null);
            for (Bookmark bookmark : col) {
                log.debug("Bookmark: {}", (Object)bookmark);
                GWTBookmark bookmarkClient = GWTUtil.copy(bookmark);
                bookmarkList.add(bookmarkClient);
            }
            Collections.sort(bookmarkList, BookmarkComparator.getInstance());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "006"), e.getMessage());
        }
        log.debug("getAll: {}", bookmarkList);
        return bookmarkList;
    }

    @Override
    public GWTBookmark add(String nodePath, String name) throws OKMException {
        log.debug("add({}, {})", (Object)nodePath, (Object)name);
        this.updateSessionManager();
        try {
            return GWTUtil.copy(OKMBookmark.getInstance().add(null, nodePath, name));
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "006"), e.getMessage());
        }
    }

    @Override
    public void remove(int bmId) throws OKMException {
        log.debug("remove({})", (Object)bmId);
        this.updateSessionManager();
        try {
            OKMBookmark.getInstance().remove(null, bmId);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "006"), e.getMessage());
        }
        log.debug("remove: void");
    }

    @Override
    public GWTBookmark rename(int bmId, String newName) throws OKMException {
        log.debug("rename({}, {})", (Object)bmId, (Object)newName);
        this.updateSessionManager();
        try {
            return GWTUtil.copy(OKMBookmark.getInstance().rename(null, bmId, newName));
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "006"), e.getMessage());
        }
    }

    @Override
    public GWTBookmark get(int bmId) throws OKMException {
        log.debug("get({})", (Object)bmId);
        this.updateSessionManager();
        try {
            return GWTUtil.copy(OKMBookmark.getInstance().get(null, bmId));
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("011", "006"), e.getMessage());
        }
    }
}

