/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.core.ChatManager;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.service.OKMChatService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class ChatServlet
extends OKMRemoteServiceServlet
implements OKMChatService {
    private static final long serialVersionUID = 3780857624687394918L;
    private static final int DELAY = 1000;
    private static final ChatManager manager = new ChatManager();

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    @Override
    public void login() throws OKMException {
        this.updateSessionManager();
        String user = this.getThreadLocalRequest().getRemoteUser();
        if (user != null) {
            manager.login(user);
        }
    }

    @Override
    public void logout() throws OKMException {
        this.updateSessionManager();
        String user = this.getThreadLocalRequest().getRemoteUser();
        if (user != null) {
            manager.logout(user);
        }
    }

    @Override
    public List<String> getLoggedUsers() {
        this.updateSessionManager();
        return manager.getLoggedUsers();
    }

    @Override
    public String createNewChatRoom(String user) {
        this.updateSessionManager();
        String actualUser = this.getThreadLocalRequest().getRemoteUser();
        return manager.createNewChatRoom(actualUser, user);
    }

    @Override
    public List<String> getPendingMessage(String room) {
        this.updateSessionManager();
        String user = this.getThreadLocalRequest().getRemoteUser();
        List<String> pendingMessages = new ArrayList<String>();
        if (user != null) {
            int countCycle = 0;
            do {
                pendingMessages = manager.getPendingMessage(user, room);
                ++countCycle;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (pendingMessages.isEmpty() && countCycle < 100 && manager.getLoggedUsers().contains(user));
        }
        return pendingMessages;
    }

    @Override
    public List<String> getPendingChatRoomUser() {
        this.updateSessionManager();
        String user = this.getThreadLocalRequest().getRemoteUser();
        List<String> pendingRooms = new ArrayList<String>();
        if (user != null) {
            int countCycle = 0;
            do {
                pendingRooms = manager.getPendingChatRoomUser(user);
                ++countCycle;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (pendingRooms.isEmpty() && countCycle < 100 && manager.getLoggedUsers().contains(user));
        }
        return pendingRooms;
    }

    @Override
    public void addMessageToRoom(String room, String msg) {
        this.updateSessionManager();
        String user = this.getThreadLocalRequest().getRemoteUser();
        if (user != null) {
            manager.addMessageToRoom(user, room, msg);
        }
    }

    @Override
    public void closeRoom(String room) {
        this.updateSessionManager();
        String user = this.getThreadLocalRequest().getRemoteUser();
        if (user != null) {
            manager.closeRoom(user, room);
        }
    }

    @Override
    public void addUserToChatRoom(String room, String user) {
        this.updateSessionManager();
        manager.addUserToChatRoom(user, room);
    }

    @Override
    public String usersInRoom(String room) {
        this.updateSessionManager();
        return String.valueOf(manager.getNumberOfUsersInRoom(room));
    }

    @Override
    public List<String> getUsersInRoom(String room) {
        this.updateSessionManager();
        return manager.getUsersInRoom(room);
    }

    public static ChatManager getChatManager() {
        return manager;
    }
}

