/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMDocument;
import com.openkm.api.OKMRepository;
import com.openkm.bean.Document;
import com.openkm.core.Config;
import com.openkm.core.ConversionException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.frontend.OKMHttpServlet;
import com.openkm.util.DocConverter;
import com.openkm.util.WebUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterServlet
extends OKMHttpServlet {
    private static Logger log = LoggerFactory.getLogger(ConverterServlet.class);
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block20: {
            log.debug("service({}, {})", (Object)request, (Object)response);
            request.setCharacterEncoding("UTF-8");
            String uuid = WebUtils.getString(request, "uuid");
            boolean inline = WebUtils.getBoolean(request, "inline");
            boolean toPdf = WebUtils.getBoolean(request, "toPdf");
            boolean toSwf = WebUtils.getBoolean(request, "toSwf");
            boolean toDxf = WebUtils.getBoolean(request, "toDxf");
            File tmp = null;
            InputStream is = null;
            this.updateSessionManager(request);
            try {
                if (uuid.equals("")) break block20;
                String path = OKMRepository.getInstance().getNodePath(null, uuid);
                Document doc = OKMDocument.getInstance().getProperties(null, path);
                String fileName = JCRUtils.getName(doc.getPath());
                tmp = File.createTempFile("okm", "." + com.openkm.util.FileUtils.getFileExtension(fileName));
                is = OKMDocument.getInstance().getContent(null, path, false);
                com.openkm.util.FileUtils.copy(is, tmp);
                ConversionData cd = new ConversionData();
                cd.uuid = uuid;
                cd.fileName = fileName;
                cd.mimeType = doc.getMimeType();
                cd.file = tmp;
                if (toDxf && !cd.mimeType.equals(Config.MIME_DXF)) {
                    try {
                        this.toDXF(cd);
                    }
                    catch (ConversionException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                } else if (toPdf && !cd.mimeType.equals(Config.MIME_PDF)) {
                    try {
                        this.toPDF(cd);
                    }
                    catch (ConversionException e) {
                        log.error(e.getMessage(), (Throwable)e);
                        InputStream tis = ConverterServlet.class.getResourceAsStream("conversion_problem.pdf");
                        com.openkm.util.FileUtils.copy(tis, cd.file);
                    }
                } else if (toSwf && !cd.mimeType.equals(Config.MIME_SWF)) {
                    try {
                        this.toSWF(cd);
                    }
                    catch (ConversionException e) {
                        log.error(e.getMessage(), (Throwable)e);
                        InputStream tis = ConverterServlet.class.getResourceAsStream("conversion_problem.swf");
                        com.openkm.util.FileUtils.copy(tis, cd.file);
                    }
                }
                WebUtils.sendFile(request, response, cd.fileName, cd.mimeType, inline, cd.file);
                is.close();
            }
            catch (PathNotFoundException e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "015"), e.getMessage()));
            }
            catch (RepositoryException e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "001"), e.getMessage()));
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "013"), e.getMessage()));
            }
            catch (DatabaseException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "024"), e.getMessage()));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "006"), e.getMessage()));
            }
            finally {
                FileUtils.deleteQuietly(tmp);
            }
        }
        log.debug("service: void");
    }

    private void toDXF(ConversionData cd) throws ConversionException, DatabaseException, IOException {
        File dxfCache = new File(Config.CACHE_DXF + File.separator + cd.uuid + ".dxf");
        if (DocConverter.getInstance().convertibleToDxf(cd.mimeType)) {
            block11: {
                if (!dxfCache.exists()) {
                    try {
                        if (cd.mimeType.equals(Config.MIME_DWG)) {
                            DocConverter.getInstance().dwg2dxf(cd.file, dxfCache);
                            break block11;
                        }
                        if (cd.mimeType.equals(Config.MIME_DXF)) {
                            break block11;
                        }
                        throw new NotImplementedException("Conversion from '" + cd.mimeType + "' to DXF not available");
                    }
                    catch (ConversionException e) {
                        dxfCache.delete();
                        throw e;
                    }
                    finally {
                        cd.mimeType = Config.MIME_DXF;
                        cd.fileName = com.openkm.util.FileUtils.getFileName(cd.fileName) + ".dxf";
                    }
                }
            }
            if (dxfCache.exists()) {
                cd.file = dxfCache;
            }
        } else {
            throw new NotImplementedException("Conversion from '" + cd.mimeType + "' to DXF not available");
        }
        cd.mimeType = Config.MIME_DXF;
        cd.fileName = com.openkm.util.FileUtils.getFileName(cd.fileName) + ".dxf";
    }

    private void toPDF(ConversionData cd) throws ConversionException, DatabaseException, IOException {
        File pdfCache = new File(Config.CACHE_PDF + File.separator + cd.uuid + ".pdf");
        if (DocConverter.getInstance().convertibleToPdf(cd.mimeType)) {
            block15: {
                if (!pdfCache.exists()) {
                    try {
                        if (cd.mimeType.equals(Config.MIME_POSTSCRIPT)) {
                            DocConverter.getInstance().ps2pdf(cd.file, pdfCache);
                            break block15;
                        }
                        if (cd.mimeType.equals(Config.MIME_TIFF)) {
                            DocConverter.getInstance().tiff2pdf(cd.file, pdfCache);
                            break block15;
                        }
                        if (DocConverter.validImageMagick.contains(cd.mimeType)) {
                            DocConverter.getInstance().img2pdf(cd.file, cd.mimeType, pdfCache);
                            break block15;
                        }
                        if (DocConverter.validOpenOffice.contains(cd.mimeType)) {
                            DocConverter.getInstance().doc2pdf(cd.file, cd.mimeType, pdfCache);
                            break block15;
                        }
                        if (DocConverter.validAutoCad.contains(cd.mimeType)) {
                            DocConverter.getInstance().cad2pdf(cd.file, cd.mimeType, pdfCache);
                            break block15;
                        }
                        if (cd.mimeType.equals(Config.MIME_PDF)) {
                            break block15;
                        }
                        throw new NotImplementedException("Conversion from '" + cd.mimeType + "' to PDF not available");
                    }
                    catch (ConversionException e) {
                        pdfCache.delete();
                        throw e;
                    }
                    finally {
                        cd.mimeType = Config.MIME_PDF;
                        cd.fileName = com.openkm.util.FileUtils.getFileName(cd.fileName) + ".pdf";
                    }
                }
            }
            if (pdfCache.exists()) {
                cd.file = pdfCache;
            }
        } else {
            throw new NotImplementedException("Conversion from '" + cd.mimeType + "' to PDF not available");
        }
        cd.mimeType = Config.MIME_PDF;
        cd.fileName = com.openkm.util.FileUtils.getFileName(cd.fileName) + ".pdf";
    }

    private void toSWF(ConversionData cd) throws ConversionException, DatabaseException, IOException {
        File swfCache = new File(Config.CACHE_SWF + File.separator + cd.uuid + ".swf");
        if (DocConverter.getInstance().convertibleToSwf(cd.mimeType)) {
            block12: {
                if (!swfCache.exists()) {
                    try {
                        if (cd.mimeType.equals(Config.MIME_PDF)) {
                            DocConverter.getInstance().pdf2swf(cd.file, swfCache);
                            break block12;
                        }
                        if (DocConverter.getInstance().convertibleToPdf(cd.mimeType)) {
                            this.toPDF(cd);
                            DocConverter.getInstance().pdf2swf(cd.file, swfCache);
                            break block12;
                        }
                        if (cd.mimeType.equals(Config.MIME_SWF)) {
                            break block12;
                        }
                        throw new NotImplementedException("Conversion from '" + cd.mimeType + "' to SWF not available");
                    }
                    catch (ConversionException e) {
                        swfCache.delete();
                        throw e;
                    }
                    finally {
                        cd.mimeType = Config.MIME_SWF;
                        cd.fileName = com.openkm.util.FileUtils.getFileName(cd.fileName) + ".swf";
                    }
                }
            }
            if (swfCache.exists()) {
                cd.file = swfCache;
            }
        } else {
            throw new NotImplementedException("Conversion from '" + cd.mimeType + "' to SWF not available");
        }
        cd.mimeType = Config.MIME_SWF;
        cd.fileName = com.openkm.util.FileUtils.getFileName(cd.fileName) + ".swf";
    }

    private class ConversionData {
        private String uuid;
        private String fileName;
        private String mimeType;
        private File file;

        private ConversionData() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("uuid=");
            sb.append(this.uuid);
            sb.append(", fileName=");
            sb.append(this.fileName);
            sb.append(", mimeType=");
            sb.append(this.mimeType);
            sb.append(", file=");
            sb.append(this.file);
            sb.append("}");
            return sb.toString();
        }
    }
}

