/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMDashboard;
import com.openkm.bean.DashboardDocumentResult;
import com.openkm.bean.DashboardFolderResult;
import com.openkm.bean.DashboardMailResult;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.QueryParamsDAO;
import com.openkm.dao.bean.QueryParams;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTDashboardDocumentResult;
import com.openkm.frontend.client.bean.GWTDashboardFolderResult;
import com.openkm.frontend.client.bean.GWTDashboardMailResult;
import com.openkm.frontend.client.bean.GWTQueryParams;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMDashboardService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardServlet
extends OKMRemoteServiceServlet
implements OKMDashboardService {
    private static Logger log = LoggerFactory.getLogger(DashboardServlet.class);
    private static final long serialVersionUID = 1L;

    @Override
    public List<GWTDashboardDocumentResult> getUserLockedDocuments() throws OKMException {
        log.debug("getUserLockedDocuments()");
        ArrayList<GWTDashboardDocumentResult> lockList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            List<DashboardDocumentResult> col = OKMDashboard.getInstance().getUserLockedDocuments(null);
            for (DashboardDocumentResult documentResult : col) {
                GWTDashboardDocumentResult documentResultClient = GWTUtil.copy(documentResult);
                lockList.add(documentResultClient);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getUserLockedDocuments: {}", lockList);
        return lockList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getUserCheckedOutDocuments() throws OKMException {
        log.debug("getUserCheckedOutDocuments()");
        ArrayList<GWTDashboardDocumentResult> chekoutList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            List<DashboardDocumentResult> col = OKMDashboard.getInstance().getUserCheckedOutDocuments(null);
            for (DashboardDocumentResult documentResult : col) {
                GWTDashboardDocumentResult documentResultClient = GWTUtil.copy(documentResult);
                chekoutList.add(documentResultClient);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getUserCheckedOutDocuments: {}", chekoutList);
        return chekoutList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getUserLastModifiedDocuments() throws OKMException {
        log.debug("getUserLastModifiedDocuments()");
        ArrayList<GWTDashboardDocumentResult> lastModifiedList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            List<DashboardDocumentResult> col = OKMDashboard.getInstance().getUserLastModifiedDocuments(null);
            for (DashboardDocumentResult documentResult : col) {
                GWTDashboardDocumentResult documentResultClient = GWTUtil.copy(documentResult);
                lastModifiedList.add(documentResultClient);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getUserLastModifiedDocuments: {}", lastModifiedList);
        return lastModifiedList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getUserSubscribedDocuments() throws OKMException {
        log.debug("getUserSubscribedDocuments()");
        ArrayList<GWTDashboardDocumentResult> subscribedList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            List<DashboardDocumentResult> col = OKMDashboard.getInstance().getUserSubscribedDocuments(null);
            for (DashboardDocumentResult documentResult : col) {
                GWTDashboardDocumentResult documentResultClient = GWTUtil.copy(documentResult);
                subscribedList.add(documentResultClient);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getUserSubscribedDocuments: {}", subscribedList);
        return subscribedList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getUserLastUploadedDocuments() throws OKMException {
        log.debug("getUserLastUploadedDocuments()");
        ArrayList<GWTDashboardDocumentResult> lastUploadedList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            List<DashboardDocumentResult> col = OKMDashboard.getInstance().getUserLastUploadedDocuments(null);
            for (DashboardDocumentResult documentResult : col) {
                GWTDashboardDocumentResult documentResultClient = GWTUtil.copy(documentResult);
                lastUploadedList.add(documentResultClient);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getUserLastUploadedDocuments: {}", lastUploadedList);
        return lastUploadedList;
    }

    @Override
    public List<GWTDashboardFolderResult> getUserSubscribedFolders() throws OKMException {
        log.debug("getUserSubscribedFolders()");
        ArrayList<GWTDashboardFolderResult> subscribedList = new ArrayList<GWTDashboardFolderResult>();
        this.updateSessionManager();
        try {
            List<DashboardFolderResult> col = OKMDashboard.getInstance().getUserSubscribedFolders(null);
            for (DashboardFolderResult folderResult : col) {
                GWTDashboardFolderResult folderResultClient = GWTUtil.copy(folderResult);
                subscribedList.add(folderResultClient);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getUserSubscribedFolders: {}", subscribedList);
        return subscribedList;
    }

    @Override
    public List<GWTQueryParams> getUserSearchs() throws OKMException {
        log.debug("getUserSearchs()");
        ArrayList<GWTQueryParams> searchList = new ArrayList<GWTQueryParams>();
        this.updateSessionManager();
        try {
            Iterator<QueryParams> it = OKMDashboard.getInstance().getUserSearchs(null).iterator();
            while (it.hasNext()) {
                searchList.add(GWTUtil.copy(it.next()));
            }
            for (QueryParams params : QueryParamsDAO.findShared(this.getThreadLocalRequest().getRemoteUser())) {
                if (!params.isDashboard()) continue;
                GWTQueryParams gWTQueryParams = GWTUtil.copy(params);
                gWTQueryParams.setShared(true);
                searchList.add(gWTQueryParams);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "013"), e.getMessage());
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "019"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "015"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        log.debug("getUserSearchs: {}", searchList);
        return searchList;
    }

    @Override
    public List<GWTDashboardDocumentResult> find(int id) throws OKMException {
        log.debug("find({})", (Object)id);
        ArrayList<GWTDashboardDocumentResult> docList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardDocumentResult> it = OKMDashboard.getInstance().find(null, id).iterator();
            while (it.hasNext()) {
                docList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "013"), e.getMessage());
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "019"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        log.debug("find: {}", docList);
        return docList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getLastWeekTopDownloadedDocuments() throws OKMException {
        log.debug("getLastWeekTopDownloadedDocuments()");
        ArrayList<GWTDashboardDocumentResult> docList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardDocumentResult> it = OKMDashboard.getInstance().getLastWeekTopDownloadedDocuments(null).iterator();
            while (it.hasNext()) {
                docList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getLastWeekTopDownloadedDocuments: {}", docList);
        return docList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getLastMonthTopDownloadedDocuments() throws OKMException {
        log.debug("getLastMonthTopDownloadedDocuments()");
        ArrayList<GWTDashboardDocumentResult> docList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardDocumentResult> it = OKMDashboard.getInstance().getLastMonthTopDownloadedDocuments(null).iterator();
            while (it.hasNext()) {
                docList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getLastMonthTopDownloadedDocuments: {}", docList);
        return docList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getLastWeekTopModifiedDocuments() throws OKMException {
        log.debug("getLastWeekTopModifiedDocuments()");
        ArrayList<GWTDashboardDocumentResult> docList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardDocumentResult> it = OKMDashboard.getInstance().getLastWeekTopModifiedDocuments(null).iterator();
            while (it.hasNext()) {
                docList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getLastWeekTopModifiedDocuments: {}", docList);
        return docList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getLastMonthTopModifiedDocuments() throws OKMException {
        log.debug("getLastMonthTopModifiedDocuments()");
        ArrayList<GWTDashboardDocumentResult> docList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardDocumentResult> it = OKMDashboard.getInstance().getLastMonthTopModifiedDocuments(null).iterator();
            while (it.hasNext()) {
                docList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getLastMonthTopModifiedDocuments: {}", docList);
        return docList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getUserLastDownloadedDocuments() throws OKMException {
        log.debug("getUserLastDownloadedDocuments()");
        ArrayList<GWTDashboardDocumentResult> docList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardDocumentResult> it = OKMDashboard.getInstance().getUserLastDownloadedDocuments(null).iterator();
            while (it.hasNext()) {
                docList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getUserLastDownloadedDocuments: {}", docList);
        return docList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getLastModifiedDocuments() throws OKMException {
        log.debug("getLastModifiedDocuments()");
        ArrayList<GWTDashboardDocumentResult> docList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardDocumentResult> it = OKMDashboard.getInstance().getLastModifiedDocuments(null).iterator();
            while (it.hasNext()) {
                docList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getLastModifiedDocuments: {}", docList);
        return docList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getLastUploadedDocuments() throws OKMException {
        log.debug("getLastWeekTopUploadedDocuments()");
        ArrayList<GWTDashboardDocumentResult> docList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardDocumentResult> it = OKMDashboard.getInstance().getLastUploadedDocuments(null).iterator();
            while (it.hasNext()) {
                docList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getLastWeekTopUploadedDocuments: {}", docList);
        return docList;
    }

    @Override
    public List<GWTDashboardDocumentResult> getUserLastImportedMailAttachments() throws OKMException {
        log.debug("getUserLastImportedMailAttachments()");
        ArrayList<GWTDashboardDocumentResult> docList = new ArrayList<GWTDashboardDocumentResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardDocumentResult> it = OKMDashboard.getInstance().getUserLastImportedMailAttachments(null).iterator();
            while (it.hasNext()) {
                docList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getUserLastImportedMailAttachments: {}", docList);
        return docList;
    }

    @Override
    public List<GWTDashboardMailResult> getUserLastImportedMails() throws OKMException {
        log.debug("getUserLastImportedMails()");
        ArrayList<GWTDashboardMailResult> mailList = new ArrayList<GWTDashboardMailResult>();
        this.updateSessionManager();
        try {
            Iterator<DashboardMailResult> it = OKMDashboard.getInstance().getUserLastImportedMails(null).iterator();
            while (it.hasNext()) {
                mailList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("getUserLastImportedMails: {}", mailList);
        return mailList;
    }

    @Override
    public void visiteNode(String source, String node, Date date) throws OKMException {
        log.debug("visiteNode({}, {}, {})", new Object[]{source, node, date});
        this.updateSessionManager();
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            OKMDashboard.getInstance().visiteNode(null, source, node, cal);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("013", "024"), e.getMessage());
        }
        log.debug("visiteNode: void");
    }
}

