/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.core.DatabaseException;
import com.openkm.dao.DatabaseMetadataDAO;
import com.openkm.dao.bean.DatabaseMetadataValue;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMDatabaseMetadataService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.DatabaseMetadataUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetadataServlet
extends OKMRemoteServiceServlet
implements OKMDatabaseMetadataService {
    private static Logger log = LoggerFactory.getLogger(DatabaseMetadataServlet.class);
    private static final long serialVersionUID = 1L;

    @Override
    public List<Map<String, String>> executeValueQuery(String table, String filter, String order) throws OKMException {
        log.debug("executeValueQuery({}, {}, {})", new Object[]{table, filter, order});
        this.updateSessionManager();
        ArrayList<Map<String, String>> metadataValues = new ArrayList<Map<String, String>>();
        try {
            for (DatabaseMetadataValue dmv : DatabaseMetadataDAO.executeValueQuery(DatabaseMetadataUtils.buildQuery(table, filter, order))) {
                metadataValues.add(DatabaseMetadataUtils.getDatabaseMetadataValueMap(dmv));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "024"), e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "042"), e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "043"), e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "044"), e.getMessage());
        }
        log.debug("executeValueQuery: {}", metadataValues);
        return metadataValues;
    }

    @Override
    public void updateValue(Map<String, String> map) throws OKMException {
        log.debug("updateValue({})", map);
        this.updateSessionManager();
        try {
            DatabaseMetadataDAO.updateValue(DatabaseMetadataUtils.getDatabaseMetadataValueByMap(map));
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "024"), e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "042"), e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "043"), e.getMessage());
        }
    }

    @Override
    public Double createValue(Map<String, String> map) throws OKMException {
        log.debug("createValue({})", map);
        this.updateSessionManager();
        try {
            return new Double(DatabaseMetadataDAO.createValue(DatabaseMetadataUtils.getDatabaseMetadataValueByMap(map)));
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "024"), e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "042"), e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "043"), e.getMessage());
        }
    }

    @Override
    public void deleteValue(Map<String, String> map) throws OKMException {
        log.debug("deleteValue({})", map);
        this.updateSessionManager();
        try {
            DatabaseMetadataDAO.deleteValue(DatabaseMetadataUtils.getDatabaseMetadataValueByMap(map).getId().intValue());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "024"), e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "042"), e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "043"), e.getMessage());
        }
    }

    @Override
    public List<List<Map<String, String>>> executeMultiValueQuery(List<String> tables, String query) throws OKMException {
        log.debug("executeMultiValueQuery({})", (Object)query);
        this.updateSessionManager();
        ArrayList<List<Map<String, String>>> ret = new ArrayList<List<Map<String, String>>>();
        try {
            for (DatabaseMetadataValue[] dmv : DatabaseMetadataDAO.executeMultiValueQuery(DatabaseMetadataUtils.replaceVirtual(tables, query))) {
                ArrayList<Map<String, String>> dmvRow = new ArrayList<Map<String, String>>();
                for (int i = 0; i < dmv.length; ++i) {
                    dmvRow.add(DatabaseMetadataUtils.getDatabaseMetadataValueMap(dmv[i]));
                }
                ret.add(dmvRow);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "024"), e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "042"), e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "043"), e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "044"), e.getMessage());
        }
        return ret;
    }

    @Override
    public Double getNextSequenceValue(String table, String column) throws OKMException {
        log.debug("getNextSequenceValue({},{})", (Object)table, (Object)column);
        this.updateSessionManager();
        try {
            return new Double(DatabaseMetadataDAO.getNextSequenceValue(table, column));
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("032", "024"), e.getMessage());
        }
    }
}

