/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.lowagie.text.DocumentException;
import com.openkm.api.OKMDocument;
import com.openkm.api.OKMFolder;
import com.openkm.api.OKMPropertyGroup;
import com.openkm.api.OKMRepository;
import com.openkm.api.OKMSearch;
import com.openkm.bean.Document;
import com.openkm.bean.PropertyGroup;
import com.openkm.bean.QueryResult;
import com.openkm.bean.Version;
import com.openkm.bean.form.FormElement;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.ConversionException;
import com.openkm.core.DatabaseException;
import com.openkm.core.FileSizeExceededException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.LockException;
import com.openkm.core.NoSuchGroupException;
import com.openkm.core.NoSuchPropertyException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UnsupportedMimeTypeException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VersionException;
import com.openkm.core.VirusDetectedException;
import com.openkm.dao.bean.QueryParams;
import com.openkm.extension.core.ExtensionException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTVersion;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMDocumentService;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.servlet.frontend.util.DocumentComparator;
import com.openkm.util.DocConverter;
import com.openkm.util.FileUtils;
import com.openkm.util.GWTUtil;
import com.openkm.util.OOUtils;
import com.openkm.util.PDFUtils;
import com.openkm.util.TemplateUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jooreports.templates.DocumentTemplateException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentServlet
extends OKMRemoteServiceServlet
implements OKMDocumentService {
    private static Logger log = LoggerFactory.getLogger(DocumentServlet.class);
    private static final long serialVersionUID = 5746570509074299745L;

    @Override
    public List<GWTDocument> getChilds(String fldPath) throws OKMException {
        log.debug("getDocumentChilds({})", (Object)fldPath);
        ArrayList<GWTDocument> docList = new ArrayList<GWTDocument>();
        this.updateSessionManager();
        try {
            if (fldPath == null) {
                fldPath = OKMRepository.getInstance().getRootFolder(null).getPath();
            }
            if (fldPath.startsWith("/okm:thesaurus")) {
                QueryParams queryParams = new QueryParams();
                HashSet<String> keywords = new HashSet<String>();
                keywords.add(fldPath.substring(fldPath.lastIndexOf("/") + 1).replace(" ", "_"));
                queryParams.setKeywords(keywords);
                List<QueryResult> results = OKMSearch.getInstance().find(null, queryParams);
                for (QueryResult queryResult : results) {
                    if (queryResult.getDocument() == null) continue;
                    GWTDocument docClient = GWTUtil.copy(queryResult.getDocument());
                    docList.add(docClient);
                }
            } else if (fldPath.startsWith("/okm:categories")) {
                String uuid = OKMFolder.getInstance().getProperties(null, fldPath).getUuid();
                List<Document> results = OKMSearch.getInstance().getCategorizedDocuments(null, uuid);
                Iterator it = results.iterator();
                while (it.hasNext()) {
                    GWTDocument docClient = GWTUtil.copy((Document)it.next());
                    docList.add(docClient);
                }
            } else {
                log.debug("ParentFolder: {}", (Object)fldPath);
                List<Document> col = OKMDocument.getInstance().getChilds(null, fldPath);
                for (Document doc : col) {
                    log.debug("Document: {}", (Object)doc);
                    GWTDocument docClient = GWTUtil.copy(doc);
                    docList.add(docClient);
                }
            }
            Collections.sort(docList, DocumentComparator.getInstance(this.getLanguage()));
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("getDocumentChilds: {}", docList);
        return docList;
    }

    @Override
    public List<GWTVersion> getVersionHistory(String docPath) throws OKMException {
        log.debug("getVersionHistory({})", (Object)docPath);
        ArrayList<GWTVersion> versionList = new ArrayList<GWTVersion>();
        this.updateSessionManager();
        try {
            List<Version> col = OKMDocument.getInstance().getVersionHistory(null, docPath);
            for (Version version : col) {
                log.debug("version: {}", (Object)version);
                GWTVersion versionClient = GWTUtil.copy(version);
                versionList.add(versionClient);
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("getVersionHistory: {}", versionList);
        return versionList;
    }

    @Override
    public void delete(String docPath) throws OKMException {
        log.debug("delete({})", (Object)docPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().delete(null, docPath);
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "004"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("delete: void");
    }

    @Override
    public void checkout(String docPath) throws OKMException {
        log.debug("checkout({})", (Object)docPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().checkout(null, docPath, new Boolean[0]);
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "004"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("checkout: void");
    }

    @Override
    public void cancelCheckout(String docPath) throws OKMException {
        log.debug("cancelCheckout({})", (Object)docPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().cancelCheckout(null, docPath);
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "004"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("cancelCheckout: void");
    }

    @Override
    public void lock(String docPath) throws OKMException {
        log.debug("lock({})", (Object)docPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().lock(null, docPath);
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "004"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("lock: void");
    }

    @Override
    public void unlock(String docPath) throws OKMException {
        log.debug("lock({})", (Object)docPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().unlock(null, docPath);
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "005"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("lock: void");
    }

    @Override
    public GWTDocument rename(String docPath, String newName) throws OKMException {
        log.debug("rename({}, {})", (Object)docPath, (Object)newName);
        GWTDocument gWTDocument = new GWTDocument();
        this.updateSessionManager();
        try {
            gWTDocument = GWTUtil.copy(OKMDocument.getInstance().rename(null, docPath, newName));
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "003"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("rename: {}", (Object)gWTDocument);
        return gWTDocument;
    }

    @Override
    public void move(String docPath, String destPath) throws OKMException {
        log.debug("move({}, {})", (Object)docPath, (Object)destPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().move(null, docPath, destPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "003"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("move: void");
    }

    @Override
    public void purge(String docPath) throws OKMException {
        log.debug("purge({})", (Object)docPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().purge(null, docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("purge: void");
    }

    @Override
    public void restoreVersion(String docPath, String versionId) throws OKMException {
        log.debug("restoreVersion({}, {})", (Object)docPath, (Object)versionId);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().restoreVersion(null, docPath, versionId);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("restoreVersion: void");
    }

    @Override
    public GWTDocument get(String docPath) throws OKMException {
        log.debug("get({})", (Object)docPath);
        GWTDocument gWTDocument = new GWTDocument();
        this.updateSessionManager();
        try {
            gWTDocument = GWTUtil.copy(OKMDocument.getInstance().getProperties(null, docPath));
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("get: {}", (Object)gWTDocument);
        return gWTDocument;
    }

    @Override
    public void copy(String docPath, String fldPath) throws OKMException {
        log.debug("copy({}, {})", (Object)docPath, (Object)fldPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().copy(null, docPath, fldPath);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "003"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "013"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("copy: void");
    }

    @Override
    public Boolean isValid(String docPath) throws OKMException {
        log.debug("isValid({})", (Object)docPath);
        this.updateSessionManager();
        try {
            return new Boolean(OKMDocument.getInstance().isValid(null, docPath));
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
    }

    @Override
    public Long getVersionHistorySize(String docPath) throws OKMException {
        log.debug("getVersionHistorySize({})", (Object)docPath);
        this.updateSessionManager();
        try {
            return new Long(OKMDocument.getInstance().getVersionHistorySize(null, docPath));
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
    }

    @Override
    public void purgeVersionHistory(String docPath) throws OKMException {
        log.debug("purgeVersionHistory({})", (Object)docPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().purgeVersionHistory(null, docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("purgeVersionHistory: void");
    }

    @Override
    public void forceUnlock(String docPath) throws OKMException {
        log.debug("forceUnlock({})", (Object)docPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().forceUnlock(null, docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("forceUnlock: void");
    }

    @Override
    public void forceCancelCheckout(String docPath) throws OKMException {
        log.debug("forceCancelCheckout({})", (Object)docPath);
        this.updateSessionManager();
        try {
            OKMDocument.getInstance().forceCancelCheckout(null, docPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("002", "006"), e.getMessage());
        }
        log.debug("forceCancelCheckout: void");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String createFromTemplate(String tplPath, String destinationPath, List<GWTFormElement> formProperties, Map<String, List<Map<String, String>>> tableProperties) throws OKMException {
        log.debug("createFromTemplate({}, {}, {})", new Object[]{tplPath, destinationPath, formProperties, tableProperties});
        this.updateSessionManager();
        File tmp = null;
        FileInputStream fis = null;
        try {
            Document docTpl = OKMDocument.getInstance().getProperties(null, tplPath);
            tmp = this.tmpFromTemplate(docTpl, formProperties, tableProperties);
            if (docTpl.getMimeType().equals("text/html")) {
                destinationPath = destinationPath.substring(0, destinationPath.lastIndexOf(".")) + ".pdf";
            }
            fis = new FileInputStream(tmp);
            Document newDoc = new Document();
            newDoc.setPath(destinationPath);
            newDoc = OKMDocument.getInstance().create(null, newDoc, fis);
            destinationPath = newDoc.getPath();
            for (PropertyGroup pg : OKMPropertyGroup.getInstance().getGroups(null, tplPath)) {
                OKMPropertyGroup.getInstance().addGroup(null, newDoc.getPath(), pg.getName());
                ArrayList<FormElement> properties = new ArrayList<FormElement>();
                for (FormElement fe : OKMPropertyGroup.getInstance().getProperties(null, newDoc.getPath(), pg.getName())) {
                    for (GWTFormElement fp : formProperties) {
                        if (!fe.getName().equals(fp.getName())) continue;
                        properties.add(GWTUtil.copy(fp));
                    }
                }
                OKMPropertyGroup.getInstance().setProperties(null, newDoc.getPath(), pg.getName(), properties);
            }
        }
        catch (IOException e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "013"), e.getMessage());
                catch (PathNotFoundException e2) {
                    log.warn(e2.getMessage(), (Throwable)e2);
                    throw new OKMException(ErrorCode.get("002", "015"), e2.getMessage());
                }
                catch (RepositoryException e3) {
                    log.error(e3.getMessage(), (Throwable)e3);
                    throw new OKMException(ErrorCode.get("002", "001"), e3.getMessage());
                }
                catch (DatabaseException e4) {
                    log.error(e4.getMessage(), (Throwable)e4);
                    throw new OKMException(ErrorCode.get("002", "024"), e4.getMessage());
                }
                catch (DocumentException e5) {
                    log.error(e5.getMessage(), (Throwable)e5);
                    throw new OKMException(ErrorCode.get("002", "030"), e5.getMessage());
                }
                catch (UnsupportedMimeTypeException e6) {
                    log.error(e6.getMessage(), (Throwable)e6);
                    throw new OKMException(ErrorCode.get("002", "010"), e6.getMessage());
                }
                catch (FileSizeExceededException e7) {
                    log.error(e7.getMessage(), (Throwable)e7);
                    throw new OKMException(ErrorCode.get("002", "011"), e7.getMessage());
                }
                catch (UserQuotaExceededException e8) {
                    log.error(e8.getMessage(), (Throwable)e8);
                    throw new OKMException(ErrorCode.get("002", "023"), e8.getMessage());
                }
                catch (VirusDetectedException e9) {
                    log.error(e9.getMessage(), (Throwable)e9);
                    throw new OKMException(ErrorCode.get("002", "032"), e9.getMessage());
                }
                catch (ItemExistsException e10) {
                    log.error(e10.getMessage(), (Throwable)e10);
                    throw new OKMException(ErrorCode.get("002", "003"), e10.getMessage());
                }
                catch (AccessDeniedException e11) {
                    log.error(e11.getMessage(), (Throwable)e11);
                    throw new OKMException(ErrorCode.get("002", "009"), e11.getMessage());
                }
                catch (DocumentTemplateException e12) {
                    log.error(e12.getMessage(), (Throwable)e12);
                    throw new OKMException(ErrorCode.get("002", "039"), e12.getMessage());
                }
                catch (ConversionException e13) {
                    log.error(e13.getMessage(), (Throwable)e13);
                    throw new OKMException(ErrorCode.get("002", "033"), e13.getMessage());
                }
                catch (TemplateException e14) {
                    log.error(e14.getMessage(), (Throwable)e14);
                    throw new OKMException(ErrorCode.get("002", "040"), e14.getMessage());
                }
                catch (ParseException e15) {
                    log.error(e15.getMessage(), (Throwable)e15);
                    throw new OKMException(ErrorCode.get("002", "019"), e15.getMessage());
                }
                catch (NoSuchGroupException e16) {
                    log.error(e16.getMessage(), (Throwable)e16);
                    throw new OKMException(ErrorCode.get("002", "012"), e16.getMessage());
                }
                catch (LockException e17) {
                    log.error(e17.getMessage(), (Throwable)e17);
                    throw new OKMException(ErrorCode.get("002", "004"), e17.getMessage());
                }
                catch (NoSuchPropertyException e18) {
                    log.error(e18.getMessage(), (Throwable)e18);
                    throw new OKMException(ErrorCode.get("002", "014"), e18.getMessage());
                }
                catch (ExtensionException e19) {
                    log.error(e19.getMessage(), (Throwable)e19);
                    throw new OKMException(ErrorCode.get("002", "041"), e19.getMessage());
                }
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(tmp);
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly(tmp);
        IOUtils.closeQuietly((InputStream)fis);
        log.debug("createFromTemplate: {}", (Object)destinationPath);
        return destinationPath;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String updateFromTemplate(String tplPath, String destinationPath, List<GWTFormElement> formProperties, Map<String, List<Map<String, String>>> tableProperties) throws OKMException {
        log.debug("updateFromTemplate({}, {}, {}, {})", new Object[]{tplPath, destinationPath, formProperties, tableProperties});
        this.updateSessionManager();
        FileInputStream fis = null;
        File tmp = null;
        try {
            Document docTpl = OKMDocument.getInstance().getProperties(null, tplPath);
            tmp = this.tmpFromTemplate(docTpl, formProperties, tableProperties);
            fis = new FileInputStream(tmp);
            OKMDocument.getInstance().checkout(null, destinationPath, new Boolean[0]);
            OKMDocument.getInstance().setContent(null, destinationPath, fis, tmp.length());
            OKMDocument.getInstance().checkin(null, destinationPath, "Updated from template", new Boolean[0]);
            for (PropertyGroup pg : OKMPropertyGroup.getInstance().getGroups(null, destinationPath)) {
                ArrayList<FormElement> properties = new ArrayList<FormElement>();
                for (FormElement fe : OKMPropertyGroup.getInstance().getProperties(null, destinationPath, pg.getName())) {
                    for (GWTFormElement fp : formProperties) {
                        if (!fe.getName().equals(fp.getName())) continue;
                        properties.add(GWTUtil.copy(fp));
                    }
                }
                OKMPropertyGroup.getInstance().setProperties(null, destinationPath, pg.getName(), properties);
            }
        }
        catch (IOException e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "013"), e.getMessage());
                catch (PathNotFoundException e2) {
                    log.warn(e2.getMessage(), (Throwable)e2);
                    throw new OKMException(ErrorCode.get("002", "015"), e2.getMessage());
                }
                catch (RepositoryException e3) {
                    log.error(e3.getMessage(), (Throwable)e3);
                    throw new OKMException(ErrorCode.get("002", "001"), e3.getMessage());
                }
                catch (DatabaseException e4) {
                    log.error(e4.getMessage(), (Throwable)e4);
                    throw new OKMException(ErrorCode.get("002", "024"), e4.getMessage());
                }
                catch (DocumentException e5) {
                    log.error(e5.getMessage(), (Throwable)e5);
                    throw new OKMException(ErrorCode.get("002", "030"), e5.getMessage());
                }
                catch (FileSizeExceededException e6) {
                    log.error(e6.getMessage(), (Throwable)e6);
                    throw new OKMException(ErrorCode.get("002", "011"), e6.getMessage());
                }
                catch (UserQuotaExceededException e7) {
                    log.error(e7.getMessage(), (Throwable)e7);
                    throw new OKMException(ErrorCode.get("002", "023"), e7.getMessage());
                }
                catch (VirusDetectedException e8) {
                    log.error(e8.getMessage(), (Throwable)e8);
                    throw new OKMException(ErrorCode.get("002", "032"), e8.getMessage());
                }
                catch (AccessDeniedException e9) {
                    log.error(e9.getMessage(), (Throwable)e9);
                    throw new OKMException(ErrorCode.get("002", "009"), e9.getMessage());
                }
                catch (ExtensionException e10) {
                    log.error(e10.getMessage(), (Throwable)e10);
                    throw new OKMException(ErrorCode.get("002", "041"), e10.getMessage());
                }
                catch (DocumentTemplateException e11) {
                    log.error(e11.getMessage(), (Throwable)e11);
                    throw new OKMException(ErrorCode.get("002", "039"), e11.getMessage());
                }
                catch (ConversionException e12) {
                    log.error(e12.getMessage(), (Throwable)e12);
                    throw new OKMException(ErrorCode.get("002", "033"), e12.getMessage());
                }
                catch (TemplateException e13) {
                    log.error(e13.getMessage(), (Throwable)e13);
                    throw new OKMException(ErrorCode.get("002", "040"), e13.getMessage());
                }
                catch (ParseException e14) {
                    log.error(e14.getMessage(), (Throwable)e14);
                    throw new OKMException(ErrorCode.get("002", "019"), e14.getMessage());
                }
                catch (NoSuchGroupException e15) {
                    log.error(e15.getMessage(), (Throwable)e15);
                    throw new OKMException(ErrorCode.get("002", "012"), e15.getMessage());
                }
                catch (LockException e16) {
                    log.error(e16.getMessage(), (Throwable)e16);
                    throw new OKMException(ErrorCode.get("002", "004"), e16.getMessage());
                }
                catch (NoSuchPropertyException e17) {
                    log.error(e17.getMessage(), (Throwable)e17);
                    throw new OKMException(ErrorCode.get("002", "014"), e17.getMessage());
                }
                catch (VersionException e18) {
                    log.error(e18.getMessage(), (Throwable)e18);
                    throw new OKMException(ErrorCode.get("002", "016"), e18.getMessage());
                }
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(tmp);
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly(tmp);
        IOUtils.closeQuietly((InputStream)fis);
        log.debug("updateFromTemplate: {}", (Object)destinationPath);
        return destinationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File tmpFromTemplate(Document docTpl, List<GWTFormElement> formProperties, Map<String, List<Map<String, String>>> tableProperties) throws PathNotFoundException, RepositoryException, IOException, DatabaseException, DocumentException, TemplateException, DocumentTemplateException, ConversionException {
        log.debug("tmpFromTemplate({}, {}, {})", new Object[]{docTpl, formProperties, tableProperties});
        FileOutputStream fos = null;
        InputStream fis = null;
        File tmp = null;
        try {
            fis = OKMDocument.getInstance().getContent(null, docTpl.getPath(), false);
            String fileName = JCRUtils.getName(docTpl.getPath());
            tmp = File.createTempFile("okm", "." + FileUtils.getFileExtension(fileName));
            fos = new FileOutputStream(tmp);
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (GWTFormElement formElement : formProperties) {
                String key = formElement.getName().replace(".", "_").replace(":", "_");
                Object value = GWTUtil.getFormElementValue(formElement);
                values.put(key, value);
            }
            for (String key : tableProperties.keySet()) {
                values.put(key, tableProperties.get(key));
            }
            if (docTpl.getMimeType().equals("application/pdf")) {
                PDFUtils.fillForm(fis, values, fos);
            } else if (docTpl.getMimeType().equals("application/vnd.oasis.opendocument.text")) {
                OOUtils.fillTemplate(fis, values, fos);
            } else if (docTpl.getMimeType().equals("text/html")) {
                TemplateUtils.replace(fileName, fis, values, fos);
                fis.close();
                fos.close();
                fis = new FileInputStream(tmp);
                File tmp2 = tmp;
                tmp = File.createTempFile("okm", ".pdf");
                DocConverter.getInstance().html2pdf(fis, tmp);
                tmp2.delete();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((OutputStream)fos);
        log.debug("tmpFromTemplate: {}", (Object)tmp);
        return tmp;
    }

    @Override
    public String convertToPdf(String docPath) throws OKMException {
        String destinationPath;
        block20: {
            log.debug("convertToPdf({})", (Object)docPath);
            this.updateSessionManager();
            destinationPath = "";
            InputStream is = null;
            try {
                String uuid = OKMRepository.getInstance().getNodeUuid(null, docPath);
                if (uuid.equals("")) break block20;
                File pdfCache = new File(Config.CACHE_PDF + File.separator + uuid + ".pdf");
                Document doc = OKMDocument.getInstance().getProperties(null, docPath);
                DocConverter converter = DocConverter.getInstance();
                is = OKMDocument.getInstance().getContent(null, docPath, false);
                if (!pdfCache.exists()) {
                    try {
                        File tmp = FileUtils.createTempFileFromMime(doc.getMimeType());
                        FileUtils.copy(is, tmp);
                        converter.doc2pdf(tmp, doc.getMimeType(), pdfCache);
                        tmp.delete();
                    }
                    catch (ConversionException e) {
                        pdfCache.delete();
                        log.error(e.getMessage(), (Throwable)e);
                        throw new OKMException(ErrorCode.get("002", "033"), e.getMessage());
                    }
                }
                is.close();
                is = new FileInputStream(pdfCache);
                doc = new Document();
                doc.setPath(JCRUtils.getParent(docPath) + "/" + FileUtils.getFileName(JCRUtils.getName(docPath)) + ".pdf");
                destinationPath = OKMDocument.getInstance().create(null, doc, is).getPath();
                is.close();
                for (PropertyGroup pg : OKMPropertyGroup.getInstance().getGroups(null, docPath)) {
                    OKMPropertyGroup.getInstance().addGroup(null, destinationPath, pg.getName());
                    List<FormElement> properties = OKMPropertyGroup.getInstance().getProperties(null, docPath, pg.getName());
                    OKMPropertyGroup.getInstance().setProperties(null, destinationPath, pg.getName(), properties);
                }
            }
            catch (PathNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "015"), e.getMessage());
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "001"), e.getMessage());
            }
            catch (DatabaseException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "024"), e.getMessage());
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "013"), e.getMessage());
            }
            catch (UnsupportedMimeTypeException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "010"), e.getMessage());
            }
            catch (FileSizeExceededException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "011"), e.getMessage());
            }
            catch (UserQuotaExceededException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "023"), e.getMessage());
            }
            catch (VirusDetectedException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "032"), e.getMessage());
            }
            catch (ItemExistsException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "003"), e.getMessage());
            }
            catch (AccessDeniedException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "009"), e.getMessage());
            }
            catch (ExtensionException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "041"), e.getMessage());
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "019"), e.getMessage());
            }
            catch (NoSuchPropertyException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "014"), e.getMessage());
            }
            catch (NoSuchGroupException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "012"), e.getMessage());
            }
            catch (LockException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("002", "004"), e.getMessage());
            }
        }
        log.debug("convertToPdf: {}", (Object)destinationPath);
        return destinationPath;
    }
}

