/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMDocument;
import com.openkm.api.OKMRepository;
import com.openkm.bean.Document;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.frontend.OKMHttpServlet;
import com.openkm.util.ArchiveUtils;
import com.openkm.util.WebUtils;
import com.openkm.util.impexp.RepositoryExporter;
import com.openkm.util.impexp.TextInfoDecorator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadServlet
extends OKMHttpServlet {
    private static Logger log = LoggerFactory.getLogger(DownloadServlet.class);
    private static final long serialVersionUID = 1L;
    private static final boolean exportZip = true;
    private static final boolean exportJar = false;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("service({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        String id = request.getParameter("id");
        String path = id != null ? new String(id.getBytes("ISO-8859-1"), "UTF-8") : null;
        String uuid = request.getParameter("uuid");
        String checkout = request.getParameter("checkout");
        String ver = request.getParameter("ver");
        boolean export = request.getParameter("export") != null;
        boolean inline = request.getParameter("inline") != null;
        File tmp = File.createTempFile("okm", ".tmp");
        Document doc = null;
        InputStream is = null;
        this.updateSessionManager(request);
        try {
            if (uuid != null && !uuid.equals("")) {
                path = OKMRepository.getInstance().getNodePath(null, uuid);
            }
            if (export) {
                FileOutputStream os = new FileOutputStream(tmp);
                this.exportZip(path, os);
                os.flush();
                os.close();
                is = new FileInputStream(tmp);
                String fileName = JCRUtils.getName(path) + ".zip";
                WebUtils.sendFile(request, response, fileName, "application/zip", inline, is);
            } else {
                doc = OKMDocument.getInstance().getProperties(null, path);
                is = ver != null && !ver.equals("") ? OKMDocument.getInstance().getContentByVersion(null, path, ver) : OKMDocument.getInstance().getContent(null, path, checkout != null);
                String fileName = JCRUtils.getName(doc.getPath());
                WebUtils.sendFile(request, response, fileName, doc.getMimeType(), inline, is);
            }
        }
        catch (PathNotFoundException e) {
            try {
                log.warn(e.getMessage(), (Throwable)e);
                throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "015"), e.getMessage()));
                catch (RepositoryException e2) {
                    log.warn(e2.getMessage(), (Throwable)e2);
                    throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "001"), e2.getMessage()));
                }
                catch (IOException e3) {
                    log.error(e3.getMessage(), (Throwable)e3);
                    throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "013"), e3.getMessage()));
                }
                catch (DatabaseException e4) {
                    log.error(e4.getMessage(), (Throwable)e4);
                    throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "024"), e4.getMessage()));
                }
                catch (Exception e5) {
                    log.error(e5.getMessage(), (Throwable)e5);
                    throw new ServletException((Throwable)new OKMException(ErrorCode.get("004", "006"), e5.getMessage()));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                com.openkm.util.FileUtils.deleteQuietly(tmp);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        com.openkm.util.FileUtils.deleteQuietly(tmp);
        log.debug("service: void");
    }

    private void exportZip(String path, OutputStream os) throws PathNotFoundException, AccessDeniedException, RepositoryException, ArchiveException, IOException, DatabaseException {
        log.debug("exportZip({}, {})", (Object)path, (Object)os);
        File tmp = null;
        try {
            tmp = com.openkm.util.FileUtils.createTempDir();
            StringWriter out = new StringWriter();
            RepositoryExporter.exportDocuments(null, path, tmp, false, out, new TextInfoDecorator(path));
            out.close();
            ArchiveUtils.createZip(tmp, JCRUtils.getName(path), os);
        }
        catch (IOException e) {
            log.error("Error exporting zip", (Throwable)e);
            throw e;
        }
        finally {
            if (tmp != null) {
                try {
                    FileUtils.deleteDirectory((File)tmp);
                }
                catch (IOException e) {
                    log.error("Error deleting temporal directory", (Throwable)e);
                    throw e;
                }
            }
        }
        log.debug("exportZip: void");
    }

    private void exportJar(String path, OutputStream os) throws PathNotFoundException, AccessDeniedException, RepositoryException, ArchiveException, IOException, DatabaseException {
        log.debug("exportJar({}, {})", (Object)path, (Object)os);
        File tmp = null;
        try {
            tmp = com.openkm.util.FileUtils.createTempDir();
            StringWriter out = new StringWriter();
            RepositoryExporter.exportDocuments(null, path, tmp, false, out, new TextInfoDecorator(path));
            out.close();
            ArchiveUtils.createJar(tmp, JCRUtils.getName(path), os);
        }
        catch (IOException e) {
            log.error("Error exporting jar", (Throwable)e);
            throw e;
        }
        finally {
            if (tmp != null) {
                try {
                    FileUtils.deleteDirectory((File)tmp);
                }
                catch (IOException e) {
                    log.error("Error deleting temporal directory", (Throwable)e);
                    throw e;
                }
            }
        }
        log.debug("exportJar: void");
    }
}

