/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import bsh.EvalError;
import com.ibm.icu.text.SimpleDateFormat;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Input;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.ReportDAO;
import com.openkm.dao.UserConfigDAO;
import com.openkm.dao.bean.Profile;
import com.openkm.dao.bean.Report;
import com.openkm.dao.bean.UserConfig;
import com.openkm.jcr.JCRUtils;
import com.openkm.util.ReportUtils;
import com.openkm.util.UserActivity;
import com.openkm.util.WebUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteReportServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExecuteReportServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug("doGet({}, {})", (Object)request, (Object)response);
        request.setCharacterEncoding("UTF-8");
        int id = WebUtils.getInt(request, "id");
        int format = WebUtils.getInt(request, "format", 2);
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        Session session = null;
        try {
            session = JCRUtils.getSession();
            UserConfig uc = UserConfigDAO.findByPk(session, request.getRemoteUser());
            Profile up = uc.getProfile();
            if (up.getMisc().getReports().contains(id)) {
                Report rp = ReportDAO.findByPk(id);
                String fileName = rp.getFileName().substring(0, rp.getFileName().indexOf(46)) + ReportUtils.FILE_EXTENSION[format];
                HashMap<String, Object> params = new HashMap<String, Object>();
                String host = Config.APPLICATION_URL;
                params.put("host", host.substring(0, host.lastIndexOf("/") + 1));
                for (FormElement fe : ReportUtils.getReportParameters(id)) {
                    if (fe instanceof Input && ((Input)fe).getType().equals("date")) {
                        String value = WebUtils.getString(request, fe.getName()).substring(0, 10);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        params.put(fe.getName(), sdf.parse(value));
                        continue;
                    }
                    params.put(fe.getName(), WebUtils.getString(request, fe.getName()));
                }
                baos = ReportUtils.execute(rp, params, format);
                bais = new ByteArrayInputStream(baos.toByteArray());
                WebUtils.sendFile(request, response, fileName, ReportUtils.FILE_MIME[format], false, bais);
                UserActivity.log(session.getUserID(), "EXECUTE_REPORT", Integer.toString(id), "OK");
            } else {
                UserActivity.log(session.getUserID(), "EXECUTE_REPORT", Integer.toString(id), "FAILURE");
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        catch (com.openkm.core.ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        catch (JRException e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        catch (EvalError e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        finally {
            JCRUtils.logout(session);
            IOUtils.closeQuietly(bais);
            IOUtils.closeQuietly(baos);
        }
    }
}

