/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMAuth;
import com.openkm.api.OKMDocument;
import com.openkm.api.OKMFolder;
import com.openkm.api.OKMNotification;
import com.openkm.api.OKMProperty;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.ConversionException;
import com.openkm.core.DatabaseException;
import com.openkm.core.FileSizeExceededException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UnsupportedMimeTypeException;
import com.openkm.core.VersionException;
import com.openkm.core.VirusDetectedException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.frontend.FileUploadListener;
import com.openkm.servlet.frontend.OKMHttpServlet;
import com.openkm.util.DocConverter;
import com.openkm.util.FileUtils;
import com.openkm.util.SecureStore;
import com.openkm.util.impexp.ImpExpStats;
import com.openkm.util.impexp.RepositoryImporter;
import com.openkm.util.impexp.TextInfoDecorator;
import de.schlichtherle.io.FileOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadServlet
extends OKMHttpServlet {
    private static Logger log = LoggerFactory.getLogger(FileUploadServlet.class);
    private static final long serialVersionUID = 1L;
    public static final int INSERT = 0;
    public static final int UPDATE = 1;
    private final String returnOKMessage = "OKM_OK";
    public static final String FILE_UPLOAD_STATUS = "file_upload_status";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FileUploadListener listener;
        String redirectURL;
        boolean redirect;
        String uploadedUuid;
        String uploadedDocPath;
        String message;
        String roles;
        String users;
        boolean notify;
        int action;
        block69: {
            PrintWriter out;
            String folder;
            String path;
            block72: {
                String cipherName;
                String comment;
                Long isSize;
                InputStream is;
                String fileName;
                block70: {
                    String erroMsg;
                    String mimeType;
                    boolean convertToPdf;
                    File tmp;
                    boolean importZip;
                    block71: {
                        Iterator it;
                        log.debug("doPost({}, {})", (Object)request, (Object)response);
                        fileName = null;
                        is = null;
                        isSize = null;
                        path = null;
                        action = 0;
                        notify = false;
                        importZip = false;
                        users = null;
                        roles = null;
                        message = null;
                        comment = null;
                        folder = null;
                        cipherName = null;
                        String rename = null;
                        out = null;
                        uploadedDocPath = null;
                        uploadedUuid = null;
                        tmp = null;
                        redirect = false;
                        convertToPdf = false;
                        redirectURL = "";
                        mimeType = "";
                        this.updateSessionManager(request);
                        try {
                            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
                            response.setContentType("text/plain");
                            out = response.getWriter();
                            log.debug("isMultipart: {}", (Object)isMultipart);
                            if (!isMultipart) {
                                int n = action = request.getParameter("action") != null ? Integer.parseInt(request.getParameter("action")) : -1;
                                if (action != 3) {
                                    if (action != 4) return;
                                }
                                path = request.getParameter("path");
                                String data = request.getParameter("data");
                                tmp = File.createTempFile("okm", ".tmp");
                                FileOutputStream fos = new FileOutputStream(tmp);
                                BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fos);
                                bos.write(SecureStore.b64Decode(data));
                                bos.flush();
                                bos.close();
                                fos.flush();
                                fos.close();
                                FileInputStream fis = new FileInputStream(tmp);
                                switch (action) {
                                    case 3: {
                                        Document newDoc = new Document();
                                        path = path.substring(0, path.lastIndexOf(".") + 1) + "pdf";
                                        newDoc.setPath(path);
                                        OKMDocument.getInstance().create(null, newDoc, fis);
                                        return;
                                    }
                                    case 4: {
                                        OKMDocument.getInstance().checkout(null, path, new Boolean[0]);
                                        OKMDocument.getInstance().setContent(null, path, fis, tmp.length());
                                        OKMDocument.getInstance().checkin(null, path, "Signed", new Boolean[0]);
                                        return;
                                    }
                                }
                                return;
                            }
                            DiskFileItemFactory factory = new DiskFileItemFactory();
                            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                            listener = new FileUploadListener();
                            request.getSession().setAttribute(FILE_UPLOAD_STATUS, (Object)listener);
                            upload.setHeaderEncoding("UTF-8");
                            upload.setProgressListener((ProgressListener)listener);
                            List items = upload.parseRequest(request);
                            it = items.iterator();
                        }
                        catch (AccessDeniedException e) {
                            log.warn(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "009"));
                            return;
                        }
                        catch (PathNotFoundException e) {
                            log.warn(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "015"));
                            return;
                        }
                        catch (ItemExistsException e) {
                            log.warn(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "003"));
                            return;
                        }
                        catch (UnsupportedMimeTypeException e) {
                            log.warn(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "010"));
                            return;
                        }
                        catch (FileSizeExceededException e) {
                            log.warn(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "011"));
                            return;
                        }
                        catch (VirusDetectedException e) {
                            log.warn(e.getMessage(), (Throwable)e);
                            out.print(VirusDetectedException.class.getSimpleName() + " : " + e.getMessage());
                            return;
                        }
                        catch (VersionException e) {
                            log.error(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "016"));
                            return;
                        }
                        catch (RepositoryException e) {
                            log.error(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "001"));
                            return;
                        }
                        catch (DatabaseException e) {
                            log.error(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "024"));
                            return;
                        }
                        catch (IOException e) {
                            log.error(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "013"));
                            return;
                        }
                        catch (ConversionException e) {
                            log.error(e.getMessage(), (Throwable)e);
                            out.print(ErrorCode.get("005", "033"));
                            return;
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            out.print(e.toString());
                            return;
                        }
                        finally {
                            if (tmp != null) {
                                tmp.delete();
                            }
                            IOUtils.closeQuietly(is);
                            out.flush();
                            IOUtils.closeQuietly((Writer)out);
                            System.gc();
                        }
                        while (it.hasNext()) {
                            FileItem item = (FileItem)it.next();
                            if (item.isFormField()) {
                                if (item.getFieldName().equals("path")) {
                                    path = item.getString("UTF-8");
                                }
                                if (item.getFieldName().equals("action")) {
                                    action = Integer.parseInt(item.getString("UTF-8"));
                                }
                                if (item.getFieldName().equals("users")) {
                                    users = item.getString("UTF-8");
                                }
                                if (item.getFieldName().equals("roles")) {
                                    roles = item.getString("UTF-8");
                                }
                                if (item.getFieldName().equals("notify")) {
                                    notify = true;
                                }
                                if (item.getFieldName().equals("importZip")) {
                                    importZip = true;
                                }
                                if (item.getFieldName().equals("message")) {
                                    message = item.getString("UTF-8");
                                }
                                if (item.getFieldName().equals("comment")) {
                                    comment = item.getString("UTF-8");
                                }
                                if (item.getFieldName().equals("folder")) {
                                    folder = item.getString("UTF-8");
                                }
                                if (item.getFieldName().equals("cipherName")) {
                                    cipherName = item.getString("UTF-8");
                                }
                                if (item.getFieldName().equals("rename")) {
                                    rename = item.getString("UTF-8");
                                }
                                if (item.getFieldName().equals("redirect")) {
                                    redirect = true;
                                    redirectURL = item.getString("UTF-8");
                                }
                                if (!item.getFieldName().equals("convertToPdf")) continue;
                                convertToPdf = true;
                                continue;
                            }
                            fileName = item.getName();
                            is = item.getInputStream();
                            isSize = item.getSize();
                            mimeType = item.getContentType();
                        }
                        log.info("Filename: '{}'", fileName);
                        if (rename != null && !rename.equals("")) {
                            String ext;
                            log.info("Rename: '{}'", (Object)rename);
                            fileName = FilenameUtils.indexOfExtension((String)rename) > -1 ? rename : ((ext = FilenameUtils.getExtension((String)fileName)).equals("") ? rename : rename + "." + ext);
                            log.info("Filename: '{}'", (Object)fileName);
                        }
                        if (action != 0) break block70;
                        if (fileName == null || fileName.equals("")) break block69;
                        if (!importZip || !FilenameUtils.getExtension((String)fileName).equalsIgnoreCase("zip")) break block71;
                        log.info("Import zip file '{}' into '{}'", (Object)fileName, (Object)path);
                        erroMsg = this.importZip(path, is);
                        if (erroMsg == null) {
                            out.print("OKM_OK");
                            break block69;
                        } else {
                            log.warn("erroMsg: {}", (Object)erroMsg);
                            out.print(erroMsg);
                        }
                        break block69;
                    }
                    if (importZip && FilenameUtils.getExtension((String)fileName).equalsIgnoreCase("jar")) {
                        log.info("Import jar file '{}' into '{}'", (Object)fileName, (Object)path);
                        erroMsg = this.importJar(path, is);
                        if (erroMsg == null) {
                            out.print("OKM_OK");
                            break block69;
                        } else {
                            log.warn("erroMsg: {}", (Object)erroMsg);
                            out.print(erroMsg);
                        }
                        break block69;
                    } else {
                        fileName = FilenameUtils.getName((String)fileName);
                        log.info("Upload file '{}' into '{}'", (Object)fileName, (Object)path);
                        Document doc = new Document();
                        doc.setPath(path + "/" + fileName);
                        if (convertToPdf && !mimeType.equals("application/pdf")) {
                            DocConverter converter = DocConverter.getInstance();
                            if (!converter.convertibleToPdf(mimeType)) throw new ConversionException("Not convertible to pdf");
                            fileName = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".") + 1) + "pdf" : fileName + ".pdf";
                            doc.setPath(path + "/" + fileName);
                            tmp = de.schlichtherle.io.File.createTempFile((String)"okm", (String)".tmp");
                            File tmpPdf = de.schlichtherle.io.File.createTempFile((String)"okm", (String)".pdf");
                            FileOutputStream fos = new FileOutputStream(tmp);
                            IOUtils.copy((InputStream)is, (OutputStream)fos);
                            converter.doc2pdf(tmp, mimeType, tmpPdf);
                            is = new FileInputStream(tmpPdf);
                            doc = OKMDocument.getInstance().create(null, doc, is);
                            uploadedDocPath = doc.getPath();
                            uploadedUuid = doc.getUuid();
                            tmp.delete();
                            tmpPdf.delete();
                            tmp = null;
                        } else {
                            doc = OKMDocument.getInstance().create(null, doc, is);
                            uploadedDocPath = doc.getPath();
                            uploadedUuid = doc.getUuid();
                        }
                        if (cipherName != null && !cipherName.equals("")) {
                            OKMProperty.getInstance().setEncryption(null, doc.getPath(), cipherName);
                        }
                        out.print("OKM_OK path[" + URLEncoder.encode(uploadedDocPath, "UTF-8") + "]path uuid[" + uploadedUuid + "]uuid");
                    }
                    break block69;
                }
                if (action != 1) break block72;
                log.info("File updated: {}", (Object)path);
                if (!Config.SYSTEM_DOCUMENT_NAME_MISMATCH_CHECK || JCRUtils.getName(path).equals(fileName)) {
                    OKMDocument document = OKMDocument.getInstance();
                    Document doc = document.getProperties(null, path);
                    document.setContent(null, path, is, isSize);
                    document.checkin(null, path, comment, new Boolean[0]);
                    uploadedDocPath = path;
                    uploadedUuid = doc.getUuid();
                    if (cipherName != null && !cipherName.equals("")) {
                        if (doc.getCipherName() == null) {
                            OKMProperty.getInstance().setEncryption(null, path, cipherName);
                            document.purgeVersionHistory(null, path);
                        }
                    } else if (doc.getCipherName() != null && !doc.getCipherName().equals("")) {
                        OKMProperty.getInstance().unsetEncryption(null, path);
                        document.purgeVersionHistory(null, path);
                    }
                    out.print("OKM_OK path[" + URLEncoder.encode(uploadedDocPath, "UTF-8") + "]path uuid[" + uploadedUuid + "]uuid");
                    break block69;
                } else {
                    out.print(ErrorCode.get("005", "027"));
                }
                break block69;
            }
            if (action == 2) {
                log.info("Folder create: {}", (Object)path);
                Folder fld = new Folder();
                fld.setPath(path + "/" + folder);
                OKMFolder.getInstance().create(null, fld);
                out.print("OKM_OK");
            }
        }
        listener.setUploadFinish(true);
        if ((action == 0 || action == 1) & notify) {
            ArrayList<String> userNames = new ArrayList<String>(Arrays.asList(users.split(",")));
            List<String> roleNames = Arrays.asList(roles.split(","));
            for (String role : roleNames) {
                List<String> usersInRole = OKMAuth.getInstance().getUsersByRole(null, role);
                for (String user : usersInRole) {
                    if (userNames.contains(user)) continue;
                    userNames.add(user);
                }
            }
            OKMNotification.getInstance().notify(null, uploadedDocPath, userNames, message, false);
        }
        if (!redirect) return;
        ServletContext sc = this.getServletContext();
        request.setAttribute("docPath", uploadedDocPath);
        request.setAttribute("uuid", uploadedUuid);
        sc.setAttribute("docPath", uploadedDocPath);
        sc.setAttribute("uuid", uploadedUuid);
        sc.getRequestDispatcher(redirectURL).forward((ServletRequest)request, (ServletResponse)response);
    }

    private synchronized String importZip(String path, InputStream is) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.debug("importZip({}, {})", (Object)path, (Object)is);
        File tmpIn = null;
        File tmpOut = null;
        String errorMsg = null;
        try {
            tmpIn = de.schlichtherle.io.File.createTempFile((String)"okm", (String)".zip");
            tmpOut = FileUtils.createTempDir();
            FileOutputStream fos = new FileOutputStream(tmpIn);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            fos.close();
            de.schlichtherle.io.File fileTmpIn = new de.schlichtherle.io.File(tmpIn);
            fileTmpIn.archiveCopyAllTo(tmpOut);
            de.schlichtherle.io.File.umount();
            StringWriter out = new StringWriter();
            ImpExpStats stats = RepositoryImporter.importDocuments(null, tmpOut, path, false, false, out, new TextInfoDecorator(tmpOut));
            if (!stats.isOk()) {
                errorMsg = out.toString();
            }
            out.close();
        }
        catch (IOException e) {
            log.error("Error importing zip", (Throwable)e);
            throw e;
        }
        finally {
            if (tmpIn != null) {
                org.apache.commons.io.FileUtils.deleteQuietly((File)tmpIn);
            }
            if (tmpOut != null) {
                org.apache.commons.io.FileUtils.deleteQuietly((File)tmpOut);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("Error closing zip input stream", (Throwable)e);
                    throw e;
                }
            }
        }
        log.debug("importZip: {}", (Object)errorMsg);
        return errorMsg;
    }

    private String importJar(String path, InputStream is) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.debug("importJar({}, {})", (Object)path, (Object)is);
        File tmpIn = null;
        File tmpOut = null;
        String errorMsg = null;
        try {
            tmpIn = de.schlichtherle.io.File.createTempFile((String)"okm", (String)".jar");
            tmpOut = FileUtils.createTempDir();
            FileOutputStream fos = new FileOutputStream(tmpIn);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            fos.close();
            de.schlichtherle.io.File fileTmpIn = new de.schlichtherle.io.File(tmpIn);
            fileTmpIn.archiveCopyAllTo(tmpOut);
            StringWriter out = new StringWriter();
            ImpExpStats stats = RepositoryImporter.importDocuments(null, tmpOut, path, false, false, out, new TextInfoDecorator(tmpOut));
            if (!stats.isOk()) {
                errorMsg = out.toString();
            }
            out.close();
        }
        catch (IOException e) {
            log.error("Error importing jar", (Throwable)e);
            throw e;
        }
        finally {
            if (tmpIn != null) {
                de.schlichtherle.io.File.umount();
                org.apache.commons.io.FileUtils.deleteQuietly((File)tmpIn);
            }
            if (tmpOut != null) {
                org.apache.commons.io.FileUtils.deleteQuietly((File)tmpOut);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("Error closing zip input stream", (Throwable)e);
                    throw e;
                }
            }
        }
        log.debug("importJar: {}", (Object)errorMsg);
        return errorMsg;
    }
}

