/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMFolder;
import com.openkm.bean.Folder;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMFolderService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.servlet.frontend.util.FolderComparator;
import com.openkm.util.GWTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderServlet
extends OKMRemoteServiceServlet
implements OKMFolderService {
    private static Logger log = LoggerFactory.getLogger(FolderServlet.class);
    private static final long serialVersionUID = -4436438730167948558L;

    @Override
    public GWTFolder create(String fldPath, String fldPathParent) throws OKMException {
        log.debug("create({}, {})", (Object)fldPath, (Object)fldPathParent);
        GWTFolder gWTFolder = new GWTFolder();
        Folder folder = new Folder();
        folder.setPath(fldPathParent + "/" + fldPath);
        this.updateSessionManager();
        try {
            gWTFolder = GWTUtil.copy(OKMFolder.getInstance().create(null, folder));
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "003"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "006"), e.getMessage());
        }
        log.debug("create: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public void delete(String fldPath) throws OKMException {
        log.debug("delete({})", (Object)fldPath);
        this.updateSessionManager();
        try {
            OKMFolder.getInstance().delete(null, fldPath);
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "004"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "006"), e.getMessage());
        }
        log.debug("delete: void");
    }

    @Override
    public List<GWTFolder> getChilds(String fldPath) throws OKMException {
        log.debug("getFolderChilds({})", (Object)fldPath);
        ArrayList<GWTFolder> folderList = new ArrayList<GWTFolder>();
        this.updateSessionManager();
        try {
            log.debug("ParentFolder: {}", (Object)fldPath);
            List<Folder> col = OKMFolder.getInstance().getChilds(null, fldPath);
            for (Folder folder : col) {
                GWTFolder gWTFolder = GWTUtil.copy(folder);
                folderList.add(gWTFolder);
            }
            Collections.sort(folderList, FolderComparator.getInstance(this.getLanguage()));
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "001"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "015"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "006"), e.getMessage());
        }
        log.debug("getFolderChilds: {}", folderList);
        return folderList;
    }

    @Override
    public GWTFolder rename(String fldId, String newName) throws OKMException {
        log.debug("rename({}, {})", (Object)fldId, (Object)newName);
        GWTFolder gWTFolder = new GWTFolder();
        this.updateSessionManager();
        try {
            gWTFolder = GWTUtil.copy(OKMFolder.getInstance().rename(null, fldId, newName));
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "003"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "006"), e.getMessage());
        }
        log.debug("rename: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public void move(String fldPath, String dstPath) throws OKMException {
        log.debug("move({}, {})", (Object)fldPath, (Object)dstPath);
        this.updateSessionManager();
        try {
            OKMFolder.getInstance().move(null, fldPath, dstPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "009"), e.getMessage());
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "003"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "006"), e.getMessage());
        }
        log.debug("move: void");
    }

    @Override
    public void purge(String fldPath) throws OKMException {
        log.debug("purge({})", (Object)fldPath);
        this.updateSessionManager();
        try {
            OKMFolder.getInstance().purge(null, fldPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "006"), e.getMessage());
        }
        log.debug("purge: void");
    }

    @Override
    public GWTFolder getProperties(String fldPath) throws OKMException {
        log.debug("getProperties({})", (Object)fldPath);
        GWTFolder gWTFolder = new GWTFolder();
        this.updateSessionManager();
        try {
            gWTFolder = GWTUtil.copy(OKMFolder.getInstance().getProperties(null, fldPath));
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "006"), e.getMessage());
        }
        log.debug("getProperties: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public void copy(String fldPath, String dstPath) throws OKMException {
        log.debug("copy({}, {})", (Object)fldPath, (Object)dstPath);
        this.updateSessionManager();
        try {
            OKMFolder.getInstance().copy(null, fldPath, dstPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "009"), e.getMessage());
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "003"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "006"), e.getMessage());
        }
        log.debug("copy: void");
    }

    @Override
    public Boolean isValid(String fldPath) throws OKMException {
        log.debug("isValid({})", (Object)fldPath);
        this.updateSessionManager();
        try {
            return OKMFolder.getInstance().isValid(null, fldPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("001", "006"), e.getMessage());
        }
    }
}

