/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.core.DatabaseException;
import com.openkm.dao.UserConfigDAO;
import com.openkm.dao.bean.MailAccount;
import com.openkm.dao.bean.Profile;
import com.openkm.dao.bean.UserConfig;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTFileUploadingStatus;
import com.openkm.frontend.client.bean.GWTTestImap;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMGeneralService;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.frontend.FileUploadListener;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.MailUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralServlet
extends OKMRemoteServiceServlet
implements OKMGeneralService {
    private static Logger log = LoggerFactory.getLogger(GeneralServlet.class);
    private static final long serialVersionUID = -879908904295685769L;

    @Override
    public GWTFileUploadingStatus getFileUploadStatus() {
        log.debug("getFileUploadStatus()");
        GWTFileUploadingStatus fus = new GWTFileUploadingStatus();
        this.updateSessionManager();
        if (this.getThreadLocalRequest().getSession().getAttribute("file_upload_status") != null) {
            FileUploadListener listener = (FileUploadListener)this.getThreadLocalRequest().getSession().getAttribute("file_upload_status");
            fus.setStarted(true);
            fus.setBytesRead(listener.getBytesRead());
            fus.setContentLength(listener.getContentLength());
            fus.setUploadFinish(listener.isUploadFinish());
            if (listener.getBytesRead() == listener.getContentLength() || listener.isUploadFinish()) {
                this.getThreadLocalRequest().getSession().removeAttribute("file_upload_status");
            }
        }
        log.debug("getFileUploadStatus: {}", (Object)fus);
        return fus;
    }

    @Override
    public GWTTestImap testImapConnection(String host, String user, String password, String imapFolder) {
        log.debug("testImapConnection({}, {}, {}, {})", new Object[]{host, user, password, imapFolder});
        GWTTestImap test = new GWTTestImap();
        this.updateSessionManager();
        try {
            test.setError(false);
            MailAccount ma = new MailAccount();
            ma.setMailProtocol("imap");
            ma.setMailHost(host);
            ma.setMailUser(user);
            ma.setMailPassword(password);
            ma.setMailFolder(imapFolder);
            ma.setMailMarkSeen(true);
            MailUtils.testConnection(ma);
        }
        catch (IOException e) {
            test.setError(true);
            test.setErrorMsg(e.getMessage());
            e.printStackTrace();
        }
        log.debug("testImapConnection: {}", (Object)test);
        return test;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getEnabledExtensions() throws OKMException {
        ArrayList<String> extensions = new ArrayList();
        Session session = null;
        try {
            Profile up = new Profile();
            session = JCRUtils.getSession();
            UserConfig uc = UserConfigDAO.findByPk(session, session.getUserID());
            up = uc.getProfile();
            extensions = new ArrayList<String>(up.getMisc().getExtensions());
        }
        catch (LoginException e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("022", "001"), e.getMessage());
                catch (RepositoryException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    throw new OKMException(ErrorCode.get("022", "001"), e2.getMessage());
                }
                catch (DatabaseException e3) {
                    log.warn(e3.getMessage(), (Throwable)e3);
                    throw new OKMException(ErrorCode.get("022", "024"), e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                JCRUtils.logout(session);
                throw throwable;
            }
        }
        JCRUtils.logout(session);
        return extensions;
    }
}

