/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.core.DatabaseException;
import com.openkm.dao.KeyValueDAO;
import com.openkm.dao.bean.KeyValue;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTKeyValue;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMKeyValueService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueServlet
extends OKMRemoteServiceServlet
implements OKMKeyValueService {
    private static Logger log = LoggerFactory.getLogger(KeyValueServlet.class);
    private static final long serialVersionUID = -7747765621446287017L;

    @Override
    public List<GWTKeyValue> getKeyValues(List<String> tables, String query) throws OKMException {
        log.debug("getKeyValues({},{}})", tables, (Object)query);
        this.updateSessionManager();
        ArrayList<GWTKeyValue> keyValues = new ArrayList<GWTKeyValue>();
        try {
            for (KeyValue keyValue : KeyValueDAO.getKeyValues(tables, query)) {
                keyValues.add(GWTUtil.copy(keyValue));
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("033", "024"), e.getMessage());
        }
        log.debug("executeValueQuery: {}", keyValues);
        return keyValues;
    }
}

