/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.core.DatabaseException;
import com.openkm.dao.LanguageDAO;
import com.openkm.dao.bean.Language;
import com.openkm.dao.bean.Translation;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMLanguageService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageServlet
extends OKMRemoteServiceServlet
implements OKMLanguageService {
    private static Logger log = LoggerFactory.getLogger(LanguageServlet.class);
    private static final long serialVersionUID = -879908904295685769L;

    @Override
    public Map<String, String> getFrontEndTranslations(String lang) throws OKMException {
        HashMap<String, String> translations;
        block7: {
            log.debug("getTranslations({})", (Object)lang);
            translations = new HashMap<String, String>();
            this.setLanguage(lang);
            try {
                String key;
                Language baseLang = LanguageDAO.findByPk("en-GB");
                Language language = LanguageDAO.findByPk(lang);
                HashMap<String, String> keys = new HashMap<String, String>();
                if (language != null) {
                    for (Translation translation : language.getTranslations()) {
                        key = translation.getTranslationId().getModule() + "." + translation.getTranslationId().getKey();
                        keys.put(key, translation.getText());
                    }
                }
                if (baseLang != null) {
                    for (Translation translation : baseLang.getTranslations()) {
                        if (!translation.getTranslationId().getModule().equals("frontend") && !translation.getTranslationId().getModule().equals("extension")) continue;
                        key = translation.getTranslationId().getModule() + "." + translation.getTranslationId().getKey();
                        if (keys.keySet().contains(key)) {
                            translations.put(key, (String)keys.get(key));
                            continue;
                        }
                        translations.put(key, translation.getText());
                    }
                    break block7;
                }
                throw new OKMException(ErrorCode.get("022", "024"), "English traslation is mandatory can not be deleted");
            }
            catch (DatabaseException e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new OKMException(ErrorCode.get("022", "024"), e.getMessage());
            }
        }
        log.debug("getTranslations: {}", translations);
        return translations;
    }

    public void getLanguages() {
    }
}

