/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMMail;
import com.openkm.api.OKMRepository;
import com.openkm.bean.Mail;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMMailService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServlet
extends OKMRemoteServiceServlet
implements OKMMailService {
    private static Logger log = LoggerFactory.getLogger(MailServlet.class);
    private static final long serialVersionUID = 6444705787188086209L;

    @Override
    public List<GWTMail> getChilds(String fldPath) throws OKMException {
        log.debug("getChilds({})", (Object)fldPath);
        ArrayList<GWTMail> mailList = new ArrayList<GWTMail>();
        this.updateSessionManager();
        try {
            if (fldPath == null) {
                fldPath = OKMRepository.getInstance().getMailFolder(null).getPath();
            }
            log.debug("ParentFolder: {}", (Object)fldPath);
            List<Mail> col = OKMMail.getInstance().getChilds(null, fldPath);
            for (Mail mail : col) {
                log.debug("Mail: {}", (Object)mail);
                GWTMail mailClient = GWTUtil.copy(mail);
                mailList.add(mailClient);
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "006"), e.getMessage());
        }
        log.debug("getChilds: {}", mailList);
        return mailList;
    }

    @Override
    public void delete(String mailPath) throws OKMException {
        log.debug("delete({})", (Object)mailPath);
        this.updateSessionManager();
        try {
            OKMMail.getInstance().delete(null, mailPath);
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "004"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "006"), e.getMessage());
        }
        log.debug("delete: void");
    }

    @Override
    public void move(String mailPath, String destPath) throws OKMException {
        log.debug("move({}, {})", (Object)mailPath, (Object)destPath);
        this.updateSessionManager();
        try {
            OKMMail.getInstance().move(null, mailPath, destPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "015"), e.getMessage());
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "003"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "006"), e.getMessage());
        }
        log.debug("move: void");
    }

    @Override
    public void purge(String mailPath) throws OKMException {
        log.debug("purge({})", (Object)mailPath);
        this.updateSessionManager();
        try {
            OKMMail.getInstance().purge(null, mailPath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "006"), e.getMessage());
        }
        log.debug("purge: void");
    }

    @Override
    public void copy(String mailPath, String fldPath) throws OKMException {
        log.debug("copy({}, {})", (Object)mailPath, (Object)fldPath);
        this.updateSessionManager();
        try {
            OKMMail.getInstance().copy(null, mailPath, fldPath);
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "003"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "001"), e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "013"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "006"), e.getMessage());
        }
        log.debug("copy: void");
    }

    @Override
    public GWTMail getProperties(String mailPath) throws OKMException {
        log.debug("getProperties({})", (Object)mailPath);
        GWTMail mailClient = new GWTMail();
        this.updateSessionManager();
        try {
            mailClient = GWTUtil.copy(OKMMail.getInstance().getProperties(null, mailPath));
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "006"), e.getMessage());
        }
        log.debug("copy: getProperties");
        return mailClient;
    }

    @Override
    public GWTMail rename(String mailId, String newName) throws OKMException {
        log.debug("rename({}, {})", (Object)mailId, (Object)newName);
        GWTMail gWTMail = new GWTMail();
        this.updateSessionManager();
        try {
            gWTMail = GWTUtil.copy(OKMMail.getInstance().rename(null, mailId, newName));
        }
        catch (ItemExistsException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "003"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("016", "006"), e.getMessage());
        }
        log.debug("rename: {}", (Object)gWTMail);
        return gWTMail;
    }
}

