/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMNote;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTNote;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMNoteService;
import com.openkm.servlet.frontend.DocumentServlet;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoteServlet
extends OKMRemoteServiceServlet
implements OKMNoteService {
    private static Logger log = LoggerFactory.getLogger(DocumentServlet.class);
    private static final long serialVersionUID = 5746571509174291745L;

    @Override
    public GWTNote add(String nodePath, String text) throws OKMException {
        log.debug("add({}, {})", (Object)nodePath, (Object)text);
        this.updateSessionManager();
        try {
            return GWTUtil.copy(OKMNote.getInstance().add(null, nodePath, text));
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "006"), e.getMessage());
        }
    }

    @Override
    public void remove(String notePath) throws OKMException {
        log.debug("remove({})", (Object)notePath);
        try {
            OKMNote.getInstance().remove(null, notePath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "006"), e.getMessage());
        }
        log.debug("remove: void");
    }

    @Override
    public void set(String notePath, String text) throws OKMException {
        log.debug("set({}, {})", (Object)notePath, (Object)text);
        try {
            OKMNote.getInstance().set(null, notePath, text);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("020", "006"), e.getMessage());
        }
        log.debug("set: void");
    }
}

