/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMAuth;
import com.openkm.api.OKMNotification;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMNotifyService;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.servlet.frontend.FolderServlet;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyServlet
extends OKMRemoteServiceServlet
implements OKMNotifyService {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(FolderServlet.class);

    @Override
    public void subscribe(String nodePath) throws OKMException {
        log.debug("subscribe({})", (Object)nodePath);
        this.updateSessionManager();
        try {
            OKMNotification.getInstance().subscribe(null, nodePath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "006"), e.getMessage());
        }
        log.debug("subscribe: void");
    }

    @Override
    public void unsubscribe(String nodePath) throws OKMException {
        log.debug("subscribe({})", (Object)nodePath);
        this.updateSessionManager();
        try {
            OKMNotification.getInstance().unsubscribe(null, nodePath);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "006"), e.getMessage());
        }
        log.debug("subscribe: void");
    }

    @Override
    public void notify(String docPath, String users, String roles, String message, boolean attachment) throws OKMException {
        log.debug("notify({}, {}, {}, {})", new Object[]{docPath, users, roles, message, attachment});
        this.updateSessionManager();
        try {
            ArrayList<String> userNames = new ArrayList<String>(Arrays.asList(users.split(",")));
            List<String> roleNames = Arrays.asList(roles.split(","));
            for (String role : roleNames) {
                List<String> usersInRole = OKMAuth.getInstance().getUsersByRole(null, role);
                for (String user : usersInRole) {
                    if (userNames.contains(user)) continue;
                    userNames.add(user);
                }
            }
            OKMNotification.getInstance().notify(null, docPath, userNames, message, attachment);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "001"), e.getMessage());
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("010", "025"), e.getMessage());
        }
        log.debug("notify: void");
    }
}

