/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMPropertyGroup;
import com.openkm.bean.PropertyGroup;
import com.openkm.bean.form.FormElement;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.LockException;
import com.openkm.core.NoSuchGroupException;
import com.openkm.core.NoSuchPropertyException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMPropertyGroupService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyGroupServlet
extends OKMRemoteServiceServlet
implements OKMPropertyGroupService {
    private static Logger log = LoggerFactory.getLogger(PropertyGroupServlet.class);
    private static final long serialVersionUID = 2638205115826644606L;

    @Override
    public List<GWTPropertyGroup> getAllGroups() throws OKMException {
        log.debug("getAllGroups()");
        ArrayList<GWTPropertyGroup> groupList = new ArrayList<GWTPropertyGroup>();
        this.updateSessionManager();
        try {
            List<PropertyGroup> col = OKMPropertyGroup.getInstance().getAllGroups(null);
            for (PropertyGroup pg : col) {
                if (!pg.isVisible()) continue;
                GWTPropertyGroup group = GWTUtil.copy(pg);
                groupList.add(group);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "006"), e.getMessage());
        }
        log.debug("getAllGroups: {}", groupList);
        return groupList;
    }

    @Override
    public List<GWTPropertyGroup> getAllGroups(String path) throws OKMException {
        log.debug("getAllGroups({})", (Object)path);
        ArrayList<GWTPropertyGroup> groupList = new ArrayList<GWTPropertyGroup>();
        this.updateSessionManager();
        try {
            List<PropertyGroup> col = OKMPropertyGroup.getInstance().getAllGroups(null);
            List<GWTPropertyGroup> actualGroupsList = this.getGroups(path);
            for (PropertyGroup pg : col) {
                if (!pg.isVisible()) continue;
                GWTPropertyGroup group = GWTUtil.copy(pg);
                groupList.add(group);
            }
            if (!actualGroupsList.isEmpty()) {
                block6: for (GWTPropertyGroup group : actualGroupsList) {
                    for (GWTPropertyGroup groupListElement : groupList) {
                        if (!groupListElement.getName().equals(group.getName())) continue;
                        groupList.remove(groupListElement);
                        continue block6;
                    }
                }
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "001"), e.getMessage());
        }
        catch (OKMException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "006"), e.getMessage());
        }
        log.debug("getAllGroups: {}", groupList);
        return groupList;
    }

    @Override
    public void addGroup(String path, String grpName) throws OKMException {
        log.debug("addGroup({}, {})", (Object)path, (Object)grpName);
        this.updateSessionManager();
        try {
            OKMPropertyGroup.getInstance().addGroup(null, path, grpName);
        }
        catch (NoSuchGroupException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "012"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "009"), e.getMessage());
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "004"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "006"), e.getMessage());
        }
        log.debug("addGroup: void");
    }

    @Override
    public List<GWTPropertyGroup> getGroups(String path) throws OKMException {
        log.debug("getGroups({})", (Object)path);
        ArrayList<GWTPropertyGroup> groupList = new ArrayList<GWTPropertyGroup>();
        this.updateSessionManager();
        try {
            List<PropertyGroup> col = OKMPropertyGroup.getInstance().getGroups(null, path);
            for (PropertyGroup pg : col) {
                if (!pg.isVisible()) continue;
                GWTPropertyGroup group = GWTUtil.copy(pg);
                groupList.add(group);
            }
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "006"), e.getMessage());
        }
        log.debug("getGroups: {}", groupList);
        return groupList;
    }

    @Override
    public List<GWTFormElement> getProperties(String path, String grpName) throws OKMException {
        log.debug("getProperties({}, {})", (Object)path, (Object)grpName);
        ArrayList<GWTFormElement> properties = new ArrayList<GWTFormElement>();
        this.updateSessionManager();
        try {
            Iterator<FormElement> it = OKMPropertyGroup.getInstance().getProperties(null, path, grpName).iterator();
            while (it.hasNext()) {
                properties.add(GWTUtil.copy(it.next()));
            }
        }
        catch (NoSuchGroupException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "012"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "006"), e.getMessage());
        }
        log.debug("getProperties: {}", properties);
        return properties;
    }

    @Override
    public List<GWTFormElement> getPropertyGroupForm(String grpName) throws OKMException {
        log.debug("getPropertyGroupForm({})", (Object)grpName);
        List<Object> properties = new ArrayList();
        ArrayList<GWTFormElement> gwtProperties = new ArrayList<GWTFormElement>();
        this.updateSessionManager();
        try {
            properties = OKMPropertyGroup.getInstance().getPropertyGroupForm(null, grpName);
            Iterator<Object> it = properties.iterator();
            while (it.hasNext()) {
                gwtProperties.add(GWTUtil.copy((FormElement)it.next()));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "013"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "006"), e.getMessage());
        }
        log.debug("getPropertyGroupForm: {}", gwtProperties);
        return gwtProperties;
    }

    @Override
    public void setProperties(String path, String grpName, List<GWTFormElement> formProperties) throws OKMException {
        log.debug("setProperties({}, {}, {})", new Object[]{path, grpName, formProperties});
        this.updateSessionManager();
        try {
            ArrayList<FormElement> properties = new ArrayList<FormElement>();
            Iterator<GWTFormElement> it = formProperties.iterator();
            while (it.hasNext()) {
                properties.add(GWTUtil.copy(it.next()));
            }
            OKMPropertyGroup.getInstance().setProperties(null, path, grpName, properties);
        }
        catch (NoSuchPropertyException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "014"), e.getMessage());
        }
        catch (NoSuchGroupException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "012"), e.getMessage());
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "004"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "015"), e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "006"), e.getMessage());
        }
        log.debug("setProperties: void");
    }

    @Override
    public void removeGroup(String path, String grpName) throws OKMException {
        log.debug("removeGroup({}, {})", (Object)path, (Object)grpName);
        this.updateSessionManager();
        try {
            OKMPropertyGroup.getInstance().removeGroup(null, path, grpName);
        }
        catch (NoSuchGroupException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "012"), e.getMessage());
        }
        catch (LockException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "004"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("009", "006"), e.getMessage());
        }
        log.debug("removeGroup: void");
    }
}

