/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMRepository;
import com.openkm.bean.Folder;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMRepositoryService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryServlet
extends OKMRemoteServiceServlet
implements OKMRepositoryService {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(RepositoryServlet.class);

    @Override
    public String getUpdateMessage() throws OKMException {
        log.debug("getUpdateMessage()");
        String msg = "";
        this.updateSessionManager();
        try {
            msg = OKMRepository.getInstance().getUpdateMessage(null);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "006"), e.getMessage());
        }
        log.debug("getUpdateMessage: {}", (Object)msg);
        return msg;
    }

    @Override
    public GWTFolder getPersonalFolder() throws OKMException {
        log.debug("getPersonalFolder()");
        GWTFolder gWTFolder = new GWTFolder();
        this.updateSessionManager();
        try {
            Folder folder = this.getThreadLocalRequest().isUserInRole(Config.DEFAULT_ADMIN_ROLE) ? OKMRepository.getInstance().getPersonalFolderBase(null) : OKMRepository.getInstance().getPersonalFolder(null);
            gWTFolder = GWTUtil.copy(folder);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "006"), e.getMessage());
        }
        log.debug("getPersonalFolder: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public GWTFolder getTemplatesFolder() throws OKMException {
        log.debug("getTemplateFolder()");
        GWTFolder gWTFolder = new GWTFolder();
        this.updateSessionManager();
        try {
            Folder folder = OKMRepository.getInstance().getTemplatesFolder(null);
            gWTFolder = GWTUtil.copy(folder);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "006"), e.getMessage());
        }
        log.debug("getTemplatesFolder: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public void purgeTrash() throws OKMException {
        log.debug("purgeTrash()");
        this.updateSessionManager();
        try {
            OKMRepository.getInstance().purgeTrash(null);
        }
        catch (AccessDeniedException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "009"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "006"), e.getMessage());
        }
        log.debug("purgeTrash: void");
    }

    @Override
    public GWTFolder getTrashFolder() throws OKMException {
        log.debug("getTrashFolder()");
        GWTFolder gWTFolder = new GWTFolder();
        this.updateSessionManager();
        try {
            Folder folder = this.getThreadLocalRequest().isUserInRole(Config.DEFAULT_ADMIN_ROLE) ? OKMRepository.getInstance().getTrashFolderBase(null) : OKMRepository.getInstance().getTrashFolder(null);
            gWTFolder = GWTUtil.copy(folder);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "006"), e.getMessage());
        }
        log.debug("getTrashFolder: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public GWTFolder getRootFolder() throws OKMException {
        log.debug("getRootFolder()");
        GWTFolder gWTFolder = new GWTFolder();
        this.updateSessionManager();
        try {
            Folder folder = OKMRepository.getInstance().getRootFolder(null);
            gWTFolder = GWTUtil.copy(folder);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "006"), e.getMessage());
        }
        log.debug("getRootFolder: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public GWTFolder getMailFolder() throws OKMException {
        log.debug("getMailFolder()");
        GWTFolder gWTFolder = new GWTFolder();
        this.updateSessionManager();
        try {
            Folder folder = this.getThreadLocalRequest().isUserInRole(Config.DEFAULT_ADMIN_ROLE) ? OKMRepository.getInstance().getMailFolderBase(null) : OKMRepository.getInstance().getMailFolder(null);
            gWTFolder = GWTUtil.copy(folder);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "006"), e.getMessage());
        }
        log.debug("getMailFolder: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public GWTFolder getThesaurusFolder() throws OKMException {
        log.debug("getThesaurusFolder()");
        GWTFolder gWTFolder = new GWTFolder();
        this.updateSessionManager();
        try {
            Folder folder = OKMRepository.getInstance().getThesaurusFolder(null);
            gWTFolder = GWTUtil.copy(folder);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "006"), e.getMessage());
        }
        log.debug("getThesaurusFolder: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public GWTFolder getCategoriesFolder() throws OKMException {
        log.debug("getCategoriesFolder()");
        GWTFolder gWTFolder = new GWTFolder();
        this.updateSessionManager();
        try {
            Folder folder = OKMRepository.getInstance().getCategoriesFolder(null);
            gWTFolder = GWTUtil.copy(folder);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "006"), e.getMessage());
        }
        log.debug("getCategoriesFolder: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    @Override
    public String getPathByUUID(String uuid) throws OKMException {
        log.debug("getPathByUUID()");
        String path = "";
        this.updateSessionManager();
        try {
            path = OKMRepository.getInstance().getNodePath(null, uuid);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        return path;
    }

    @Override
    public String getUUIDByPath(String path) throws OKMException {
        log.debug("getUUIDByPath()");
        String uuid = "";
        this.updateSessionManager();
        try {
            uuid = OKMRepository.getInstance().getNodeUuid(null, path);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "015"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
        return uuid;
    }

    @Override
    public Boolean hasNode(String path) throws OKMException {
        log.debug("hasNode({})" + path);
        this.updateSessionManager();
        try {
            return OKMRepository.getInstance().hasNode(null, path);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("012", "024"), e.getMessage());
        }
    }
}

