/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMSearch;
import com.openkm.bean.QueryResult;
import com.openkm.bean.ResultSet;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.QueryParamsDAO;
import com.openkm.dao.bean.QueryParams;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTKeyword;
import com.openkm.frontend.client.bean.GWTQueryParams;
import com.openkm.frontend.client.bean.GWTQueryResult;
import com.openkm.frontend.client.bean.GWTResultSet;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMSearchService;
import com.openkm.frontend.client.util.KeywordComparator;
import com.openkm.frontend.client.util.QueryParamsComparator;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchServlet
extends OKMRemoteServiceServlet
implements OKMSearchService {
    private static Logger log = LoggerFactory.getLogger(SearchServlet.class);
    private static final long serialVersionUID = 8673521252684830906L;

    @Override
    public List<GWTQueryParams> getAllSearchs() throws OKMException {
        log.debug("getAllSearchs()");
        ArrayList<GWTQueryParams> resultList = new ArrayList<GWTQueryParams>();
        this.updateSessionManager();
        try {
            Iterator<QueryParams> it = OKMSearch.getInstance().getAllSearchs(null).iterator();
            while (it.hasNext()) {
                resultList.add(GWTUtil.copy(it.next()));
            }
            for (QueryParams params : QueryParamsDAO.findShared(this.getThreadLocalRequest().getRemoteUser())) {
                if (params.isDashboard()) continue;
                GWTQueryParams gWTQueryParams = GWTUtil.copy(params);
                gWTQueryParams.setShared(true);
                resultList.add(gWTQueryParams);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "006"), e.getMessage());
        }
        Collections.sort(resultList, QueryParamsComparator.getInstance());
        log.debug("getAllSearchs: {}", resultList);
        return resultList;
    }

    @Override
    public Integer saveSearch(GWTQueryParams params, String type) throws OKMException {
        log.debug("saveSearch({}, {}, {})", new Object[]{params, type});
        this.updateSessionManager();
        try {
            return OKMSearch.getInstance().saveSearch(null, GWTUtil.copy(params));
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "006"), e.getMessage());
        }
    }

    @Override
    public void deleteSearch(int id) throws OKMException {
        log.debug("deleteSearch()");
        this.updateSessionManager();
        try {
            OKMSearch.getInstance().deleteSearch(null, id);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "006"), e.getMessage());
        }
        log.debug("deleteSearch: void");
    }

    @Override
    public GWTResultSet findPaginated(GWTQueryParams params, int offset, int limit) throws OKMException {
        log.debug("findPaginated({}, {}, {})", new Object[]{params, offset, limit});
        ArrayList<GWTQueryResult> resultList = new ArrayList<GWTQueryResult>();
        GWTResultSet gwtResultSet = new GWTResultSet();
        QueryParams queryParams = new QueryParams();
        this.updateSessionManager();
        try {
            queryParams = GWTUtil.copy(params);
            ResultSet results = OKMSearch.getInstance().findPaginated(null, queryParams, offset, limit);
            for (QueryResult queryResult : results.getResults()) {
                GWTQueryResult gwtQueryResult = GWTUtil.copy(queryResult);
                resultList.add(gwtQueryResult);
            }
            gwtResultSet.setTotal(results.getTotal());
            gwtResultSet.setResults(resultList);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "019"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "006"), e.getMessage());
        }
        log.debug("findPaginated: {}", resultList);
        return gwtResultSet;
    }

    @Override
    public GWTResultSet find(GWTQueryParams params) throws OKMException {
        log.debug("find({})", (Object)params);
        ArrayList<GWTQueryResult> resultList = new ArrayList<GWTQueryResult>();
        GWTResultSet gwtResultSet = new GWTResultSet();
        QueryParams queryParams = new QueryParams();
        this.updateSessionManager();
        try {
            queryParams = GWTUtil.copy(params);
            List<QueryResult> results = OKMSearch.getInstance().find(null, queryParams);
            for (QueryResult queryResult : results) {
                GWTQueryResult gwtQueryResult = GWTUtil.copy(queryResult);
                resultList.add(gwtQueryResult);
            }
            gwtResultSet.setTotal(results.size());
            gwtResultSet.setResults(resultList);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "019"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "006"), e.getMessage());
        }
        log.debug("find: {}", resultList);
        return gwtResultSet;
    }

    @Override
    public List<GWTKeyword> getKeywordMap(List<String> filter) throws OKMException {
        log.debug("getKeywordMap()");
        ArrayList<GWTKeyword> selectedTop10 = new ArrayList<GWTKeyword>();
        ArrayList<GWTKeyword> keyList = new ArrayList<GWTKeyword>();
        int[] maxValues = new int[10];
        int countTop10 = 0;
        this.updateSessionManager();
        try {
            Map<String, Integer> keyMap = OKMSearch.getInstance().getKeywordMap(null, filter);
            for (String key : keyMap.keySet()) {
                GWTKeyword keyword = new GWTKeyword();
                keyword.setKeyword(key);
                keyword.setFrequency(keyMap.get(key));
                keyword.setTop10(false);
                if (countTop10 < 10) {
                    maxValues[countTop10] = keyword.getFrequency();
                    selectedTop10.add(keyword);
                    ++countTop10;
                } else {
                    Arrays.sort(maxValues);
                    if (maxValues[0] < keyword.getFrequency()) {
                        boolean found = false;
                        for (int index = 0; !found && index < selectedTop10.size(); ++index) {
                            if (((GWTKeyword)selectedTop10.get(index)).getFrequency() != maxValues[0]) continue;
                            found = true;
                            selectedTop10.remove(index);
                            maxValues[0] = keyword.getFrequency();
                            selectedTop10.add(keyword);
                        }
                    }
                }
                keyList.add(keyword);
            }
            Iterator<String> it = selectedTop10.iterator();
            while (it.hasNext()) {
                ((GWTKeyword)((Object)it.next())).setTop10(true);
            }
            Collections.sort(keyList, KeywordComparator.getInstance());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "006"), e.getMessage());
        }
        log.debug("getKeywordMap: {}", keyList);
        return keyList;
    }

    @Override
    public void share(int qpId) throws OKMException {
        log.debug("share({})", (Object)qpId);
        this.updateSessionManager();
        try {
            QueryParamsDAO.share(qpId, this.getThreadLocalRequest().getRemoteUser());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "024"), e.getMessage());
        }
        log.debug("share: void");
    }

    @Override
    public void unshare(int qpId) throws OKMException {
        log.debug("share({})", (Object)qpId);
        this.updateSessionManager();
        try {
            QueryParamsDAO.unshare(qpId, this.getThreadLocalRequest().getRemoteUser());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("008", "024"), e.getMessage());
        }
        log.debug("share: void");
    }
}

